/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.laf;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPasswordFieldUI;

public class PasswordLookAndFeel
extends BasicPasswordFieldUI {
    private CaretListener caretListener;
    private FocusListener focusListener;
    private KeyListener keyListener;
    private boolean keyTyped;

    public static ComponentUI createUI(JComponent component) {
        return new PasswordLookAndFeel();
    }

    @Override
    protected void installListeners() {
        final JPasswordField fld = (JPasswordField)this.getComponent();
        this.caretListener = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent event) {
                int len = fld.getPassword().length;
                if (event.getDot() != 0 || event.getMark() != len) {
                    fld.removeCaretListener(PasswordLookAndFeel.this.caretListener);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (fld.hasFocus() && !PasswordLookAndFeel.this.keyTyped) {
                                fld.selectAll();
                                fld.addCaretListener(PasswordLookAndFeel.this.caretListener);
                            }
                        }
                    });
                }
            }
        };
        this.focusListener = new FocusListener(){

            @Override
            public final void focusGained(FocusEvent event) {
                PasswordLookAndFeel.this.keyTyped = false;
                fld.selectAll();
                fld.addCaretListener(PasswordLookAndFeel.this.caretListener);
                fld.addKeyListener(PasswordLookAndFeel.this.keyListener);
            }

            @Override
            public final void focusLost(FocusEvent event) {
                fld.removeCaretListener(PasswordLookAndFeel.this.caretListener);
                fld.removeKeyListener(PasswordLookAndFeel.this.keyListener);
            }
        };
        this.keyListener = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                PasswordLookAndFeel.this.keyTyped = true;
                fld.removeCaretListener(PasswordLookAndFeel.this.caretListener);
                fld.removeKeyListener(PasswordLookAndFeel.this.keyListener);
            }
        };
        fld.addFocusListener(this.focusListener);
    }

    @Override
    protected void uninstallListeners() {
        JPasswordField fld = (JPasswordField)this.getComponent();
        fld.removeCaretListener(this.caretListener);
        fld.removeFocusListener(this.focusListener);
        fld.removeKeyListener(this.keyListener);
        this.caretListener = null;
        this.focusListener = null;
        this.keyListener = null;
    }
}

