/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.laf;

import com.metamatrix.toolbox.ui.UIDefaults;
import com.metamatrix.toolbox.ui.widget.laf.ButtonLookAndFeel;
import com.metamatrix.toolbox.ui.widget.laf.LookAndFeelUtilities;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumnModel;
import com.metamatrix.toolbox.ui.widget.table.TableHeaderButton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class TableHeaderButtonLookAndFeel
extends ButtonLookAndFeel {
    private static final TableHeaderButtonLookAndFeel INSTANCE = new TableHeaderButtonLookAndFeel();
    public static final String SORT_INDICATOR_COLOR = "Table.headerButtonSortIndicatorColor";
    public static final String SORT_INDICATOR_GAP = "Table.headerButtonSortIndicatorGap";
    private static Color sortColor = null;
    private static int sortGap = 0;
    private static int sortWth = 0;
    private static FontMetrics metrics = null;

    public static ComponentUI createUI(JComponent component) {
        return INSTANCE;
    }

    @Override
    public Dimension getMinimumSize(JComponent component) {
        TableHeaderButton button = (TableHeaderButton)component;
        if (button.getTableWidget().allowsMultipleColumnSorting()) {
            return this.getPreferredSize(component);
        }
        return super.getPreferredSize(component);
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        Dimension size = super.getPreferredSize(component);
        metrics = component.getFontMetrics(component.getFont());
        sortWth = metrics.charWidth('4') * 2;
        size.width += (sortWth + sortGap) * 2;
        return size;
    }

    @Override
    public void installDefaults(AbstractButton button) {
        if (!TableHeaderButtonLookAndFeel.areDefaultsInstalled()) {
            UIDefaults dflts = UIDefaults.getInstance();
            sortColor = dflts.getColor(SORT_INDICATOR_COLOR);
            sortGap = dflts.getInt(SORT_INDICATOR_GAP);
        }
        super.installDefaults(button);
    }

    @Override
    public void paint(Graphics canvas, JComponent component) {
        TableHeaderButton button = (TableHeaderButton)component;
        int prefWth = button.getPreferredSize().width;
        super.paint(canvas, component);
        EnhancedTableColumn col = button.getColumn();
        if (!col.isSorted() || button.getWidth() < prefWth) {
            return;
        }
        canvas.setColor(sortColor);
        int wth = sortWth;
        if (wth % 2 == 0) {
            --wth;
        }
        int hgt = (wth + 1) / 2;
        int shift = this.getTextShiftOffset();
        int x = LookAndFeelUtilities.VIEW_BOUNDS.x;
        x += (LookAndFeelUtilities.ICON_BOUNDS.x - shift - x - wth) / 2 + shift;
        int y = LookAndFeelUtilities.VIEW_BOUNDS.y + (LookAndFeelUtilities.VIEW_BOUNDS.height - hgt) / 2 + shift;
        if (!col.isSortedAscending()) {
            y += hgt - 1;
        }
        while (wth >= 0) {
            canvas.drawLine(x, y, x + wth, y);
            y = col.isSortedAscending() ? ++y : --y;
            ++x;
            wth -= 2;
        }
        EnhancedTableColumnModel colModel = button.getColumnModel();
        if (colModel.getSortedColumnCount() == 1) {
            return;
        }
        int priority = col.getSortPriority();
        if (priority <= 0) {
            return;
        }
        String text = String.valueOf(priority);
        x = LookAndFeelUtilities.TEXT_BOUNDS.x + LookAndFeelUtilities.TEXT_BOUNDS.width + sortGap - shift;
        x += (LookAndFeelUtilities.VIEW_BOUNDS.x + LookAndFeelUtilities.VIEW_BOUNDS.width - x - metrics.stringWidth(text)) / 2 + shift;
        y = LookAndFeelUtilities.VIEW_BOUNDS.y + (LookAndFeelUtilities.VIEW_BOUNDS.height - metrics.getHeight()) / 2 + metrics.getAscent() + shift;
        canvas.drawString(text, x, y);
    }
}

