/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.list;

import com.metamatrix.toolbox.ui.widget.URLLabelWidget;
import com.metamatrix.toolbox.ui.widget.text.TextContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class URLListCellRenderer
extends URLLabelWidget
implements ListCellRenderer {
    protected static final Rectangle BOUNDS = new Rectangle();
    private Border focusBorder = null;
    private Border noFocusBorder = null;

    public URLListCellRenderer() {
        this.initializeDefaultListCellRenderer();
    }

    public Component getListCellRendererComponent(JList list, Object value, int row, boolean isSelected, boolean hasFocus) {
        if (value == null) {
            return this;
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        if (hasFocus) {
            this.setBorder(this.focusBorder);
        } else {
            this.setBorder(this.noFocusBorder);
        }
        if (value instanceof Icon) {
            this.setIcon((Icon)value);
        } else {
            String text = value.toString();
            this.setText(text);
            if (text.equals("") || text.equals(" ")) {
                this.setToolTipText(null);
            } else if (list instanceof TextContainer && ((TextContainer)((Object)list)).isClipTipEnabled() && hasFocus) {
                Rectangle rowBounds = list.getCellBounds(row, row);
                rowBounds.width = list.getInsets().left + this.getInsets().left + this.getFontMetrics(this.getFont()).stringWidth(text);
                Container parent = list.getParent();
                if (!list.getBounds(BOUNDS).contains(rowBounds) || parent instanceof JViewport && parent.getWidth() < rowBounds.x + rowBounds.width) {
                    this.setToolTipText(text);
                } else if (this.getToolTipText() != null) {
                    this.setToolTipText(null);
                }
            }
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(Color.blue);
        }
        return this;
    }

    protected void initializeDefaultListCellRenderer() {
        this.noFocusBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        this.focusBorder = UIManager.getBorder("List.focusCellHighlightBorder");
        this.setOpaque(true);
    }
}

