/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.menu;

import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.TreeNodeEditor;
import com.metamatrix.toolbox.ui.widget.ListWidget;
import com.metamatrix.toolbox.ui.widget.PopupMenuFactory;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.TreeWidget;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeModel;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DefaultPopupMenuFactory
implements PopupMenuFactory {
    protected JPopupMenu createListPopupMenu(final ListWidget list) {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem item = new JMenuItem("Copy");
        item.addActionListener(new ActionListener(){
            final Clipboard clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();

            @Override
            public void actionPerformed(ActionEvent event) {
                Object val = list.getSelectedValue();
                if (val == null) {
                    return;
                }
                StringSelection selection = new StringSelection(val.toString());
                this.clipBoard.setContents(selection, selection);
            }
        });
        popupMenu.add(item);
        return popupMenu;
    }

    protected JPopupMenu createTablePopupMenu(final TableWidget table) {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem item = new JMenuItem("Copy");
        item.addActionListener(new ActionListener(){
            final Clipboard clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();

            @Override
            public void actionPerformed(ActionEvent event) {
                if (table.getSelectedColumnCount() != 1 || table.getSelectedRowCount() != 1) {
                    return;
                }
                StringSelection selection = new StringSelection(table.getValueAt(table.getSelectedRow(), table.getSelectedColumn()).toString());
                this.clipBoard.setContents(selection, selection);
            }
        });
        popupMenu.add(item);
        return popupMenu;
    }

    protected JPopupMenu createTreePopupMenu(final TreeWidget tree) {
        TreeNode node;
        TreeNodeEditor editor;
        final TreePath path = tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem item = new JMenuItem("Copy");
        item.addActionListener(new ActionListener(){
            final Clipboard clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();

            @Override
            public void actionPerformed(ActionEvent event) {
                if (tree.getSelectionCount() != 1) {
                    return;
                }
                StringSelection selection = new StringSelection(((TreeNode)path.getLastPathComponent()).getName());
                this.clipBoard.setContents(selection, selection);
            }
        });
        popupMenu.add(item);
        TreeModel model = tree.getModel();
        if (tree.isEditable() && model instanceof DefaultTreeModel && !(editor = ((DefaultTreeModel)model).getTreeView().getTreeNodeEditor()).isReadOnly((PropertiedObject)(node = (TreeNode)path.getLastPathComponent()), editor.getNamePropertyDefinition(node))) {
            popupMenu.addSeparator();
            item = new JMenuItem("Rename");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    tree.startEditingAtPath(path);
                }
            });
            popupMenu.add(item);
        }
        return popupMenu;
    }

    @Override
    public JPopupMenu getPopupMenu(Component context) {
        if (context instanceof TreeWidget) {
            return this.createTreePopupMenu((TreeWidget)context);
        }
        if (context instanceof TableWidget) {
            TableWidget table = (TableWidget)context;
            if (table.getCellSelectionEnabled()) {
                return this.createTablePopupMenu(table);
            }
        } else if (context instanceof ListWidget) {
            return this.createListPopupMenu((ListWidget)context);
        }
        return null;
    }
}

