/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.property;

import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.tree.directory.DirectoryEntryFilter;
import com.metamatrix.common.tree.directory.DirectoryEntryView;
import com.metamatrix.common.tree.directory.FileSystemEntry;
import com.metamatrix.common.tree.directory.FileSystemFilter;
import com.metamatrix.common.tree.directory.FileSystemView;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.DialogPanel;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.DirectoryChooserPanel;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.property.PropertyComponent;
import com.metamatrix.toolbox.ui.widget.property.PropertyComponentFactory;
import com.metamatrix.toolbox.ui.widget.property.PropertyValidationListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DirectoryEntryPropertyComponent
extends JPanel
implements PropertyComponent {
    private static final Color VALID_COLOR = new TextFieldWidget().getForeground();
    private static final Color INVALID_COLOR = Color.red;
    private DirectoryEntry currentValue;
    private TextFieldWidget fileNameField = new TextFieldWidget();
    private ButtonWidget moreButton;
    private String dialogTitle;
    private String initialPath = "C:\\";
    private Collection myFocusListenerList;
    private FileSystemView view;
    private boolean hasFocus = false;

    public DirectoryEntryPropertyComponent(String dialogTitle, String rootPath, DirectoryEntry homeEntry, int index) {
        super(new BorderLayout(0, 0));
        this.currentValue = homeEntry;
        this.dialogTitle = dialogTitle;
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent event) {
                if (DirectoryEntryPropertyComponent.this.hasFocus) {
                    return;
                }
                DirectoryEntryPropertyComponent.this.fireFocusGainedEvent();
                DirectoryEntryPropertyComponent.this.hasFocus = true;
            }

            @Override
            public void focusLost(FocusEvent event) {
                DirectoryEntryPropertyComponent.this.hasFocus = false;
                DirectoryEntryPropertyComponent.this.processFocusLostEvent(event);
            }
        };
        this.fileNameField = new TextFieldWidget();
        this.add(this.fileNameField);
        if (this.currentValue != null) {
            this.fileNameField.setText(this.currentValue.toString());
        }
        this.fileNameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryEntryPropertyComponent.this.textFieldActionPerformed();
            }
        });
        this.fileNameField.addFocusListener(focusListener);
        this.moreButton = new ButtonWidget("...");
        this.moreButton.setName("DirectoryEntryPropertyComponent.moreButton." + dialogTitle + '.' + index);
        Dimension size = new Dimension(this.moreButton.getPreferredSize().width, PropertyComponentFactory.HEIGHT);
        this.moreButton.setMinimumSize(size);
        this.moreButton.setPreferredSize(size);
        this.moreButton.setMaximumSize(size);
        this.moreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryEntryPropertyComponent.this.showDirectoryChooserDialog((Component)e.getSource());
            }
        });
        this.moreButton.addFocusListener(focusListener);
        this.add((Component)this.moreButton, "East");
        if (rootPath != null) {
            File rootDir = new File(rootPath);
            this.view = new FileSystemView(rootDir, true);
        } else {
            this.view = new FileSystemView();
        }
        if (this.currentValue != null) {
            FileSystemEntry entry = (FileSystemEntry)this.currentValue;
            if (entry.isFolder()) {
                this.view.setHome((TreeNode)entry);
            } else {
                this.view.setHome(this.view.getParent((TreeNode)entry));
            }
        } else {
            DirectoryEntry home = this.view.lookup(this.initialPath);
            if (home != null) {
                FileSystemEntry entry = (FileSystemEntry)home;
                if (entry.isFolder()) {
                    this.view.setHome((TreeNode)entry);
                } else {
                    this.view.setHome(this.view.getParent((TreeNode)entry));
                }
            }
        }
    }

    protected void processFocusLostEvent(final FocusEvent event) {
        Component focusComp;
        if (this.isShowing() && !event.isTemporary() && (focusComp = SwingUtilities.findFocusOwner(this.getRootPane())) == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DirectoryEntryPropertyComponent.this.processFocusLostEvent(event);
                }
            });
            return;
        }
        if (this.hasFocus) {
            return;
        }
        this.fireFocusLostEvent();
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void showDirectoryChooserDialog(Component c) {
        FileSystemFilter xmlFileFilter = new FileSystemFilter(this.view, new String[]{"xml"}, "Metadata Model files");
        FileSystemFilter prjFileFilter = new FileSystemFilter(this.view, new String[]{"prj"}, "Metadata Project files");
        DirectoryEntryFilter[] tnfArray = new DirectoryEntryFilter[]{xmlFileFilter, prjFileFilter};
        DirectoryChooserPanel cp = new DirectoryChooserPanel((DirectoryEntryView)this.view, 0, tnfArray);
        DialogWindow dw = new DialogWindow((Frame)null, this.dialogTitle, (DialogPanel)cp, true);
        dw.setSize(800, 400);
        dw.show();
        dw.setLocationRelativeTo(c);
        if (cp.getSelectedButton() == cp.getAcceptButton()) {
            this.currentValue = (DirectoryEntry)cp.getSelectedTreeNode();
            this.fileNameField.setText(this.currentValue.toString());
            this.fireActionEvent();
        }
    }

    private void textFieldActionPerformed() {
        String pathName = this.fileNameField.getText();
        DirectoryEntry entry = this.view.lookup(pathName);
        if (entry != null) {
            this.fileNameField.setForeground(VALID_COLOR);
            this.currentValue = entry;
        } else {
            this.fileNameField.setForeground(INVALID_COLOR);
        }
        this.fireActionEvent();
    }

    @Override
    public synchronized void addFocusListener(FocusListener l) {
        this.getFocusListenerList().add(l);
    }

    @Override
    public synchronized void removeFocusListener(FocusListener l) {
        this.getFocusListenerList().remove(l);
    }

    private Collection getFocusListenerList() {
        if (this.myFocusListenerList == null) {
            this.myFocusListenerList = new ArrayList();
        }
        return this.myFocusListenerList;
    }

    private void fireFocusGainedEvent() {
        FocusEvent event = new FocusEvent(this, 1004);
        Iterator iter = this.myFocusListenerList.iterator();
        while (iter.hasNext()) {
            ((FocusListener)iter.next()).focusGained(event);
        }
    }

    private void fireFocusLostEvent() {
        FocusEvent event = new FocusEvent(this, 1005);
        Iterator iter = this.myFocusListenerList.iterator();
        while (iter.hasNext()) {
            ((FocusListener)iter.next()).focusLost(event);
        }
    }

    protected void fireActionEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent newEvent = null;
        for (int ndx = listeners.length - 2; ndx >= 0; ndx -= 2) {
            if (listeners[ndx] != ActionListener.class) continue;
            if (newEvent == null) {
                newEvent = new ActionEvent(this, 1001, "");
            }
            ((ActionListener)listeners[ndx + 1]).actionPerformed(newEvent);
        }
    }

    @Override
    public Object getNullValue() {
        return null;
    }

    @Override
    public Object getValue() {
        return this.currentValue;
    }

    @Override
    public void setEnabled(boolean flag) {
        this.moreButton.setVisible(flag);
        this.fileNameField.setEnabled(flag);
    }

    @Override
    public void setPropertyValidationListener(PropertyValidationListener listener) {
    }

    @Override
    public void removePropertyValidationListener(PropertyValidationListener listener) {
    }

    @Override
    public void setValidity(boolean flag) {
        if (flag) {
            this.fileNameField.setForeground(VALID_COLOR);
        } else {
            this.fileNameField.setForeground(INVALID_COLOR);
        }
    }

    @Override
    public boolean isCurrentValueEqualTo(Object value) {
        boolean result = true;
        result = this.currentValue == null ? value == null : (value == null ? false : this.currentValue.equals(value));
        return result;
    }

    @Override
    public void editingStarted() {
    }

    @Override
    public void editingStopped() {
    }

    @Override
    public JComponent getSingleRowComponent() {
        return this;
    }

    @Override
    public String getSingleRowString() {
        if (this.currentValue == null) {
            return "";
        }
        return this.currentValue.toString();
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }
}

