/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.property;

import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.object.PropertyType;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.toolbox.ui.widget.AccumulatorPanel;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.ListWidget;
import com.metamatrix.toolbox.ui.widget.SpacerWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.URLLabelWidget;
import com.metamatrix.toolbox.ui.widget.URLTextFieldWidget;
import com.metamatrix.toolbox.ui.widget.list.URLListCellRenderer;
import com.metamatrix.toolbox.ui.widget.property.PropertyComponent;
import com.metamatrix.toolbox.ui.widget.property.PropertyComponentFactory;
import com.metamatrix.toolbox.ui.widget.property.PropertyValidationListener;
import com.metamatrix.toolbox.ui.widget.util.WidgetUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MultivaluedPropertyComponent
extends JPanel
implements PropertyComponent {
    private transient Object data;
    private List dataList;
    private ListWidget list;
    private boolean readOnly;
    private PropertyDefinition def;
    private ButtonWidget removeButton;
    private boolean hasFocus = false;
    private int ndx;
    private PropertiedObjectEditor editor;
    private PropertiedObject obj;
    protected Box buttonBox;
    protected FocusListener focusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent event) {
            if (MultivaluedPropertyComponent.this.hasFocus) {
                return;
            }
            MultivaluedPropertyComponent.this.fireFocusEvent(event);
            MultivaluedPropertyComponent.this.hasFocus = true;
        }

        @Override
        public void focusLost(FocusEvent event) {
            MultivaluedPropertyComponent.this.hasFocus = false;
            MultivaluedPropertyComponent.this.processFocusLostEvent(event);
        }
    };

    public MultivaluedPropertyComponent(PropertyDefinition def, Object data, boolean readOnly, int index, PropertiedObject object, PropertiedObjectEditor editor) {
        this.def = def;
        this.data = data;
        this.readOnly = readOnly;
        this.ndx = index;
        this.obj = object;
        this.editor = editor;
        this.initializeMultivaluedPropertyComponent();
    }

    protected void addButtonPressed() {
        String val = this.getInputValue();
        if (val != null) {
            this.dataList.add(val);
            this.updateList();
        }
    }

    protected String getInputValue() {
        String result = null;
        boolean tryAgain = true;
        while (tryAgain) {
            result = JOptionPane.showInputDialog(this, "Enter a value to add:", "Add a value", 1);
            if (result != null && !this.editor.isValidValue(this.obj, this.def, (Object)result)) {
                JOptionPane.showMessageDialog(this, "This entry is not a valid value.", "Invalid Entry", 0);
                continue;
            }
            tryAgain = false;
        }
        return result;
    }

    protected void moreButtonPressed() {
        AccumulatorPanel panel = new AccumulatorPanel(this.editor.getAllowedValues(this.obj, this.def), this.dataList);
        panel.setAllowsNewValues(!this.def.isConstrainedToAllowedValues());
        DialogWindow.show(this, "Select Values", panel);
        if (panel.getSelectedButton() == panel.getAcceptButton()) {
            this.dataList = panel.getValues();
            this.updateList();
        }
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    @Override
    public void addFocusListener(FocusListener listener) {
        this.listenerList.add(FocusListener.class, listener);
    }

    protected void fireFocusEvent(FocusEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        FocusEvent newEvent = null;
        for (int ndx = listeners.length - 2; ndx >= 0; ndx -= 2) {
            if (listeners[ndx] != FocusListener.class) continue;
            if (newEvent == null) {
                newEvent = new FocusEvent(this, event.getID(), event.isTemporary());
            }
            if (event.getID() == 1004) {
                ((FocusListener)listeners[ndx + 1]).focusGained(newEvent);
                continue;
            }
            ((FocusListener)listeners[ndx + 1]).focusLost(newEvent);
        }
    }

    protected List getList() {
        return this.dataList;
    }

    public ListWidget getListWidget() {
        return this.list;
    }

    protected ButtonWidget getRemoveButton() {
        return this.removeButton;
    }

    @Override
    public Object getValue() {
        return this.dataList.toArray().clone();
    }

    @Override
    public boolean isFocusTraversable() {
        return !this.readOnly;
    }

    protected void processFocusLostEvent(final FocusEvent event) {
        Component focusComp;
        if (this.isShowing() && !event.isTemporary() && (focusComp = SwingUtilities.findFocusOwner(this.getRootPane())) == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MultivaluedPropertyComponent.this.processFocusLostEvent(event);
                }
            });
            return;
        }
        if (this.hasFocus) {
            return;
        }
        this.list.clearSelection();
        this.fireFocusEvent(event);
    }

    protected void initializeMultivaluedPropertyComponent() {
        if (this.data != null) {
            Assertion.assertTrue((boolean)(this.data instanceof Object[]), (String)("Value must be of type Object[]. PropertyDefinition " + this.def.getDisplayName() + " passed value type " + this.data.getClass().getName()));
        }
        this.setLayout(new BoxLayout(this, 0));
        this.list = new ListWidget();
        if (this.def.getPropertyType().equals((Object)PropertyType.URL)) {
            this.list.setCellRenderer(new URLListCellRenderer());
        }
        if (this.readOnly) {
            this.list.setBackground(PropertyComponentFactory.DISABLED_BACKGROUND_COLOR);
        }
        this.dataList = new ArrayList();
        if (this.data != null) {
            Object[] array = (Object[])this.data;
            for (int ndx = 0; ndx < array.length; ++ndx) {
                this.dataList.add(array[ndx]);
            }
            this.list.setListData(array);
            this.list.setVisibleRowCount(this.dataList.size());
        } else {
            this.list.setVisibleRowCount(1);
        }
        this.list.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.list.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.list.setAlignmentY(0.0f);
        final EventListenerList listenerList = this.listenerList;
        this.list.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (!event.getPropertyName().equals("model")) {
                    return;
                }
                Object[] listeners = listenerList.getListenerList();
                ActionEvent newEvent = null;
                for (int ndx = listeners.length - 2; ndx >= 0; ndx -= 2) {
                    if (listeners[ndx] != ActionListener.class) continue;
                    if (newEvent == null) {
                        newEvent = new ActionEvent(MultivaluedPropertyComponent.this, 1001, "");
                    }
                    ((ActionListener)listeners[ndx + 1]).actionPerformed(newEvent);
                }
            }
        });
        this.add(this.list);
        JPanel vBox = new JPanel();
        vBox.setLayout(new BoxLayout(vBox, 1));
        vBox.setAlignmentY(0.0f);
        vBox.add(SpacerWidget.createVerticalExpandableSpacer());
        this.add(vBox);
        this.buttonBox = Box.createHorizontalBox();
        vBox.add(this.buttonBox);
        if (!this.readOnly) {
            this.list.addFocusListener(this.focusListener);
            this.list.setPrototypeCellValue("");
            int hgt = this.list.getFixedCellHeight();
            Dimension size = new Dimension(20, hgt);
            ButtonWidget addButton = null;
            if (!this.def.isConstrainedToAllowedValues()) {
                addButton = new ButtonWidget("+");
                addButton.setName("MultivaluedPropertyComponent.addButton." + this.def.getDisplayName() + '.' + this.ndx);
                addButton.setToolTipText("Add Value");
                size = new Dimension(addButton.getPreferredSize().width, hgt);
                addButton.setMinimumSize(size);
                addButton.setPreferredSize(size);
                addButton.setMaximumSize(size);
                addButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        MultivaluedPropertyComponent.this.addButtonPressed();
                    }
                });
                addButton.addFocusListener(this.focusListener);
                this.buttonBox.add(addButton);
                this.removeButton = new ButtonWidget("-");
                this.removeButton.setToolTipText("Remove Selected Value");
                this.removeButton.setName("MultivaluedPropertyComponent.removeButton." + this.def.getDisplayName() + '.' + this.ndx);
                size = new Dimension(this.removeButton.getPreferredSize().width, hgt);
                this.removeButton.setMinimumSize(size);
                this.removeButton.setPreferredSize(size);
                this.removeButton.setMaximumSize(size);
                this.removeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MultivaluedPropertyComponent.this.removeButtonPressed();
                            }
                        });
                    }
                });
                this.removeButton.addFocusListener(this.focusListener);
                this.buttonBox.add(this.removeButton);
                this.removeButton.setEnabled(false);
                this.list.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                boolean enableRemove = false;
                                if (MultivaluedPropertyComponent.this.list.getSelectedIndex() >= 0 && MultivaluedPropertyComponent.this.list.getSelectedValue() != null) {
                                    enableRemove = true;
                                }
                                MultivaluedPropertyComponent.this.removeButton.setEnabled(enableRemove);
                            }
                        });
                    }
                });
                if (this.def.getMultiplicity() != null && addButton != null && this.dataList != null) {
                    int dataCount = 0;
                    if (!this.dataList.isEmpty() && this.dataList.get(0) != null) {
                        dataCount = this.dataList.size();
                    }
                    boolean enable = dataCount < this.def.getMultiplicity().getMaximum();
                    addButton.setEnabled(enable);
                    if (!enable) {
                        addButton.setToolTipText("Number of values equal to max allowed");
                    }
                }
                ArrayList<ButtonWidget> buttonList = new ArrayList<ButtonWidget>(2);
                buttonList.add(addButton);
                buttonList.add(this.removeButton);
                WidgetUtilities.equalizeSizeConstraints(buttonList);
            }
            if (this.def.hasAllowedValues()) {
                ButtonWidget moreButton = new ButtonWidget("...");
                moreButton.setToolTipText("Set Value");
                moreButton.setName("MultivaluedPropertyComponent.moreButton." + this.def.getDisplayName() + '.' + this.ndx);
                moreButton.setAlignmentX(0.5f);
                moreButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        MultivaluedPropertyComponent.this.moreButtonPressed();
                    }
                });
                moreButton.addFocusListener(this.focusListener);
                size = this.def.isConstrainedToAllowedValues() ? new Dimension(moreButton.getPreferredSize().width, hgt) : new Dimension(addButton.getPreferredSize().width + this.removeButton.getPreferredSize().width, hgt);
                moreButton.setMinimumSize(size);
                moreButton.setPreferredSize(size);
                moreButton.setMaximumSize(size);
                this.buttonBox.add(moreButton);
                vBox.add(this.buttonBox);
            }
        } else {
            this.list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    MultivaluedPropertyComponent.this.list.clearSelection();
                }
            });
        }
    }

    protected void removeButtonPressed() {
        int[] indices = this.list.getSelectedIndices();
        if (indices == null) {
            return;
        }
        int ndx = indices.length;
        while (--ndx >= 0) {
            this.dataList.remove(indices[ndx]);
        }
        this.updateList();
    }

    @Override
    public void setEnabled(boolean flag) {
        this.readOnly = !flag;
    }

    @Override
    public Object getNullValue() {
        return null;
    }

    @Override
    public void setPropertyValidationListener(PropertyValidationListener listener) {
    }

    @Override
    public void removePropertyValidationListener(PropertyValidationListener listener) {
    }

    @Override
    public void setValidity(boolean flag) {
    }

    @Override
    public boolean isCurrentValueEqualTo(Object value) {
        List<Object> cl;
        Object[] previousData = (Object[])value;
        Object[] currentData = this.dataList.toArray();
        if (previousData == null && currentData == null) {
            return true;
        }
        if (previousData == null && currentData != null) {
            return false;
        }
        if (previousData != null && currentData == null) {
            return false;
        }
        if (previousData.length != currentData.length) {
            return false;
        }
        List<Object> pl = Arrays.asList(previousData);
        return pl.containsAll(cl = Arrays.asList(currentData)) && cl.containsAll(pl);
    }

    @Override
    public void editingStarted() {
    }

    @Override
    public void editingStopped() {
        this.list.clearSelection();
    }

    @Override
    public JComponent getSingleRowComponent() {
        if (this.readOnly) {
            if (this.def.getPropertyType().equals((Object)PropertyType.URL)) {
                return new URLLabelWidget(this.getSingleRowString());
            }
            return new LabelWidget(this.getSingleRowString());
        }
        if (this.def.getPropertyType().equals((Object)PropertyType.URL)) {
            return new URLTextFieldWidget(this.getSingleRowString());
        }
        return new TextFieldWidget(this.getSingleRowString());
    }

    @Override
    public String getSingleRowString() {
        String delimiter = this.def.getValueDelimiter();
        StringBuffer sb = new StringBuffer((String)this.dataList.get(0));
        for (int i = 1; i < this.dataList.size(); ++i) {
            sb.append(delimiter);
            sb.append((String)this.dataList.get(i));
        }
        return sb.toString();
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    @Override
    public void removeFocusListener(FocusListener listener) {
        this.listenerList.remove(FocusListener.class, listener);
    }

    protected void updateList() {
        this.list.setListData(this.dataList.toArray());
        JComponent parent = (JComponent)this.getParent();
        parent.setMaximumSize(null);
        parent.setMaximumSize(new Dimension(Short.MAX_VALUE, parent.getPreferredSize().height));
        if (this.dataList.size() > 0) {
            this.list.setSelectedIndex(0);
        }
    }
}

