/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.property;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.transaction.TransactionException;
import com.metamatrix.common.transaction.UserTransaction;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.property.MultivaluedPropertyComponent;
import com.metamatrix.toolbox.ui.widget.property.ObjectReferenceHandler;
import com.metamatrix.toolbox.ui.widget.property.PropertyChangeAdapter;
import com.metamatrix.toolbox.ui.widget.property.PropertyComponent;
import com.metamatrix.toolbox.ui.widget.property.PropertyComponentFactory;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ObjectReferencePropertyComponent
extends MultivaluedPropertyComponent
implements PropertyComponent {
    private ObjectReferenceHandler handler;
    private PropertyDefinition dfn;
    private PropertiedObject propertiedObject;
    private PropertiedObjectEditor propertiedObjectEditor;
    private Object currentValue;
    private PropertyChangeAdapter adapter;
    private ButtonWidget navigateButton;

    public ObjectReferencePropertyComponent(PropertyDefinition dfn, Object data, boolean readOnly, int index, PropertiedObject object, PropertiedObjectEditor editor, ObjectReferenceHandler handler, PropertyChangeAdapter adapter) {
        super(dfn, ObjectReferencePropertyComponent.getObjectArray(data), handler == null ? true : readOnly, index, object, editor);
        this.dfn = dfn;
        this.currentValue = data;
        this.propertiedObject = object;
        this.propertiedObjectEditor = editor;
        this.handler = handler;
        this.adapter = adapter;
        if (handler == null) {
            throw new IllegalArgumentException("ObjectReferenceHandler may not be null");
        }
        this.createCustomComponent();
    }

    @Override
    protected void moreButtonPressed() {
        this.addButtonPressed();
    }

    @Override
    protected void addButtonPressed() {
        if (this.dfn.getMultiplicity().getMaximum() > 1) {
            Object[] values;
            List<Object> listData = Collections.EMPTY_LIST;
            if (this.currentValue != null) {
                listData = Arrays.asList((Object[])this.currentValue);
            }
            if ((values = this.handler.getObjectReferences(this.propertiedObject, this.propertiedObjectEditor, this.dfn, listData)) != null) {
                this.getList().clear();
                this.getList().addAll(Arrays.asList(values));
                this.setValue(values);
            }
        } else {
            Object value = this.handler.getObjectReference(this.propertiedObject, this.propertiedObjectEditor, this.dfn, this.currentValue);
            if (value != null) {
                if (value == ObjectReferenceHandler.NULL_OBJECT) {
                    this.getList().clear();
                    this.currentValue = null;
                    this.setValue(null);
                } else {
                    this.getList().clear();
                    this.getList().add(value);
                    this.currentValue = value;
                    this.setValue(value);
                }
            }
        }
    }

    protected void setValue(Object value) {
        this.updateList();
        this.fireFocusEvent(new FocusEvent(this, 1005, true));
    }

    @Override
    public Object getValue() {
        if (this.getList().isEmpty()) {
            return null;
        }
        if (this.dfn.getMultiplicity().getMaximum() > 1) {
            return super.getValue();
        }
        return this.getList().get(0);
    }

    @Override
    public boolean isCurrentValueEqualTo(Object value) {
        Object currentValue;
        boolean result = false;
        if (this.dfn.getMultiplicity().getMaximum() > 1) {
            result = super.isCurrentValueEqualTo(value);
        } else if (value == null) {
            if (this.getList().size() == 0) {
                result = true;
            }
        } else if (this.getList().size() == 1 && (currentValue = this.getList().get(0)) != null && value.equals(currentValue)) {
            result = true;
        }
        return result;
    }

    private static Object[] getObjectArray(Object data) {
        if (data instanceof Object[]) {
            return (Object[])data;
        }
        Object[] value = new Object[]{data};
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected void removeButtonPressed() {
        block20: {
            int[] indices = this.getListWidget().getSelectedIndices();
            if (indices == null) {
                return;
            }
            int ndx = indices.length;
            while (--ndx >= 0) {
                this.getList().remove(indices[ndx]);
            }
            UserTransaction txn = this.propertiedObjectEditor.createWriteTransaction((Object)this);
            boolean wasErr = true;
            txn.begin();
            if (this.getList().isEmpty()) {
                this.propertiedObjectEditor.setValue(this.propertiedObject, this.dfn, null);
            } else if (this.dfn.getMultiplicity().getMaximum() > 1) {
                this.propertiedObjectEditor.setValue(this.propertiedObject, this.dfn, (Object)this.getList().toArray());
            } else {
                this.propertiedObjectEditor.setValue(this.propertiedObject, this.dfn, this.getList().get(0));
            }
            wasErr = false;
            try {
                if (wasErr) {
                    txn.rollback();
                    break block20;
                }
                txn.commit();
            }
            catch (TransactionException ex) {
                LogManager.logCritical((String)"PROPERTY", (Throwable)ex, (String)("Failed to " + (wasErr ? "rollback." : "commit.")));
            }
            break block20;
            catch (TransactionException e) {
                try {
                    LogManager.logCritical((String)"PROPERTY", (Throwable)e, (String)"[ObjectReferencePropertyComponent.removeValue] caught exception");
                }
                catch (Throwable throwable) {
                    try {
                        if (wasErr) {
                            txn.rollback();
                        } else {
                            txn.commit();
                        }
                    }
                    catch (TransactionException ex) {
                        LogManager.logCritical((String)"PROPERTY", (Throwable)ex, (String)("Failed to " + (wasErr ? "rollback." : "commit.")));
                    }
                    throw throwable;
                }
                try {
                    if (wasErr) {
                        txn.rollback();
                    }
                    txn.commit();
                }
                catch (TransactionException ex) {
                    LogManager.logCritical((String)"PROPERTY", (Throwable)ex, (String)("Failed to " + (wasErr ? "rollback." : "commit.")));
                }
            }
        }
        this.updateList();
    }

    private Object getSelectedValue() {
        Object result = null;
        if (this.dfn.getMultiplicity().getMaximum() > 1) {
            if (this.getList().size() > 1) {
                result = this.getListWidget().getSelectedValue();
            } else if (this.getList().size() == 1) {
                result = this.getList().get(0);
            }
        } else {
            result = this.currentValue;
        }
        return result;
    }

    protected void navigateButtonPressed() {
        this.adapter.setEditorComponentAfterEdit(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ObjectReferencePropertyComponent.this.handler.navigateTo(ObjectReferencePropertyComponent.this.getSelectedValue());
            }
        });
    }

    protected void createCustomComponent() {
        if (this.handler != null) {
            this.navigateButton = new ButtonWidget("?");
            this.navigateButton.setAlignmentX(0.5f);
            this.navigateButton.setToolTipText("Show this Object's Properties");
            this.navigateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ObjectReferencePropertyComponent.this.navigateButtonPressed();
                }
            });
            Dimension size = new Dimension(this.navigateButton.getPreferredSize().width, PropertyComponentFactory.HEIGHT);
            this.navigateButton.setMinimumSize(size);
            this.navigateButton.setPreferredSize(size);
            this.navigateButton.setMaximumSize(size);
            this.buttonBox.add(this.navigateButton);
            if (this.dfn.getMultiplicity().getMaximum() > 1) {
                this.navigateButton.setEnabled(this.getList().size() == 1 && this.handler.canNavigateTo(this.getList().get(0)));
                this.getListWidget().addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        if (ObjectReferencePropertyComponent.this.navigateButton != null) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    boolean enable = false;
                                    if (ObjectReferencePropertyComponent.this.getList().size() > 1) {
                                        enable = ObjectReferencePropertyComponent.this.getListWidget().getSelectedIndices().length == 1 && ObjectReferencePropertyComponent.this.handler.canNavigateTo(ObjectReferencePropertyComponent.this.getSelectedValue());
                                    } else if (ObjectReferencePropertyComponent.this.getList().size() == 1) {
                                        enable = ObjectReferencePropertyComponent.this.handler.canNavigateTo(ObjectReferencePropertyComponent.this.getList().get(0));
                                    }
                                    ObjectReferencePropertyComponent.this.navigateButton.setEnabled(enable);
                                }
                            });
                        }
                    }
                });
            } else {
                if (this.currentValue == null) {
                    this.navigateButton.setEnabled(false);
                } else {
                    this.navigateButton.setEnabled(this.handler.canNavigateTo(this.currentValue));
                }
                this.getListWidget().addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        if (ObjectReferencePropertyComponent.this.navigateButton != null) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    boolean enable = false;
                                    if (ObjectReferencePropertyComponent.this.getList().size() > 1) {
                                        enable = ObjectReferencePropertyComponent.this.getListWidget().getSelectedIndices().length == 1 && ObjectReferencePropertyComponent.this.handler.canNavigateTo(ObjectReferencePropertyComponent.this.getSelectedValue());
                                    } else if (ObjectReferencePropertyComponent.this.getList().size() == 1) {
                                        enable = ObjectReferencePropertyComponent.this.handler.canNavigateTo(ObjectReferencePropertyComponent.this.getList().get(0));
                                    }
                                    ObjectReferencePropertyComponent.this.navigateButton.setEnabled(enable);
                                }
                            });
                        }
                    }
                });
            }
        }
    }
}

