/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.property;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.transaction.TransactionException;
import com.metamatrix.common.transaction.UserTransaction;
import com.metamatrix.common.util.crypto.Encryptor;
import com.metamatrix.toolbox.ui.UIConstants;
import com.metamatrix.toolbox.ui.UIDefaults;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.PasswordButton;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.property.PropertyChangeAdapter;
import com.metamatrix.toolbox.ui.widget.property.PropertyComponentFactory;
import com.metamatrix.toolbox.ui.widget.property.PropertyDefinitionLabel;
import com.metamatrix.toolbox.ui.widget.property.PropertySelectionEvent;
import com.metamatrix.toolbox.ui.widget.property.PropertySelectionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.FocusManager;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;

public class PropertiedObjectPanel
extends JPanel
implements UIConstants {
    private static final String DEFAULT_NAME_COLUMN_NAME = "Name";
    private static final String DEFAULT_VALUE_COLUMN_NAME = "Value";
    private static final int GAP = UIDefaults.getInstance().getInt("Spacer.horizontalLength");
    private static final String NAME_ID = "PropertyPanel.NameCell.";
    private static final String VALUE_ID = "PropertyPanel.ValueCell.";
    static final String LOG_CONTEXT = "PROPERTY";
    private PropertiedObject propObj;
    private JComponent[][] propComps = null;
    private PropertyChangeAdapter adapter;
    private PropertiedObjectEditor editor;
    private Object xActionSrc;
    private JPanel propsPanel = new JPanel(null){

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            int wth = this.getWidth();
            if (wth > 0) {
                size.width = wth;
            }
            return size;
        }
    };
    private final JPanel hdr = new JPanel(null);
    private JScrollPane scroller;
    private final LabelWidget nameColLabel = new LabelWidget("Name");
    private final LabelWidget valColLabel = new LabelWidget("Value"){

        @Override
        public Dimension getPreferredSize() {
            int wth = PropertiedObjectPanel.this.propsPanel.getWidth();
            if (wth > 0) {
                return new Dimension(wth - ((PropertiedObjectPanel)PropertiedObjectPanel.this).nameColLabel.getPreferredSize().width, super.getPreferredSize().height);
            }
            return super.getPreferredSize();
        }
    };
    private PropertyComponentFactory factory;
    private boolean showHidden = false;
    private boolean showExpert = false;
    private boolean showToolTips = true;
    private boolean showRequired = false;
    private boolean showInvalid = false;
    private boolean showOptional = true;
    private boolean readOnlyForced = false;
    private Collection propertiesToFilterOut = Collections.EMPTY_LIST;
    private Collection propertiesToDisplay = Collections.EMPTY_LIST;
    private int currentWth;
    private boolean isFocusCycleRoot;

    public PropertiedObjectPanel(PropertiedObjectEditor editor, Encryptor encryptor) {
        this(editor, encryptor, null);
    }

    public PropertiedObjectPanel(PropertiedObjectEditor editor, Encryptor encryptor, Object transactionSource) {
        super(new BorderLayout());
        this.xActionSrc = transactionSource == null ? this : transactionSource;
        this.adapter = new PropertyChangeAdapter(editor, this.xActionSrc);
        this.editor = editor;
        this.factory = new PropertyComponentFactory(encryptor);
        this.factory.setPropertiedObjectEditor(editor);
        this.factory.setPropertyChangeAdapter(this.adapter);
        this.scroller = new JScrollPane(this.propsPanel){

            @Override
            protected JViewport createViewport() {
                return new JViewport(){

                    private int positionAdjustment(int parentWidth, int childWidth, int childAt) {
                        if (childAt >= 0 && childWidth + childAt <= parentWidth) {
                            return 0;
                        }
                        if (childAt <= 0 && childWidth + childAt >= parentWidth) {
                            return 0;
                        }
                        if (childAt > 0 && childWidth <= parentWidth) {
                            return -childAt + parentWidth - childWidth;
                        }
                        if (childAt >= 0 && childWidth >= parentWidth) {
                            return -childAt;
                        }
                        if (childAt <= 0 && childWidth <= parentWidth) {
                            return -childAt;
                        }
                        if (childAt < 0 && childWidth >= parentWidth) {
                            return -childAt + parentWidth - childWidth;
                        }
                        return 0;
                    }

                    @Override
                    public void scrollRectToVisible(Rectangle bounds) {
                        int dy;
                        Component view = this.getView();
                        if (view == null) {
                            return;
                        }
                        if (!view.isValid()) {
                            this.validateView();
                        }
                        if ((dy = this.positionAdjustment(this.getHeight(), bounds.height, bounds.y)) != 0) {
                            Point viewPosition = this.getViewPosition();
                            Dimension viewSize = view.getSize();
                            int startY = viewPosition.y;
                            Dimension extent = this.getExtentSize();
                            viewPosition.y -= dy;
                            if (view.isValid()) {
                                if (viewPosition.y + extent.height > viewSize.height) {
                                    viewPosition.y = Math.max(0, viewSize.height - extent.height);
                                } else if (viewPosition.y < 0) {
                                    viewPosition.y = 0;
                                }
                            }
                            if (viewPosition.y != startY) {
                                this.setViewPosition(viewPosition);
                                this.scrollUnderway = false;
                            }
                        }
                    }

                    private void validateView() {
                        if (SwingUtilities.isEventDispatchThread()) {
                            Component validateRoot = null;
                            for (Container c = this; c != null; c = c.getParent()) {
                                if (!c.isDisplayable()) {
                                    return;
                                }
                                if (!(c instanceof JComponent) || !((JComponent)c).isValidateRoot()) continue;
                                validateRoot = c;
                                break;
                            }
                            if (validateRoot == null) {
                                return;
                            }
                            Component root = null;
                            for (Component c = validateRoot; c != null; c = c.getParent()) {
                                if (!c.isDisplayable()) {
                                    return;
                                }
                                if (!(c instanceof Window)) continue;
                                root = c;
                                break;
                            }
                            if (root == null) {
                                return;
                            }
                            validateRoot.validate();
                            RepaintManager rm = RepaintManager.currentManager(this);
                            if (rm != null) {
                                rm.removeInvalidComponent((JComponent)validateRoot);
                            }
                        } else {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    this.validateView();
                                }
                            });
                        }
                    }
                };
            }
        };
        this.sizeColumnsToFitViewport(this.scroller);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.adapter != null) {
            this.adapter.addPropertyChangeListener(listener);
        }
    }

    public void addPropertySelectionListener(PropertySelectionListener listener) {
        this.listenerList.add(PropertySelectionListener.class, listener);
    }

    public void clear() {
        this.setPropertiedObject(null);
    }

    public void clearHiddenPropertyDefinitions() {
        this.propertiesToFilterOut = Collections.EMPTY_LIST;
    }

    public void createComponent() {
        this.propsPanel.setLayout(new BoxLayout(this.propsPanel, 1));
        this.propsPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        Border border = UIDefaults.getInstance().getBorder("Button.border");
        this.nameColLabel.setBorder(border);
        this.valColLabel.setBorder(border);
        this.valColLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, this.valColLabel.getPreferredSize().height));
        this.hdr.setLayout(new BoxLayout(this.hdr, 0));
        this.hdr.add(this.nameColLabel);
        this.hdr.add(this.valColLabel);
        this.scroller.setColumnHeaderView(this.hdr);
        this.scroller.getVerticalScrollBar().setUnitIncrement(new TextFieldWidget().getPreferredSize().height);
        this.add((Component)this.scroller, "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                int viewWth = PropertiedObjectPanel.this.scroller.getViewport().getWidth();
                if (PropertiedObjectPanel.this.propsPanel.getWidth() > viewWth) {
                    int x = PropertiedObjectPanel.this.nameColLabel.getWidth();
                    int wth = viewWth - x;
                    PropertiedObjectPanel.this.valColLabel.setLocation(x, PropertiedObjectPanel.this.valColLabel.getY());
                    Dimension size = new Dimension(wth, PropertiedObjectPanel.this.valColLabel.getHeight());
                    PropertiedObjectPanel.this.valColLabel.setSize(size);
                    if (PropertiedObjectPanel.this.propComps != null) {
                        int ndx = PropertiedObjectPanel.this.propComps.length;
                        while (--ndx >= 0) {
                            JComponent comp = PropertiedObjectPanel.this.propComps[ndx][1];
                            comp.setLocation(x, comp.getY());
                            size = new Dimension(wth, comp.getHeight());
                            comp.setSize(size);
                        }
                        PropertiedObjectPanel.this.propsPanel.setSize(viewWth, PropertiedObjectPanel.this.propsPanel.getHeight());
                    }
                }
                PropertiedObjectPanel.this.valColLabel.revalidate();
            }
        });
        MouseInputAdapter resizeListener = new MouseInputAdapter(){
            JComponent hdr;
            int origX;

            private JComponent getResizingHeader(JComponent hdr, int x) {
                if (x >= hdr.getWidth() - 3) {
                    return hdr;
                }
                if (hdr == PropertiedObjectPanel.this.valColLabel && x < 3) {
                    return PropertiedObjectPanel.this.nameColLabel;
                }
                return null;
            }

            private int getX(MouseEvent event) {
                Point point = event.getPoint();
                SwingUtilities.convertPointToScreen(point, event.getComponent());
                return point.x;
            }

            @Override
            public void mouseDragged(MouseEvent event) {
                int minWth;
                if (this.hdr == null) {
                    return;
                }
                int x = this.getX(event);
                int delta = this.origX - x;
                int wth = this.hdr.getWidth() - delta;
                if (wth < (minWth = this.hdr.getMinimumSize().width)) {
                    wth = minWth;
                    delta = this.hdr.getWidth() - minWth;
                }
                Dimension size = new Dimension(wth, this.hdr.getHeight());
                this.hdr.setSize(size);
                this.hdr.setPreferredSize(size);
                if (this.hdr == PropertiedObjectPanel.this.nameColLabel) {
                    PropertiedObjectPanel.this.valColLabel.setLocation(PropertiedObjectPanel.this.valColLabel.getX() - delta, PropertiedObjectPanel.this.valColLabel.getY());
                    if (PropertiedObjectPanel.this.propComps != null) {
                        int ndx = PropertiedObjectPanel.this.propComps.length;
                        while (--ndx >= 0) {
                            JComponent comp = PropertiedObjectPanel.this.propComps[ndx][0];
                            size = new Dimension(comp.getWidth() - delta, comp.getHeight());
                            comp.setSize(size);
                            comp.setPreferredSize(size);
                            comp.setMinimumSize(size);
                            comp.setMaximumSize(size);
                            comp = PropertiedObjectPanel.this.propComps[ndx][1];
                            comp.setLocation(comp.getX() - delta, comp.getY());
                        }
                    }
                    wth = PropertiedObjectPanel.this.propsPanel.getParent().getWidth();
                    if (PropertiedObjectPanel.this.propsPanel.getWidth() - delta < wth) {
                        size = new Dimension(wth - this.hdr.getWidth(), PropertiedObjectPanel.this.valColLabel.getHeight());
                        PropertiedObjectPanel.this.valColLabel.setSize(size);
                        PropertiedObjectPanel.this.valColLabel.setPreferredSize(size);
                        delta = 0;
                    }
                } else {
                    wth = PropertiedObjectPanel.this.propsPanel.getParent().getWidth();
                    if (PropertiedObjectPanel.this.propsPanel.getWidth() - delta < wth) {
                        delta = wth - (PropertiedObjectPanel.this.propsPanel.getWidth() - delta);
                        wth = PropertiedObjectPanel.this.nameColLabel.getWidth() + delta;
                        size = new Dimension(wth, PropertiedObjectPanel.this.nameColLabel.getHeight());
                        PropertiedObjectPanel.this.nameColLabel.setSize(size);
                        PropertiedObjectPanel.this.nameColLabel.setPreferredSize(size);
                        if (PropertiedObjectPanel.this.propComps != null) {
                            int ndx = PropertiedObjectPanel.this.propComps.length;
                            while (--ndx >= 0) {
                                JComponent comp = PropertiedObjectPanel.this.propComps[ndx][0];
                                size = new Dimension(comp.getWidth() + delta, comp.getHeight());
                                comp.setSize(size);
                                comp.setPreferredSize(size);
                                comp.setMinimumSize(size);
                                comp.setMaximumSize(size);
                                comp = PropertiedObjectPanel.this.propComps[ndx][1];
                                comp.setLocation(comp.getX() - delta, comp.getY());
                            }
                        }
                        delta = 0;
                    }
                }
                size = new Dimension(PropertiedObjectPanel.this.propsPanel.getWidth() - delta, PropertiedObjectPanel.this.propsPanel.getHeight());
                PropertiedObjectPanel.this.propsPanel.setSize(size);
                PropertiedObjectPanel.this.propsPanel.revalidate();
                this.origX = x;
                PropertiedObjectPanel.this.currentWth = PropertiedObjectPanel.this.nameColLabel.getWidth();
            }

            @Override
            public void mouseMoved(MouseEvent event) {
                JComponent hdr = this.getResizingHeader((JComponent)event.getComponent(), event.getX());
                if (hdr != null) {
                    hdr.setCursor(Cursor.getPredefinedCursor(11));
                } else {
                    event.getComponent().setCursor(Cursor.getDefaultCursor());
                }
            }

            @Override
            public void mousePressed(MouseEvent event) {
                this.hdr = this.getResizingHeader((JComponent)event.getComponent(), event.getX());
                if (this.hdr != null) {
                    this.origX = this.getX(event);
                }
            }
        };
        this.nameColLabel.addMouseListener(resizeListener);
        this.nameColLabel.addMouseMotionListener(resizeListener);
        this.valColLabel.addMouseListener(resizeListener);
        this.valColLabel.addMouseMotionListener(resizeListener);
        this.nameColLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, this.nameColLabel.getPreferredSize().height));
        this.valColLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, this.valColLabel.getPreferredSize().height));
    }

    protected JComponent createComponentFromPropertyDefinition(final PropertyDefinition def, Object val, final boolean isReadOnly, final int ndx, final PropertyDefinitionLabel nameComp) {
        JComponent valComp = this.factory.createComponentForPropertyDefinition(def, val, isReadOnly, ndx);
        valComp.setName(VALUE_ID + def.getDisplayName() + '.' + ndx);
        nameComp.setLabelFor(valComp);
        final int finalNdx = ndx;
        if (this.adapter != null && !isReadOnly && def.isModifiable()) {
            JComboBox comboBox;
            FocusListener focusListener = new FocusListener(){

                @Override
                public void focusGained(FocusEvent event) {
                    JViewport port = PropertiedObjectPanel.this.scroller.getViewport();
                    Component comp = event.getComponent();
                    port.scrollRectToVisible(SwingUtilities.convertRectangle(comp, comp.getBounds(), port));
                    PropertiedObjectPanel.this.adapter.setPropertyDefinition(def);
                    PropertiedObjectPanel.this.adapter.setEditorComponentBeforeEdit((JComponent)event.getSource());
                }

                @Override
                public void focusLost(FocusEvent event) {
                    char[] pwd;
                    final JComponent comp = (JComponent)event.getSource();
                    if (comp instanceof PasswordButton) {
                        return;
                    }
                    PropertiedObjectPanel.this.adapter.setPropertyDefinition(def);
                    PropertiedObjectPanel.this.adapter.focusLost(event);
                    if (comp instanceof JPasswordField && (pwd = ((JPasswordField)comp).getPassword()) != null && pwd.length > 0) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JComponent newComp;
                                if (!comp.isShowing()) {
                                    return;
                                }
                                Container parent = comp.getParent();
                                parent.remove(comp);
                                ((PropertiedObjectPanel)PropertiedObjectPanel.this).propComps[finalNdx][1] = newComp = PropertiedObjectPanel.this.createComponentFromPropertyDefinition(def, new String(pwd), isReadOnly, ndx, nameComp);
                                parent.add(newComp);
                                newComp.invalidate();
                                PropertiedObjectPanel.this.validate();
                                parent.repaint();
                            }
                        });
                    }
                    if (PropertiedObjectPanel.this.showInvalid) {
                        nameComp.refreshDisplay(!PropertiedObjectPanel.this.hasValidValue(def, PropertyChangeAdapter.getValueFromJComponent((JComponent)event.getSource(), true)));
                    }
                }
            };
            final ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    PropertiedObjectPanel.this.adapter.setPropertyDefinition(def);
                    PropertiedObjectPanel.this.adapter.actionPerformed(event);
                    if (PropertiedObjectPanel.this.showInvalid) {
                        nameComp.refreshDisplay(!PropertiedObjectPanel.this.hasValidValue(def, PropertyChangeAdapter.getValueFromJComponent((JComponent)event.getSource(), true)));
                    }
                }
            };
            JComponent comp = valComp;
            if (valComp instanceof JComboBox && (comboBox = (JComboBox)valComp).isEditable()) {
                comp = (JComponent)comboBox.getEditor().getEditorComponent();
            }
            comp.addFocusListener(focusListener);
            if (comp instanceof PasswordButton) {
                ((PasswordButton)comp).addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent event) {
                        actionListener.actionPerformed(new ActionEvent(event.getSource(), 1001, null));
                    }
                });
            } else {
                try {
                    Method meth = comp.getClass().getMethod("addActionListener", ActionListener.class);
                    if (meth != null) {
                        meth.invoke((Object)comp, actionListener);
                    }
                }
                catch (Exception err) {
                    LogManager.logCritical((String)LOG_CONTEXT, (Throwable)err, (String)"Failed to add ActionListener to property editor component.");
                }
            }
        }
        final EventListenerList listenerList = this.listenerList;
        valComp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                Object[] listeners = listenerList.getListenerList();
                PropertySelectionEvent newEvent = null;
                for (int ndx2 = listeners.length - 2; ndx2 >= 0; ndx2 -= 2) {
                    if (listeners[ndx2] != PropertySelectionListener.class) continue;
                    if (newEvent == null) {
                        newEvent = new PropertySelectionEvent((Object)PropertiedObjectPanel.this, def);
                    }
                    ((PropertySelectionListener)listeners[ndx2 + 1]).propertySelected(newEvent);
                }
            }
        });
        if (valComp.isFocusTraversable()) {
            valComp.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    FocusManager.getCurrentManager().focusNextComponent((Component)event.getSource());
                }
            }, KeyStroke.getKeyStroke(40, 0, true), 0);
            valComp.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    FocusManager.getCurrentManager().focusPreviousComponent((Component)event.getSource());
                }
            }, KeyStroke.getKeyStroke(38, 0, true), 0);
        }
        return valComp;
    }

    protected JComponent[][] createModelFromProperties() {
        JComponent[][] propComps = new JComponent[0][2];
        if (this.propObj == null) {
            return propComps;
        }
        List defs = this.propertiesToDisplay != null ? this.filterPropertyDefinitionList(this.propertiesToDisplay) : this.filterPropertyDefinitionList(this.editor.getPropertyDefinitions(this.propObj));
        propComps = new JComponent[defs.size()][2];
        Iterator iterator = defs.iterator();
        int ndx = 0;
        while (iterator.hasNext()) {
            boolean isReadOnly;
            PropertyDefinition def = (PropertyDefinition)iterator.next();
            boolean bl = isReadOnly = this.readOnlyForced || this.editor.isReadOnly(this.propObj);
            if (!isReadOnly) {
                isReadOnly = this.editor.isReadOnly(this.propObj, def);
            }
            Object val = this.editor.getValue(this.propObj, def);
            boolean isInvalid = false;
            if (this.showInvalid) {
                isInvalid = !this.hasValidValue(def, val);
            }
            final PropertyDefinitionLabel nameComp = new PropertyDefinitionLabel(def, this.showToolTips, this.showRequired, isInvalid);
            nameComp.setName(NAME_ID + def.getDisplayName() + '.' + ndx);
            nameComp.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    nameComp.getLabelFor().requestFocus();
                }
            });
            propComps[ndx][0] = nameComp;
            propComps[ndx][1] = this.createComponentFromPropertyDefinition(def, val, isReadOnly, ndx, nameComp);
            ++ndx;
        }
        return propComps;
    }

    protected List filterPropertyDefinitionList(Collection defs) {
        ArrayList<PropertyDefinition> result = new ArrayList<PropertyDefinition>(defs.size());
        for (PropertyDefinition def : defs) {
            boolean addToList = true;
            if (!this.showExpert && def.isExpert()) {
                addToList = false;
            }
            if (!this.showHidden && def.isHidden()) {
                addToList = false;
            }
            if (!this.showOptional && !def.isRequired()) {
                addToList = false;
            }
            if (this.propertiesToFilterOut.contains(def)) {
                addToList = false;
            }
            if (def.isMasked() && (this.readOnlyForced || !def.isModifiable() || this.editor.isReadOnly(this.propObj))) {
                addToList = false;
            }
            if (!addToList) continue;
            result.add(def);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List getInvalidDefinitions() {
        UserTransaction txn;
        ArrayList<PropertyDefinition> result;
        block16: {
            result = Collections.EMPTY_LIST;
            txn = null;
            boolean wasErr = true;
            txn = this.editor.createReadTransaction();
            txn.begin();
            List defs = this.filterPropertyDefinitionList(this.editor.getPropertyDefinitions(this.propObj));
            result = new ArrayList<PropertyDefinition>(defs.size());
            Iterator iterator = defs.iterator();
            int ndx = 0;
            while (iterator.hasNext()) {
                PropertyDefinition def = (PropertyDefinition)iterator.next();
                if (!this.hasValidValue(def, PropertyChangeAdapter.getValueFromJComponent(this.propComps[ndx][1], true))) {
                    result.add(def);
                }
                ++ndx;
            }
            wasErr = false;
            try {
                if (wasErr) {
                    txn.rollback();
                    break block16;
                }
                txn.commit();
            }
            catch (TransactionException err) {
                LogManager.logCritical((String)LOG_CONTEXT, (Throwable)err, (String)("Failed to " + (wasErr ? "rollback." : "commit.")));
            }
            break block16;
            catch (TransactionException e) {
                try {
                    LogManager.logCritical((String)LOG_CONTEXT, (Throwable)e, (String)"[PropertiedObjectPanel.getInvalidDefinitions] caught exception");
                }
                catch (Throwable throwable) {
                    try {
                        if (wasErr) {
                            txn.rollback();
                        } else {
                            txn.commit();
                        }
                    }
                    catch (TransactionException err) {
                        LogManager.logCritical((String)LOG_CONTEXT, (Throwable)err, (String)("Failed to " + (wasErr ? "rollback." : "commit.")));
                    }
                    throw throwable;
                }
                try {
                    if (wasErr) {
                        txn.rollback();
                    }
                    txn.commit();
                }
                catch (TransactionException err) {
                    LogManager.logCritical((String)LOG_CONTEXT, (Throwable)err, (String)("Failed to " + (wasErr ? "rollback." : "commit.")));
                }
            }
        }
        txn = null;
        return result;
    }

    public int getNameColumnHeaderWidth() {
        return this.currentWth;
    }

    public PropertiedObject getPropertiedObject() {
        return this.propObj;
    }

    public PropertyChangeAdapter getPropertyChangeAdapter() {
        return this.adapter;
    }

    public PropertyComponentFactory getPropertyComponentFactory() {
        return this.factory;
    }

    public Component[] getPropertyComponents() {
        if (this.propComps == null) {
            return null;
        }
        Component[] comps = new Component[this.propComps.length];
        for (int ndx = 0; ndx < this.propComps.length; ++ndx) {
            comps[ndx] = this.propComps[ndx][1];
        }
        return comps;
    }

    public JScrollPane getScrollPane() {
        return this.scroller;
    }

    public boolean getShowExpertProperties() {
        return this.showExpert;
    }

    public boolean getShowHiddenProperties() {
        return this.showHidden;
    }

    public boolean getShowInvalidProperties() {
        return this.showInvalid;
    }

    public boolean getShowOptionalProperties() {
        return this.showOptional;
    }

    public boolean getShowRequiredProperties() {
        return this.showRequired;
    }

    protected boolean hasValidValue(PropertyDefinition def, Object value) {
        if (value == null) {
            value = def.getDefaultValue();
        } else if (def.isMasked() && value instanceof char[]) {
            value = new String((char[])value);
        }
        return this.editor.isValidValue(this.propObj, def, value) && (value != null || !def.isRequired());
    }

    public boolean isEditing() {
        if (this.adapter == null) {
            return false;
        }
        return this.adapter.isEditing();
    }

    @Override
    public boolean isFocusCycleRoot() {
        return this.isFocusCycleRoot;
    }

    public boolean isReadOnlyForced() {
        return this.readOnlyForced;
    }

    public void refreshDisplay() {
        this.refreshDisplay(true);
    }

    protected void refreshDisplay(boolean defaultValuesUsed) {
        this.propsPanel.removeAll();
        this.propComps = this.createModelFromProperties();
        for (int ndx = 0; ndx < this.propComps.length; ++ndx) {
            JPanel panel = new JPanel(null);
            panel.setLayout(new BoxLayout(panel, 0));
            panel.add(this.propComps[ndx][0]);
            panel.add(this.propComps[ndx][1]);
            panel.setMaximumSize(new Dimension(Short.MAX_VALUE, panel.getPreferredSize().height));
            this.propsPanel.add(panel);
        }
        this.resizeNameColumn();
        if (this.adapter != null) {
            this.adapter.setPropertiedObject(this.propObj);
        }
        this.propsPanel.revalidate();
        this.propsPanel.repaint();
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.adapter != null) {
            this.adapter.removePropertyChangeListener(listener);
        }
    }

    public void removePropertySelectionListener(PropertySelectionListener listener) {
        this.listenerList.remove(PropertySelectionListener.class, listener);
    }

    @Override
    public void requestFocus() {
        if (this.propComps != null && this.propComps.length > 0) {
            this.propComps[0][1].requestFocus();
        }
    }

    protected void resizeNameColumn() {
        int hdrWth;
        JComponent name;
        int wth;
        if (this.currentWth == 0) {
            wth = this.nameColLabel.getMinimumSize().width;
            if (this.propComps != null) {
                int ndx = this.propComps.length;
                while (--ndx >= 0) {
                    name = this.propComps[ndx][0];
                    name.setPreferredSize(null);
                    wth = Math.max(wth, name.getPreferredSize().width);
                }
            }
            hdrWth = (wth += GAP) + this.scroller.getInsets().left;
        } else {
            wth = this.currentWth - this.scroller.getInsets().left;
            hdrWth = this.currentWth;
        }
        if (this.propComps != null) {
            int ndx = this.propComps.length;
            while (--ndx >= 0) {
                name = this.propComps[ndx][0];
                Dimension prefSize = new Dimension(wth, name.getPreferredSize().height);
                name.setMinimumSize(prefSize);
                name.setPreferredSize(prefSize);
                name.setMaximumSize(prefSize);
                name.invalidate();
            }
        }
        this.nameColLabel.setPreferredSize(null);
        this.nameColLabel.setPreferredSize(new Dimension(hdrWth, this.nameColLabel.getPreferredSize().height));
        this.nameColLabel.revalidate();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.currentWth == 0 && width > 0 && height > 0) {
            this.currentWth = this.nameColLabel.getPreferredSize().width;
        }
    }

    public void setColumnHeaderNames(String nameColumnName, String valueColumnName) {
        if (nameColumnName == null) {
            this.nameColLabel.setText(DEFAULT_NAME_COLUMN_NAME);
        } else {
            this.nameColLabel.setText(nameColumnName);
        }
        if (valueColumnName == null) {
            this.valColLabel.setText(DEFAULT_VALUE_COLUMN_NAME);
        } else {
            this.valColLabel.setText(valueColumnName);
        }
        this.resizeNameColumn();
    }

    @Override
    public void setFocusCycleRoot(boolean isFocusCycleRoot) {
        this.isFocusCycleRoot = isFocusCycleRoot;
    }

    public void setHiddenPropertyDefinitions(Collection propertiesToFilterOut) {
        this.propertiesToFilterOut = propertiesToFilterOut == null ? Collections.EMPTY_LIST : propertiesToFilterOut;
    }

    public void setNameColumnHeaderWidth(int width) {
        this.currentWth = width;
    }

    public void resetNameColumnHeaderWidth(boolean refreshImmediately) {
        this.currentWth = 0;
        if (refreshImmediately) {
            this.refreshDisplay();
        }
    }

    public void setPropertiedObject(PropertiedObject propObj) {
        this.setPropertiedObject(propObj, null, null);
    }

    public void setPropertiedObject(PropertiedObject propObj, PropertiedObjectEditor editor) {
        this.setPropertiedObject(propObj, editor, null);
    }

    public void setPropertiedObject(PropertiedObject propObj, List propertiesToDisplay) {
        this.setPropertiedObject(propObj, null, propertiesToDisplay);
    }

    public void setPropertiedObject(PropertiedObject propObj, PropertiedObjectEditor editor, List propertiesToDisplay) {
        int ndx;
        PropertiedObject oldPropObj = null;
        Component comp = SwingUtilities.findFocusOwner(this);
        if (comp != null && propObj != null) {
            oldPropObj = this.propObj;
            for (ndx = 0; ndx < this.propComps.length && this.propComps[ndx][1] != comp; ++ndx) {
            }
            if (ndx == this.propComps.length) {
                ndx = 0;
            }
        }
        this.propObj = propObj;
        this.factory.setPropertiedObject(propObj);
        this.propertiesToDisplay = propertiesToDisplay;
        if (editor != null) {
            this.editor = editor;
            this.factory.setPropertiedObjectEditor(editor);
            this.adapter = new PropertyChangeAdapter(editor, this.xActionSrc);
            this.factory.setPropertyChangeAdapter(this.adapter);
        }
        if (this.adapter != null) {
            this.adapter.setPropertiedObject(propObj);
        }
        this.refreshDisplay(true);
        if (comp != null && propObj != null) {
            if (oldPropObj == propObj && ndx < this.propComps.length) {
                this.propComps[ndx][1].requestFocus();
            } else if (this.propComps.length > 0) {
                this.propComps[0][1].requestFocus();
            }
        }
    }

    public void setPropertyChangeAdapter(PropertyChangeAdapter adapter) {
        if (this.factory != null) {
            this.factory.setPropertyChangeAdapter(adapter);
        }
        this.adapter = adapter;
    }

    public void setReadOnlyForced(boolean forced) {
        this.readOnlyForced = forced;
    }

    public void setShowColumnHeaders(boolean showHeaders) {
        if (showHeaders) {
            this.scroller.setColumnHeaderView(this.hdr);
        } else {
            this.scroller.setColumnHeaderView(null);
        }
    }

    public void setShowExpertProperties(boolean showExpert) {
        this.showExpert = showExpert;
    }

    public void setShowHiddenProperties(boolean showHidden) {
        this.showHidden = showHidden;
    }

    public void setShowInvalidProperties(boolean showInvalid) {
        this.showInvalid = showInvalid;
    }

    public void setShowOptionalProperties(boolean show) {
        this.showOptional = show;
    }

    public void setShowRequiredProperties(boolean showRequired) {
        this.showRequired = showRequired;
    }

    public void setShowToolTips(boolean showToolTips) {
        this.showToolTips = showToolTips;
    }

    protected void sizeColumnsToFitViewport(final JScrollPane scroller) {
        final JScrollBar bar = scroller.getVerticalScrollBar();
        bar.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent event) {
                JViewport port;
                int portWth;
                int wth = PropertiedObjectPanel.this.propsPanel.getWidth();
                int delta = wth - (portWth = (port = scroller.getViewport()).getWidth());
                if (delta != bar.getWidth()) {
                    return;
                }
                int minWth = ((PropertiedObjectPanel)PropertiedObjectPanel.this).propsPanel.getMinimumSize().width;
                if (wth - delta < minWth) {
                    return;
                }
                int hgt = PropertiedObjectPanel.this.propsPanel.getHeight();
                if (hgt == 0) {
                    hgt = ((PropertiedObjectPanel)PropertiedObjectPanel.this).propsPanel.getPreferredSize().height;
                }
                Component[] comps = PropertiedObjectPanel.this.propsPanel.getComponents();
                int ndx = comps.length;
                while (--ndx >= 0) {
                    Component comp = ((Container)comps[ndx]).getComponent(1);
                    comp.setSize(comp.getWidth() - delta, comp.getHeight());
                }
                PropertiedObjectPanel.this.propsPanel.setSize(portWth, hgt);
                PropertiedObjectPanel.this.valColLabel.setSize(PropertiedObjectPanel.this.valColLabel.getWidth() - delta, PropertiedObjectPanel.this.valColLabel.getHeight());
                PropertiedObjectPanel.this.propsPanel.revalidate();
            }
        });
    }
}

