/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.property;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.transaction.TransactionException;
import com.metamatrix.common.transaction.UserTransaction;
import com.metamatrix.toolbox.ui.widget.PasswordButton;
import com.metamatrix.toolbox.ui.widget.property.PropertyComponent;
import com.metamatrix.toolbox.ui.widget.property.PropertyComponentFactory;
import com.metamatrix.toolbox.ui.widget.property.PropertyValidationListener;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.ParseException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.event.EventListenerList;
import javax.swing.text.JTextComponent;

public class PropertyChangeAdapter
extends KeyAdapter
implements PropertyValidationListener {
    private Object originalValue;
    private PropertiedObject entity;
    private PropertiedObjectEditor objectEditor;
    private PropertyDefinition def;
    private Object transactionSource;
    private JComponent currentEditorComponent;
    private boolean isEditing = false;
    private EventListenerList listenerList;
    private boolean matchedOrigVal;
    private boolean transactionPending = false;

    public PropertyChangeAdapter(PropertiedObjectEditor editor, Object transactionSource) {
        this.objectEditor = editor;
        this.transactionSource = transactionSource;
        this.listenerList = new EventListenerList();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listenerList.add(PropertyChangeListener.class, listener);
    }

    public void setTransactionPending(boolean isPending) {
        this.transactionPending = isPending;
    }

    public boolean isTransactionPending() {
        return this.transactionPending;
    }

    protected void firePropertyChangeEvent(Object source, Object value) {
        Object[] listeners = this.listenerList.getListenerList();
        PropertyChangeEvent event = null;
        for (int ndx = listeners.length - 2; ndx >= 0; ndx -= 2) {
            if (listeners[ndx] != PropertyChangeListener.class) continue;
            if (event == null) {
                event = new PropertyChangeEvent(source, this.def.getName(), this.originalValue, value);
            }
            ((PropertyChangeListener)listeners[ndx + 1]).propertyChange(event);
        }
    }

    public void setPropertiedObject(PropertiedObject entity) {
        this.entity = entity;
        this.transactionPending = false;
    }

    public void setPropertyDefinition(PropertyDefinition propertyDefinition) {
        this.def = propertyDefinition;
        this.transactionPending = false;
    }

    public boolean isEditing() {
        return this.isEditing;
    }

    public void setEditorComponentBeforeEdit(JComponent editor) {
        this.originalValue = PropertyChangeAdapter.getValueFromJComponent(editor, false);
        this.matchedOrigVal = true;
        this.setValidityListenerForJComponent(editor);
        this.currentEditorComponent = editor;
        this.isEditing = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void setEditorComponentAfterEdit(JComponent editor) {
        block41: {
            Object value;
            block43: {
                block42: {
                    UserTransaction txn;
                    block40: {
                        if (this.def == null || this.entity == null || this.objectEditor.isReadOnly(this.entity, this.def)) break block41;
                        this.isEditing = true;
                        boolean setValue = true;
                        value = PropertyChangeAdapter.getValueFromJComponent(editor, true);
                        if (editor instanceof PasswordButton && value instanceof char[]) {
                            value = new String((char[])value);
                        }
                        Object nullValue = "";
                        if (editor == this.currentEditorComponent) {
                            LogManager.logDetail((String)"PROPERTY", (Object[])new Object[]{"[PropertyChangeAdapter] examining change for type " + this.def.getPropertyType().getClassName()});
                            if (value == null && (value = this.def.getDefaultValue()) != null) {
                                this.setJComponentValue(editor, value);
                            }
                            if (value != null && value.equals(this.def.getDefaultValue())) {
                                editor.setForeground(Color.blue);
                            }
                            if (editor instanceof PropertyComponent) {
                                PropertyComponent c = (PropertyComponent)((Object)editor);
                                nullValue = c.getNullValue();
                                if (c.isCurrentValueEqualTo(this.originalValue)) {
                                    setValue = false;
                                }
                                c.editingStopped();
                            } else if (value == null && this.originalValue == null) {
                                LogManager.logDetail((String)"PROPERTY", (Object[])new Object[]{"[PropertyChangeAdapter] detected no change, value = null"});
                                setValue = false;
                            } else if (value != null && value.equals(this.originalValue)) {
                                if (this.def.isMasked()) {
                                    LogManager.logDetail((String)"PROPERTY", (Object[])new Object[]{"[PropertyChangeAdapter] detected no change to masked field"});
                                } else {
                                    LogManager.logDetail((String)"PROPERTY", (Object[])new Object[]{"[PropertyChangeAdapter] detected no change, value = " + value});
                                }
                                setValue = false;
                            }
                        } else {
                            setValue = false;
                        }
                        if (!setValue) break block41;
                        this.firePropertyChangeEvent(editor, value);
                        if (this.def.isMasked()) {
                            LogManager.logDetail((String)"PROPERTY", (Object[])new Object[]{"[PropertyChangeAdapter] detected masked value change"});
                        } else {
                            LogManager.logDetail((String)"PROPERTY", (Object[])new Object[]{"[PropertyChangeAdapter] detected value change, value = " + value});
                        }
                        if (!this.isValid(value, nullValue)) break block42;
                        this.transactionPending = true;
                        txn = null;
                        boolean wasErr = true;
                        txn = this.objectEditor.createWriteTransaction(this.transactionSource);
                        txn.begin();
                        if (value == null || value.equals(this.def.getDefaultValue())) {
                            LogManager.logDetail((String)"PROPERTY", (Object[])new Object[]{"[PropertyChangeAdapter] nulling value"});
                            this.objectEditor.setValue(this.entity, this.def, null);
                        } else {
                            if (this.def.isMasked()) {
                                LogManager.logDetail((String)"PROPERTY", (Object[])new Object[]{"[PropertyChangeAdapter] setting masked value"});
                            } else {
                                LogManager.logDetail((String)"PROPERTY", (Object[])new Object[]{"[PropertyChangeAdapter] setting value to " + value});
                            }
                            this.objectEditor.setValue(this.entity, this.def, value);
                        }
                        this.originalValue = value;
                        wasErr = false;
                        try {
                            if (txn == null) break block40;
                            if (wasErr) {
                                txn.rollback();
                                break block40;
                            }
                            txn.commit();
                        }
                        catch (TransactionException err) {
                            LogManager.logCritical((String)"PROPERTY", (Throwable)err, (String)("Failed to " + (wasErr ? "rollback." : "commit.")));
                        }
                        break block40;
                        catch (TransactionException e) {
                            try {
                                LogManager.logCritical((String)"PROPERTY", (Throwable)e, (String)"[PropertyChangeAdapter] caught exception");
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (txn != null) {
                                        if (wasErr) {
                                            txn.rollback();
                                        } else {
                                            txn.commit();
                                        }
                                    }
                                }
                                catch (TransactionException err) {
                                    LogManager.logCritical((String)"PROPERTY", (Throwable)err, (String)("Failed to " + (wasErr ? "rollback." : "commit.")));
                                }
                                throw throwable;
                            }
                            try {
                                if (txn == null) break block40;
                                if (wasErr) {
                                    txn.rollback();
                                }
                                txn.commit();
                            }
                            catch (TransactionException err) {
                                LogManager.logCritical((String)"PROPERTY", (Throwable)err, (String)("Failed to " + (wasErr ? "rollback." : "commit.")));
                            }
                        }
                    }
                    txn = null;
                    this.transactionPending = false;
                    break block43;
                }
                if (this.def.isMasked()) {
                    LogManager.logDetail((String)"PROPERTY", (Object[])new Object[]{"[PropertyChangeAdapter] detected invalid masked value"});
                } else {
                    LogManager.logDetail((String)"PROPERTY", (Object[])new Object[]{"[PropertyChangeAdapter] detected invalid value = " + value});
                }
            }
            if (editor instanceof JComboBox) {
                JComboBox comboBox = (JComboBox)editor;
                if (value != null && !this.def.isRequired()) {
                    int count = comboBox.getItemCount();
                    boolean foundNullObject = false;
                    for (int i = 0; i < count; ++i) {
                        if (comboBox.getItemAt(i) != PropertyComponentFactory.NULL_OBJECT) continue;
                        foundNullObject = true;
                        break;
                    }
                    if (!foundNullObject) {
                        DefaultComboBoxModel model = (DefaultComboBoxModel)comboBox.getModel();
                        model.addElement(PropertyComponentFactory.NULL_OBJECT);
                    }
                }
            }
        }
        this.isEditing = false;
    }

    protected void setValidityListenerForJComponent(JComponent comp) {
        if (comp instanceof PropertyComponent) {
            ((PropertyComponent)((Object)comp)).setPropertyValidationListener(this);
        } else if (comp instanceof JTextComponent && !(comp instanceof JPasswordField)) {
            ((JTextComponent)comp).addKeyListener(this);
        } else if (comp instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)comp;
            ((JTextComponent)comboBox.getEditor().getEditorComponent()).addKeyListener(this);
            comboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertyChangeAdapter.this.checkComboBoxValidity(e.getSource());
                }
            });
        }
    }

    protected void removeValidityListenerForJComponent(JComponent comp) {
        if (comp instanceof PropertyComponent) {
            ((PropertyComponent)((Object)comp)).removePropertyValidationListener(this);
        } else if (comp instanceof JTextComponent && !(comp instanceof JPasswordField)) {
            ((JTextComponent)comp).removeKeyListener(this);
        } else if (comp instanceof JComboBox) {
            ((JTextComponent)((JComboBox)comp).getEditor().getEditorComponent()).removeKeyListener(this);
        }
    }

    @Override
    public void isValueValid(PropertyComponent source, Object value) {
        boolean result = this.isValid(value, source.getNullValue());
        source.setValidity(result);
    }

    public boolean isValid(Object value, Object nullObject) {
        boolean result = false;
        result = this.def.isMasked() ? true : (value != null && nullObject != null && value.equals(nullObject) ? this.objectEditor.isValidValue(this.entity, this.def, null) : this.objectEditor.isValidValue(this.entity, this.def, value));
        return result;
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() instanceof JTextComponent) {
            boolean matchesOrigVal;
            JTextComponent c = (JTextComponent)e.getSource();
            String value = c.getText();
            boolean bl = matchesOrigVal = value.equals(this.originalValue) || value.length() == 0 && this.originalValue == null;
            if (this.matchedOrigVal && !matchesOrigVal || !this.matchedOrigVal && matchesOrigVal) {
                this.firePropertyChangeEvent(c, value);
                boolean bl2 = this.matchedOrigVal = !this.matchedOrigVal;
            }
            if (c instanceof JPasswordField) {
                return;
            }
            if (this.isValid(value, "")) {
                c.setForeground(Color.black);
            } else {
                c.setForeground(Color.red);
            }
        }
    }

    public void focusLost(FocusEvent event) {
        JComponent comp = (JComponent)event.getSource();
        this.setEditorComponentAfterEdit(comp);
        this.removeValidityListenerForJComponent(comp);
    }

    public void actionPerformed(ActionEvent e) {
        JComponent c = (JComponent)e.getSource();
        this.setEditorComponentAfterEdit(c);
    }

    public static Object getValueFromJComponent(JComponent comp, boolean finished) {
        Object result = new String("PropertyChangeAdapter cannot support " + comp.getClass().getName());
        if (comp instanceof PropertyComponent) {
            PropertyComponent c = (PropertyComponent)((Object)comp);
            result = c.getValue();
            if (finished) {
                c.editingStopped();
            } else {
                c.editingStarted();
            }
            if (result != null && result.equals(c.getNullValue())) {
                result = null;
            }
        } else if (comp instanceof JTextComponent) {
            JTextComponent c = (JTextComponent)comp;
            result = c.getText();
            if (result != null) {
                if (((String)result).trim().length() == 0) {
                    result = null;
                } else {
                    DateFormat dateFmt = (DateFormat)c.getClientProperty("Date.format");
                    if (dateFmt != null) {
                        try {
                            result = dateFmt.parse((String)result);
                        }
                        catch (ParseException err) {
                            comp.setForeground(Color.red);
                            result = null;
                        }
                    }
                }
            }
        } else if (comp instanceof JCheckBox) {
            result = ((JCheckBox)comp).isSelected() ? Boolean.TRUE : Boolean.FALSE;
        } else if (comp instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)comp;
            result = comboBox.getSelectedItem();
            if (result != null) {
                if (result instanceof String && ((String)result).trim().length() == 0) {
                    result = null;
                } else if (result == PropertyComponentFactory.NULL_OBJECT) {
                    result = null;
                }
            }
        } else if (comp instanceof PasswordButton) {
            result = ((PasswordButton)comp).getPassword();
        } else {
            LogManager.logCritical((String)"PROPERTY", (String)("[PropertyChangeAdapter] " + result));
        }
        return result;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listenerList.remove(PropertyChangeListener.class, listener);
    }

    private void checkComboBoxValidity(Object sourceComponent) {
        JComboBox comboBox;
        if (sourceComponent instanceof JComboBox && (comboBox = (JComboBox)sourceComponent).isEditable()) {
            if (this.isValid(comboBox.getSelectedItem(), "")) {
                comboBox.getEditor().getEditorComponent().setForeground(Color.black);
            } else {
                comboBox.getEditor().getEditorComponent().setForeground(Color.red);
            }
        }
    }

    public void setJComponentValue(JComponent component, Object value) {
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).setText(value.toString());
        } else if (component instanceof JComboBox) {
            ((JComboBox)component).setSelectedItem(value);
        }
    }
}

