/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.property;

import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.object.PropertyType;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.util.crypto.Encryptor;
import com.metamatrix.toolbox.ui.UIConstants;
import com.metamatrix.toolbox.ui.UIDefaults;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import com.metamatrix.toolbox.ui.widget.DialogPanel;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.PasswordButton;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.URLTextFieldWidget;
import com.metamatrix.toolbox.ui.widget.event.WidgetActionEvent;
import com.metamatrix.toolbox.ui.widget.property.DirectoryEntryPropertyComponent;
import com.metamatrix.toolbox.ui.widget.property.MultivaluedPropertyComponent;
import com.metamatrix.toolbox.ui.widget.property.ObjectReferenceHandler;
import com.metamatrix.toolbox.ui.widget.property.ObjectReferencePropertyComponent;
import com.metamatrix.toolbox.ui.widget.property.PropertyChangeAdapter;
import java.awt.Color;
import java.awt.Dimension;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.ListCellRenderer;

public class PropertyComponentFactory
implements UIConstants {
    public static final JComponent PROTOTYPE = new TextFieldWidget();
    public static final int HEIGHT = PropertyComponentFactory.PROTOTYPE.getPreferredSize().height;
    public static Color DISABLED_BACKGROUND_COLOR;
    public static Color ENABLED_BACKGROUND_COLOR;
    private static SimpleDateFormat dateFmt;
    public static final Object NULL_OBJECT;
    private PropertiedObject obj;
    private PropertiedObjectEditor editor;
    private PropertyChangeAdapter adapter;
    private ObjectReferenceHandler objectReferenceHandler;
    private ListCellRenderer objectReferenceRenderer;
    private Encryptor encryptor;

    public PropertyComponentFactory(Encryptor encryptor) {
        this.encryptor = encryptor;
    }

    public JComponent createComponentForPropertyDefinition(PropertyDefinition def, Object value, boolean isReadOnly, int index) {
        boolean dfltVal = false;
        if (value == null) {
            dfltVal = true;
            value = def.getDefaultValue();
        }
        JComponent comp = null;
        PropertyType type = def.getPropertyType();
        if (def.getMultiplicity().getMaximum() == 1) {
            if (isReadOnly || !def.isModifiable() || type.equals((Object)PropertyType.OBJECT_REFERENCE) && this.objectReferenceHandler == null) {
                if (type.equals((Object)PropertyType.BOOLEAN)) {
                    CheckBox cb = new CheckBox(){

                        @Override
                        public boolean isFocusTraversable() {
                            return false;
                        }
                    };
                    cb.setMinimumSize(new Dimension(cb.getMinimumSize().width, HEIGHT));
                    cb.setPreferredSize(new Dimension(cb.getPreferredSize().width, HEIGHT));
                    cb.setMaximumSize(new Dimension(Short.MAX_VALUE, HEIGHT));
                    if (value != null) {
                        cb.setSelected(new Boolean(value.toString()));
                    }
                    cb.setEnabled(false);
                    comp = cb;
                } else if (type.equals((Object)PropertyType.DATE)) {
                    comp = this.createDateField(def, value, false);
                } else if (type.equals((Object)PropertyType.OBJECT_REFERENCE)) {
                    if (this.objectReferenceHandler == null) {
                        Object[] mpcValue = value;
                        if (value != null && !(value instanceof Object[])) {
                            mpcValue = new Object[]{value};
                        }
                        MultivaluedPropertyComponent mvpcComponent = new MultivaluedPropertyComponent(def, mpcValue, isReadOnly, index, this.obj, this.editor);
                        if (this.objectReferenceRenderer != null) {
                            mvpcComponent.getListWidget().setCellRenderer(this.objectReferenceRenderer);
                        }
                        comp = mvpcComponent;
                    } else {
                        ObjectReferencePropertyComponent orComponent = new ObjectReferencePropertyComponent(def, value, isReadOnly, index, this.obj, this.editor, this.objectReferenceHandler, this.adapter);
                        if (this.objectReferenceRenderer != null) {
                            orComponent.getListWidget().setCellRenderer(this.objectReferenceRenderer);
                        }
                        comp = orComponent;
                    }
                    comp.setMaximumSize(new Dimension(Short.MAX_VALUE, comp.getPreferredSize().height));
                } else {
                    comp = type.equals((Object)PropertyType.URL) ? this.createURLTextField(def, value, false) : this.createTextField(def, value, false);
                }
            } else if (type.equals((Object)PropertyType.FILE)) {
                comp = new DirectoryEntryPropertyComponent(def.getDisplayName(), null, (DirectoryEntry)value, index);
                comp.setMaximumSize(new Dimension(Short.MAX_VALUE, comp.getPreferredSize().height));
            } else if (type.equals((Object)PropertyType.OBJECT_REFERENCE)) {
                if (this.objectReferenceHandler == null) {
                    Object[] mpcValue = value;
                    if (value != null && !(value instanceof Object[])) {
                        mpcValue = new Object[]{value};
                    }
                    MultivaluedPropertyComponent mvpcComponent = new MultivaluedPropertyComponent(def, mpcValue, isReadOnly, index, this.obj, this.editor);
                    if (this.objectReferenceRenderer != null) {
                        mvpcComponent.getListWidget().setCellRenderer(this.objectReferenceRenderer);
                    }
                    comp = mvpcComponent;
                } else {
                    ObjectReferencePropertyComponent orComponent = new ObjectReferencePropertyComponent(def, value, isReadOnly, index, this.obj, this.editor, this.objectReferenceHandler, this.adapter);
                    if (this.objectReferenceRenderer != null) {
                        orComponent.getListWidget().setCellRenderer(this.objectReferenceRenderer);
                    }
                    comp = orComponent;
                }
                comp.setMaximumSize(new Dimension(Short.MAX_VALUE, comp.getPreferredSize().height));
            } else if (def.hasAllowedValues()) {
                JComboBox<Object> cob;
                if (this.editor != null && this.obj != null) {
                    List allowedValues = this.editor.getAllowedValues(this.obj, def);
                    ArrayList<Object> displayedValues = new ArrayList<Object>(allowedValues);
                    if (value != null) {
                        if (!allowedValues.contains(value)) {
                            displayedValues.add(0, value);
                        }
                        if (!def.isRequired() && !def.hasDefaultValue()) {
                            displayedValues.add(NULL_OBJECT);
                        }
                    }
                    cob = new JComboBox<Object>(displayedValues.toArray());
                    cob.setSelectedItem(value);
                } else {
                    cob = new JComboBox();
                }
                cob.setEditable(!def.isConstrainedToAllowedValues());
                comp = cob;
            } else if (type.equals((Object)PropertyType.BOOLEAN)) {
                CheckBox cb = new CheckBox();
                cb.setMinimumSize(new Dimension(cb.getMinimumSize().width, HEIGHT));
                Dimension prefSize = new Dimension(cb.getPreferredSize().width, HEIGHT);
                cb.setPreferredSize(prefSize);
                cb.setMaximumSize(prefSize);
                if (value != null) {
                    cb.setSelected(new Boolean(value.toString()));
                }
                comp = cb;
            } else if (def.isMasked()) {
                if (value == null) {
                    JPasswordField pf = new JPasswordField();
                    pf.setMaximumSize(new Dimension(Short.MAX_VALUE, pf.getPreferredSize().height));
                    if (value != null) {
                        pf.setText(value.toString());
                    }
                    comp = pf;
                } else {
                    comp = new PasswordPropertyButton(def, ((String)value).toCharArray(), this.encryptor);
                }
            } else {
                comp = type.equals((Object)PropertyType.DATE) ? this.createDateField(def, value, true) : (type.equals((Object)PropertyType.URL) ? this.createURLTextField(def, value, true) : this.createTextField(def, value, true));
            }
        } else if (type.equals((Object)PropertyType.OBJECT_REFERENCE)) {
            if (this.objectReferenceHandler != null) {
                ObjectReferencePropertyComponent orComponent = new ObjectReferencePropertyComponent(def, value, isReadOnly, index, this.obj, this.editor, this.objectReferenceHandler, this.adapter);
                if (this.objectReferenceRenderer != null) {
                    orComponent.getListWidget().setCellRenderer(this.objectReferenceRenderer);
                }
                comp = orComponent;
            } else {
                Object[] mpcValue = value;
                if (value != null && !(value instanceof Object[])) {
                    mpcValue = new Object[]{value};
                }
                comp = new MultivaluedPropertyComponent(def, mpcValue, isReadOnly, index, this.obj, this.editor);
            }
        } else {
            comp = new MultivaluedPropertyComponent(def, value, isReadOnly, index, this.obj, this.editor);
        }
        comp.setAlignmentY(0.0f);
        if (value != null) {
            if (dfltVal) {
                comp.setForeground(Color.blue);
            } else if (!this.editor.isValidValue(this.obj, def, (Object)value)) {
                comp.setForeground(Color.red);
            }
        }
        return comp;
    }

    protected JComponent createDateField(PropertyDefinition definition, Object value, boolean editable) {
        DateFormat dateFmt = this.getDateFormat(definition, value);
        JComponent comp = value == null ? this.createTextField(definition, value, editable) : this.createTextField(definition, dateFmt.format(value), editable);
        comp.putClientProperty("Date.format", dateFmt);
        return comp;
    }

    protected JComponent createTextField(PropertyDefinition definition, Object value, final boolean editable) {
        TextFieldWidget fld = new TextFieldWidget(){

            @Override
            public boolean isFocusTraversable() {
                return editable;
            }
        };
        fld.setEditable(editable);
        if (value == null) {
            fld.setText("");
        } else {
            fld.setText(value.toString());
        }
        return fld;
    }

    protected JComponent createURLTextField(PropertyDefinition definition, Object value, final boolean editable) {
        URLTextFieldWidget fld = new URLTextFieldWidget(){

            @Override
            public boolean isFocusTraversable() {
                return editable;
            }
        };
        fld.setEditable(editable);
        if (value == null) {
            fld.setText("");
        } else {
            fld.setText(value.toString());
        }
        return fld;
    }

    protected DateFormat getDateFormat(PropertyDefinition definition, Object value) {
        if (dateFmt == null) {
            dateFmt = new SimpleDateFormat(UIDefaults.getInstance().getString("Date.format"));
        }
        return dateFmt;
    }

    protected PropertiedObject getPropertiedObject() {
        return this.obj;
    }

    protected PropertiedObjectEditor getPropertiedObjectEditor() {
        return this.editor;
    }

    protected PropertyChangeAdapter getPropertyChangeAdapter() {
        return this.adapter;
    }

    public void setPropertiedObject(PropertiedObject object) {
        this.obj = object;
    }

    public void setPropertiedObjectEditor(PropertiedObjectEditor editor) {
        this.editor = editor;
    }

    public void setPropertyChangeAdapter(PropertyChangeAdapter adapter) {
        this.adapter = adapter;
    }

    public void setObjectReferenceHandler(ObjectReferenceHandler handler) {
        this.objectReferenceHandler = handler;
    }

    public void setObjectReferenceRenderer(ListCellRenderer renderer) {
        this.objectReferenceRenderer = renderer;
    }

    static {
        dateFmt = null;
        NULL_OBJECT = new Object(){

            public String toString() {
                return "";
            }
        };
        LabelWidget w = new LabelWidget();
        ENABLED_BACKGROUND_COLOR = w.getBackground();
        w.setEnabled(false);
        DISABLED_BACKGROUND_COLOR = w.getBackground();
    }

    private class PasswordPropertyButton
    extends PasswordButton {
        private PasswordPropertyButton(PropertyDefinition def, char[] password, Encryptor encryptor) {
            super(password, encryptor);
        }

        @Override
        protected void accept(DialogPanel panel, WidgetActionEvent event) {
            if (PropertyComponentFactory.this.adapter == null) {
                return;
            }
            if (PropertyComponentFactory.this.editor != null && !PropertyComponentFactory.this.adapter.isValid(new String(this.getPassword()), null)) {
                event.destroy();
                JOptionPane.showMessageDialog(panel, "New password is invalid.", "Error", 0);
                return;
            }
            PropertyComponentFactory.this.adapter.setEditorComponentAfterEdit(this);
        }
    }
}

