/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.property;

import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.property.PropertyComponentFactory;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.BorderFactory;

public class PropertyDefinitionLabel
extends LabelWidget {
    private static final Color normalColor = new LabelWidget().getForeground();
    private static final Font normalFont = new LabelWidget().getFont();
    private static final Font requiredFont = new Font(normalFont.getName(), 1, normalFont.getSize());
    private static final Color requiredColor = Color.black;
    private static final Color invalidColor = Color.red;
    private static final Color requiresRestartColor = Color.BLUE;
    private static final String REQUIRES_RESTART_LABEL = " [REQUIRES RESTART]";
    private static final String REQUIRES_RESTART_TOOLTIP = " [Requires a restart or bounce of the server to take effect]";
    private static final int VERTICAL_MARGIN = PropertyComponentFactory.PROTOTYPE.getInsets().top;
    private PropertyDefinition def;
    private boolean showRequiredProperties = false;
    private static int lineY = 0;

    public PropertyDefinitionLabel(PropertyDefinition def, boolean showTooltip, boolean showRequiredProperties, boolean isInvalid) {
        String displayName = def.getDisplayName();
        if (def.getRequiresRestart()) {
            displayName = displayName + REQUIRES_RESTART_LABEL;
        }
        super.setText(displayName);
        this.def = def;
        this.showRequiredProperties = showRequiredProperties;
        if (showTooltip) {
            String text = def.getShortDescription();
            if (def.getRequiresRestart()) {
                text = text + REQUIRES_RESTART_TOOLTIP;
            }
            if (text != null && text.length() > 0) {
                this.setToolTipText(text);
            }
        }
        this.refreshDisplay(isInvalid);
        this.setVerticalAlignment(1);
        this.setBorder(BorderFactory.createEmptyBorder(VERTICAL_MARGIN, 0, VERTICAL_MARGIN, 0));
        if (lineY == 0) {
            lineY = this.getPreferredSize().height / 2;
        }
        this.setAlignmentY(0.0f);
    }

    public void refreshDisplay(boolean isInvalid) {
        if (isInvalid) {
            this.setForeground(invalidColor);
        } else if (this.def.getRequiresRestart()) {
            this.setForeground(requiresRestartColor);
        } else if (this.showRequiredProperties && this.def.isRequired()) {
            this.setForeground(requiredColor);
        } else {
            this.setForeground(normalColor);
        }
        if (this.showRequiredProperties && this.def.isRequired()) {
            this.setFont(requiredFont);
        } else {
            this.setFont(normalFont);
        }
    }

    public void setShowRequiredProperties(boolean showRequired) {
        this.showRequiredProperties = showRequired;
    }

    public PropertyDefinition getPropertyDefinition() {
        return this.def;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        FontMetrics fontMetrix = g.getFontMetrics(this.getFont());
        int width = this.getWidth();
        int textWidth = fontMetrix.stringWidth(this.getText());
        g.setColor(Color.gray);
        g.drawLine(textWidth, lineY, width, lineY);
    }
}

