/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.table;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.toolbox.ui.IconConstants;
import com.metamatrix.toolbox.ui.UIDefaults;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.SpacerWidget;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumnModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class AbstractTableOptionPanel
extends JScrollPane
implements IconConstants {
    private static final String NONE = "<None>";
    private final TableWidget table;
    private String[] colNames = null;
    private JComponent colsPanel = new JPanel();

    public AbstractTableOptionPanel(TableWidget table) {
        this.table = table;
        this.initializeAbstractTableOptionPanel();
    }

    protected JComponent addColumnPanel(int index) {
        final ColumnPanel colPanel = new ColumnPanel();
        this.colsPanel.add((Component)colPanel, index);
        ButtonWidget andButton = colPanel.getAndButton();
        andButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AbstractTableOptionPanel.this.handleAndAction(colPanel);
            }
        });
        JComboBox colBox = colPanel.getColumnsComboBox();
        colBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AbstractTableOptionPanel.this.handleColumnSelected(colPanel);
            }
        });
        ButtonWidget deleteButton = colPanel.getDeleteButton();
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AbstractTableOptionPanel.this.handleDeleteAction(colPanel);
            }
        });
        this.customizeColumnPanel(colPanel, andButton, deleteButton);
        return colPanel;
    }

    protected void customizeColumnPanel(JComponent columnPanel, ButtonWidget andButton, ButtonWidget deleteButton) {
    }

    public EnhancedTableColumn getColumn(int index) {
        try {
            return (EnhancedTableColumn)this.table.getColumn(((JComboBox)this.getColumnPanel(index).getComponent(1)).getSelectedItem());
        }
        catch (IllegalArgumentException err) {
            return null;
        }
    }

    protected JComponent getColumnPanel(int index) {
        return (JComponent)this.colsPanel.getComponent(index);
    }

    public int getColumnCount() {
        return this.colsPanel.getComponentCount();
    }

    public String getColumnPanelSelection(int theIndex) {
        ColumnPanel pnl = (ColumnPanel)this.getColumnPanel(theIndex);
        JComboBox cbx = pnl.getColumnsComboBox();
        return (String)cbx.getSelectedItem();
    }

    protected TableWidget getTable() {
        return this.table;
    }

    protected void handleAndAction(ColumnPanel thePanel) {
        Component[] comps = this.colsPanel.getComponents();
        int ndx = comps.length;
        while (--ndx >= 0) {
            if (comps[ndx] != thePanel || ndx != comps.length - 1 && ((JComboBox)((JComponent)comps[ndx + 1]).getComponent(1)).getSelectedItem().equals(NONE)) continue;
            this.addColumnPanel(ndx + 1);
            ColumnPanel cpnlLastPanel = this.getLastPanel();
            this.removeEntryFromComboBox(cpnlLastPanel.getColumnsComboBox(), NONE);
            this.addEntryToComboBox(cpnlLastPanel.getColumnsComboBox(), NONE);
            cpnlLastPanel.getColumnsComboBox().setSelectedItem(NONE);
            LogManager.logDetail((String)"HIDEPANEL", (Object[])new Object[]{"[AbstractTableOptionPanel.handleAndAction] About to call applyPoliciesToLastPanel"});
            this.applyPoliciesToLastPanel(null);
            this.revalidate();
            break;
        }
    }

    protected void handleColumnSelected(ColumnPanel thePanel) {
        this.applyPoliciesToLastPanel(null);
        ButtonWidget andButton = thePanel.getAndButton();
        if (thePanel.getColumnsComboBox().getSelectedItem() != null && !thePanel.getColumnsComboBox().getSelectedItem().equals(NONE)) {
            LogManager.logDetail((String)"HIDEPANEL", (Object[])new Object[]{"[AbstractTableOptionPanel.handleColumnSelected] Selected Item is NOT <NONE>"});
            if (!andButton.isVisible()) {
                andButton.setVisible(true);
                thePanel.repaint();
            }
        } else {
            LogManager.logDetail((String)"HIDEPANEL", (Object[])new Object[]{"[AbstractTableOptionPanel.handleColumnSelected] Selected Item IS <NONE>"});
            if (andButton.isVisible()) {
                andButton.setVisible(false);
                thePanel.repaint();
            }
        }
        this.applyPoliciesToLastPanel(null);
    }

    protected void handleDeleteAction(ColumnPanel thePanel) {
        if (this.colsPanel.getComponentCount() == 1) {
            this.removeEntryFromComboBox(thePanel.getColumnsComboBox(), NONE);
            this.addEntryToComboBox(thePanel.getColumnsComboBox(), NONE);
            thePanel.getColumnsComboBox().setSelectedItem(NONE);
        } else {
            String sSelectedColNameFromDeletedPanel = null;
            if (thePanel != this.getLastPanel()) {
                sSelectedColNameFromDeletedPanel = (String)thePanel.getColumnsComboBox().getSelectedItem();
            }
            this.colsPanel.remove(thePanel);
            this.colsPanel.revalidate();
            this.colsPanel.repaint();
            LogManager.logDetail((String)"HIDEPANEL", (Object[])new Object[]{"[AbstractTableOptionPanel.handleDeleteAction] About to call applyPoliciesToLastPanel"});
            this.applyPoliciesToLastPanel(sSelectedColNameFromDeletedPanel);
        }
    }

    protected ColumnPanel getLastPanel() {
        Component[] comps = this.colsPanel.getComponents();
        return (ColumnPanel)comps[comps.length - 1];
    }

    protected void applyPoliciesToLastPanel(String sDeletedColumnName) {
        Component[] comps = this.colsPanel.getComponents();
        ColumnPanel colPanel = (ColumnPanel)comps[comps.length - 1];
        if (colPanel != null) {
            if (sDeletedColumnName != null) {
                LogManager.logDetail((String)"HIDEPANEL", (Object[])new Object[]{"[AbstractTableOptionPanel.applyPoliciesToLastPanel] About to add the deleted col name to the new last panel"});
                this.addEntryToComboBox(colPanel.getColumnsComboBox(), sDeletedColumnName);
            }
            colPanel.getAndButton().setVisible(true);
            colPanel.getAndButton().setEnabled(true);
            colPanel.getColumnsComboBox().setEnabled(true);
            if (colPanel.getColumnsComboBox().getSelectedItem() != null && colPanel.getColumnsComboBox().getSelectedItem().equals(NONE)) {
                LogManager.logDetail((String)"HIDEPANEL", (Object[])new Object[]{"[AbstractTableOptionPanel.applyPoliciesToLastPanel] NONE is selected, about to hide the And button"});
                colPanel.getAndButton().setVisible(false);
                colPanel.getAndButton().setEnabled(false);
            } else {
                int iSize = colPanel.getColumnsComboBox().getModel().getSize();
                boolean bContainsNone = this.containsNone(colPanel.getColumnsComboBox());
                if (iSize < 4 && bContainsNone || iSize < 3 && !bContainsNone) {
                    LogManager.logDetail((String)"HIDEPANEL", (Object[])new Object[]{"[AbstractTableOptionPanel.applyPoliciesToLastPanel] Fewer than 3 (4) cbx choices left, About to HIDE the And button"});
                    colPanel.getAndButton().setVisible(false);
                }
            }
            this.colsPanel.revalidate();
            this.colsPanel.repaint();
        }
    }

    private boolean containsNone(JComboBox cbx) {
        boolean bFound = false;
        for (int ix = 0; ix < cbx.getModel().getSize(); ++ix) {
            String sElement = (String)cbx.getModel().getElementAt(ix);
            if (!sElement.equals(NONE)) continue;
            bFound = true;
            break;
        }
        return bFound;
    }

    private void addEntryToComboBox(JComboBox cbx, String sNewEntry) {
        boolean bSaveCbxEnabledState = cbx.isEnabled();
        Object oCurrentSelection = cbx.getModel().getSelectedItem();
        ComboBoxModel cbxmdlOld = cbx.getModel();
        ArrayList arylCurrentContents = new ArrayList(cbxmdlOld.getSize());
        for (int ix = 0; ix < cbxmdlOld.getSize(); ++ix) {
            arylCurrentContents.add(cbxmdlOld.getElementAt(ix));
        }
        arylCurrentContents.add(sNewEntry);
        DefaultComboBoxModel<Object> cbxmdlNew = new DefaultComboBoxModel<Object>(arylCurrentContents.toArray());
        cbx.setModel(cbxmdlNew);
        cbxmdlNew.setSelectedItem(oCurrentSelection);
        cbx.setEnabled(bSaveCbxEnabledState);
    }

    private void removeEntryFromComboBox(JComboBox cbx, String sEntry) {
        LogManager.logDetail((String)"HIDEPANEL", (Object[])new Object[]{"[AbstractTableOptionPanel.applyPoliciesToLastPanel] About REMOVE this entry: " + sEntry});
        boolean bSaveCbxEnabledState = cbx.isEnabled();
        Object oCurrentSelection = cbx.getModel().getSelectedItem();
        ComboBoxModel cbxmdlOld = cbx.getModel();
        ArrayList arylCurrentContents = new ArrayList(cbxmdlOld.getSize());
        for (int ix = 0; ix < cbxmdlOld.getSize(); ++ix) {
            String sTemp = (String)cbxmdlOld.getElementAt(ix);
            if (sTemp.equals(sEntry)) continue;
            arylCurrentContents.add(cbxmdlOld.getElementAt(ix));
        }
        DefaultComboBoxModel<Object> cbxmdlNew = new DefaultComboBoxModel<Object>(arylCurrentContents.toArray());
        cbx.setModel(cbxmdlNew);
        cbxmdlNew.setSelectedItem(oCurrentSelection);
        cbx.setEnabled(bSaveCbxEnabledState);
    }

    protected void initializeColumnsPanel(JComponent columnPanel) {
        if (columnPanel == null) {
            columnPanel = this.addColumnPanel(0);
        }
        Dimension size = columnPanel.getPreferredSize();
        this.getVerticalScrollBar().setUnitIncrement(size.height);
        size.height *= 3;
        this.getViewport().setPreferredSize(size);
    }

    protected void initializeAbstractTableOptionPanel() {
        this.setViewportView(this.colsPanel);
        this.colsPanel.setLayout(new BoxLayout(this.colsPanel, 1));
        EnhancedTableColumnModel colModel = this.table.getEnhancedColumnModel();
        this.colNames = new String[colModel.getHiddenAndShownColumnCount() + 1];
        this.colNames[0] = NONE;
        Iterator iterator = colModel.getHiddenAndShownColumns().iterator();
        int ndx = 1;
        while (iterator.hasNext()) {
            this.colNames[ndx] = (String)((EnhancedTableColumn)iterator.next()).getIdentifier();
            ++ndx;
        }
    }

    public class ColumnPanel
    extends JPanel {
        private ButtonWidget btnAnd;
        private ButtonWidget btnDelete;
        private JComboBox cbxColumns;

        public ColumnPanel() {
            this.setLayout(new BoxLayout(this, 0));
            this.setAlignmentX(0.0f);
            this.add(new LabelWidget("Column "));
            this.cbxColumns = new JComboBox<String>(AbstractTableOptionPanel.this.colNames);
            this.cbxColumns.setMaximumSize(this.cbxColumns.getPreferredSize());
            this.add(this.cbxColumns);
            this.btnAnd = new ButtonWidget(", and");
            this.btnAnd.setVisible(false);
            this.add(this.btnAnd);
            SpacerWidget spacer = SpacerWidget.createHorizontalSpacer();
            spacer.setMaximumSize(new Dimension(Short.MAX_VALUE, 0));
            this.add(spacer);
            this.btnDelete = new ButtonWidget(UIDefaults.getInstance().getIcon("Icon.delete"));
            this.add(this.btnDelete);
        }

        public ButtonWidget getAndButton() {
            return this.btnAnd;
        }

        public ButtonWidget getDeleteButton() {
            return this.btnDelete;
        }

        public JComboBox getColumnsComboBox() {
            return this.cbxColumns;
        }
    }
}

