/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.table;

import com.metamatrix.toolbox.ui.UIDefaults;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class DefaultTableCellEditor
implements SwingConstants,
TableCellEditor {
    public static final String CLICK_COUNT_TO_START_PROPERTY = "Table.clickCountToStart";
    private TextFieldWidget fld = null;
    private CheckBox checkBox = null;
    private Delegate fldDelegate;
    private Delegate checkBoxDelegate;
    private Delegate delegate;
    private List listeners = null;
    private int clickCountToStart = UIDefaults.getInstance().getInt("Table.clickCountToStart");

    @Override
    public void addCellEditorListener(CellEditorListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    @Override
    public void cancelCellEditing() {
        if (this.listeners == null) {
            return;
        }
        ChangeEvent event = null;
        int ndx = this.listeners.size();
        while (--ndx >= 0) {
            if (event == null) {
                event = new ChangeEvent(this);
            }
            ((CellEditorListener)this.listeners.get(ndx)).editingCanceled(event);
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    protected CheckBox getCheckBox() {
        return this.checkBox;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int columnIndex) {
        JComponent comp;
        Component rendererComp = table.getCellRenderer(rowIndex, columnIndex).getTableCellRendererComponent(table, value, false, false, rowIndex, columnIndex);
        if (value instanceof Boolean) {
            if (this.checkBox == null) {
                this.checkBox = new CheckBox();
                CheckBox rendererCheckBox = (CheckBox)rendererComp;
                this.checkBox.setHorizontalAlignment(rendererCheckBox.getHorizontalAlignment());
                this.checkBox.setBorder(rendererCheckBox.getBorder());
                this.checkBoxDelegate = new Delegate(){

                    @Override
                    public Object getCellEditorValue() {
                        return new Boolean(DefaultTableCellEditor.this.checkBox.isSelected());
                    }

                    @Override
                    public void setCellEditorValue(Object value) {
                        if (value == null) {
                            DefaultTableCellEditor.this.checkBox.setSelected(false);
                        } else {
                            DefaultTableCellEditor.this.checkBox.setSelected((Boolean)value);
                        }
                    }
                };
            }
            comp = this.checkBox;
            this.delegate = this.checkBoxDelegate;
        } else {
            if (this.fld == null) {
                this.fld = new TextFieldWidget();
                this.fld.setAutoscrolls(false);
                this.fld.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        DefaultTableCellEditor.this.stopCellEditing();
                    }
                });
                this.fld.setBorder(((LabelWidget)rendererComp).getBorder());
                this.fldDelegate = new Delegate(){
                    private DateFormat dateFmtr = null;

                    @Override
                    public Object getCellEditorValue() {
                        String text = DefaultTableCellEditor.this.fld.getText();
                        Object val = this.getOriginalCellEditorValue();
                        if (val instanceof Number) {
                            try {
                                return DecimalFormat.getInstance().parse(text);
                            }
                            catch (ParseException ignored) {
                            }
                        } else if (val instanceof Date) {
                            try {
                                return this.dateFmtr.parse(text);
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                        }
                        return text;
                    }

                    @Override
                    public void setCellEditorValue(Object value) {
                        super.setCellEditorValue(value);
                        if (value == null) {
                            DefaultTableCellEditor.this.fld.setText("");
                        } else if (value instanceof Date) {
                            if (this.dateFmtr == null) {
                                this.dateFmtr = DateFormat.getInstance();
                                ((SimpleDateFormat)this.dateFmtr).applyPattern("MM/dd/yyyy hh:mm:ss a");
                            }
                            DefaultTableCellEditor.this.fld.setText(this.dateFmtr.format(value));
                        } else {
                            DefaultTableCellEditor.this.fld.setText(value.toString());
                        }
                    }
                };
            }
            if (value instanceof Number) {
                this.fld.setHorizontalAlignment(4);
            } else {
                this.fld.setHorizontalAlignment(2);
            }
            comp = this.fld;
            this.delegate = this.fldDelegate;
        }
        this.initializeComponent(comp, table, value, isSelected, rowIndex, columnIndex);
        return comp;
    }

    protected TextFieldWidget getTextField() {
        return this.fld;
    }

    protected void initializeComponent(Component component, final JTable table, Object value, boolean isSelected, int rowIndex, int columnIndex) {
        Component rendererComp = table.getCellRenderer(rowIndex, columnIndex).getTableCellRendererComponent(table, value, false, false, rowIndex, columnIndex);
        this.delegate.setCellEditorValue(value);
        component.setFont(rendererComp.getFont());
        component.setBackground(rendererComp.getBackground());
        component.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent event) {
                if (table.isEditing()) {
                    DefaultTableCellEditor.this.stopCellEditing();
                }
            }
        });
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        if (event instanceof MouseEvent) {
            return ((MouseEvent)event).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.size() == 0) {
            this.listeners = null;
        }
    }

    public void setCellEditorValue(Object value) {
        this.delegate.setCellEditorValue(value);
    }

    public void setClickCountToStart(int clickCountToStart) {
        this.clickCountToStart = clickCountToStart;
    }

    protected void setDelegate(Delegate delegate, Object value) {
        this.delegate = delegate;
        delegate.setCellEditorValue(value);
    }

    @Override
    public boolean shouldSelectCell(EventObject event) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.listeners == null) {
            return true;
        }
        ChangeEvent event = null;
        int ndx = this.listeners.size();
        while (--ndx >= 0) {
            if (event == null) {
                event = new ChangeEvent(this);
            }
            ((CellEditorListener)this.listeners.get(ndx)).editingStopped(event);
        }
        return true;
    }

    protected abstract class Delegate {
        private Object origVal;

        protected Delegate() {
        }

        public abstract Object getCellEditorValue();

        public Object getOriginalCellEditorValue() {
            return this.origVal;
        }

        public void setCellEditorValue(Object value) {
            this.origVal = value;
        }
    }
}

