/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.table;

import com.metamatrix.toolbox.ui.UIDefaults;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import java.awt.Component;
import java.awt.Rectangle;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class DefaultTableCellRenderer
implements SwingConstants,
TableCellRenderer {
    private LabelWidget label = null;
    private CheckBox checkBox = null;
    private final Border focusBorder = UIDefaults.getInstance().getBorder("Table.focusCellHighlightBorder");
    public final Border noFocusBorder = UIDefaults.getInstance().getBorder("Table.noFocusBorder");
    public final Border checkBoxBorder = UIDefaults.getInstance().getBorder("Table.checkBoxBorder");
    private DateFormat dateFmtr = null;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
        JComponent comp;
        if (value instanceof Boolean) {
            if (this.checkBox == null) {
                this.checkBox = new DefaultBooleanComponent();
                this.checkBox.setBoxDisabledBackgroundColor(table.getBackground());
            }
            this.checkBox.setSelected((Boolean)value);
            this.checkBox.setEnabled(table.isCellEditable(rowIndex, columnIndex));
            this.checkBox.setBorder(hasFocus ? this.focusBorder : this.checkBoxBorder);
            comp = this.checkBox;
        } else {
            if (this.label == null) {
                this.label = new DefaultTextComponent();
                this.label.setForeground(table.getForeground());
            }
            this.label.setIcon(null);
            if (value == null) {
                this.label.setText("");
            } else if (value instanceof Number) {
                this.label.setText(value.toString());
                this.label.setHorizontalAlignment(4);
            } else if (value instanceof Icon) {
                this.label.setIcon((Icon)value);
                this.label.setHorizontalAlignment(0);
                this.label.setText("");
            } else if (value instanceof Date) {
                if (this.dateFmtr == null) {
                    this.dateFmtr = DateFormat.getInstance();
                    ((SimpleDateFormat)this.dateFmtr).applyPattern("MM/dd/yyyy hh:mm:ss a");
                }
                this.label.setText(this.dateFmtr.format(value));
                this.label.setHorizontalAlignment(2);
            } else {
                this.label.setText(value.toString());
                this.label.setHorizontalAlignment(2);
            }
            Rectangle bounds = table.getCellRect(rowIndex, columnIndex, false);
            if (bounds.width < this.label.getPreferredSize().width) {
                this.label.setToolTipText(this.label.getText());
            } else {
                this.label.setToolTipText(null);
            }
            this.label.setBorder(hasFocus ? this.focusBorder : this.noFocusBorder);
            comp = this.label;
        }
        this.initializeComponent(comp, table, isSelected, hasFocus, rowIndex, columnIndex);
        return comp;
    }

    protected void initializeComponent(Component component, JTable table, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
        component.setFont(table.getFont());
        if (hasFocus && table.isCellEditable(rowIndex, columnIndex)) {
            component.setBackground(UIDefaults.getInstance().getColor("Table.focusCellBackground"));
        } else if (isSelected) {
            component.setBackground(table.getSelectionBackground());
        } else {
            component.setBackground(table.getBackground());
        }
    }

    public void setBooleanComponent(CheckBox theCheckBox) {
        this.checkBox = theCheckBox;
    }

    public void setTextComponent(LabelWidget theLabel) {
        this.label = theLabel;
    }

    public class DefaultTextComponent
    extends LabelWidget {
        public DefaultTextComponent() {
            this.setOpaque(true);
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if ("text".equals(propertyName)) {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        @Override
        public void repaint(Rectangle bounds) {
        }

        @Override
        public void repaint(long time, int x, int y, int width, int height) {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void validate() {
        }
    }

    public class DefaultBooleanComponent
    extends CheckBox {
        public DefaultBooleanComponent() {
            this.setHorizontalAlignment(0);
            this.setBorder(DefaultTableCellRenderer.this.checkBoxBorder);
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if ("text".equals(propertyName)) {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        @Override
        public void repaint(Rectangle bounds) {
        }

        @Override
        public void repaint(long time, int x, int y, int width, int height) {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void validate() {
        }
    }
}

