/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.table;

import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumnModel;
import com.metamatrix.toolbox.ui.widget.table.TableColumnSortListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.TableColumn;

public class DefaultTableColumnModel
extends javax.swing.table.DefaultTableColumnModel
implements EnhancedTableColumnModel {
    private List cols = new ArrayList();
    private List hiddenCols = null;
    private List sortedCols = null;

    @Override
    public void addColumn(TableColumn column) {
        this.addColumn(column, this.getColumnCount());
    }

    public void addColumn(TableColumn column, int index) {
        if (!(column instanceof EnhancedTableColumn)) {
            throw new IllegalArgumentException("Column parameter must be an instance of EnhancedTableColumn");
        }
        this.tableColumns.add(index, column);
        this.cols.add(index, column);
        column.addPropertyChangeListener(this);
        this.recalcWidthCache();
        this.fireColumnAdded(new TableColumnModelEvent(this, 0, index));
    }

    @Override
    public void addColumnSortListener(TableColumnSortListener listener) {
        this.listenerList.add(TableColumnSortListener.class, listener);
    }

    protected void fireColumnSorted() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int ndx = listeners.length - 2; ndx >= 0; ndx -= 2) {
            if (listeners[ndx] != TableColumnSortListener.class) continue;
            ((TableColumnSortListener)listeners[ndx + 1]).columnSorted();
        }
    }

    @Override
    public int getColumnIndex(TableColumn column) {
        return this.tableColumns.indexOf(column);
    }

    @Override
    public int getHiddenAndShownColumnCount() {
        return this.cols.size();
    }

    @Override
    public List getHiddenAndShownColumns() {
        return Collections.unmodifiableList(this.cols);
    }

    @Override
    public int getHiddenColumnCount() {
        if (this.hiddenCols == null) {
            return 0;
        }
        return this.hiddenCols.size();
    }

    @Override
    public List getHiddenColumns() {
        if (this.hiddenCols == null) {
            return null;
        }
        return Collections.unmodifiableList(new ArrayList(this.hiddenCols));
    }

    public TableColumn getHiddenOrShownColumn(int index) {
        return (TableColumn)this.cols.get(index);
    }

    @Override
    public int getHiddenOrShownColumnIndex(Object columnID) {
        Iterator iterator = this.cols.iterator();
        int ndx = 0;
        while (iterator.hasNext()) {
            if (((TableColumn)iterator.next()).getIdentifier().equals(columnID)) {
                return ndx;
            }
            ++ndx;
        }
        return -1;
    }

    @Override
    public int getSortedColumnCount() {
        if (this.sortedCols == null) {
            return 0;
        }
        return this.sortedCols.size();
    }

    @Override
    public List getSortedColumns() {
        if (this.sortedCols == null) {
            return null;
        }
        return Collections.unmodifiableList(new ArrayList(this.sortedCols));
    }

    @Override
    public boolean isColumnHidden(TableColumn column) {
        if (this.hiddenCols == null) {
            return false;
        }
        return this.hiddenCols.contains(column);
    }

    @Override
    public void moveColumn(int fromIndex, int toIndex) {
        this.cols.add(this.getHiddenOrShownColumnIndex(this.getColumn(toIndex).getIdentifier()), this.cols.remove(this.getHiddenOrShownColumnIndex(this.getColumn(fromIndex).getIdentifier())));
        super.moveColumn(fromIndex, toIndex);
    }

    @Override
    public void moveHiddenOrShownColumn(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        if (!this.isColumnHidden((TableColumn)this.cols.get(fromIndex))) {
            int toNdx;
            for (toNdx = toIndex; toNdx < this.cols.size() && this.isColumnHidden((TableColumn)this.cols.get(toNdx)); ++toNdx) {
            }
            if (toNdx == this.cols.size()) {
                super.moveColumn(this.getColumnIndex(this.getHiddenOrShownColumn(fromIndex).getIdentifier()), this.getColumnCount());
            } else {
                super.moveColumn(this.getColumnIndex(this.getHiddenOrShownColumn(fromIndex).getIdentifier()), this.getColumnIndex(this.getHiddenOrShownColumn(toNdx).getIdentifier()));
            }
        }
        this.cols.add(toIndex, this.cols.remove(fromIndex));
    }

    @Override
    public void removeColumn(TableColumn column) {
        super.removeColumn(column);
        this.cols.remove(column);
        if (this.hiddenCols != null) {
            this.hiddenCols.remove(column);
            if (this.hiddenCols.size() == 0) {
                this.hiddenCols = null;
            }
        }
        if (this.sortedCols != null) {
            this.sortedCols.remove(column);
            if (this.sortedCols.size() == 0) {
                this.sortedCols = null;
            }
        }
    }

    @Override
    public void removeColumnSortListener(TableColumnSortListener listener) {
        this.listenerList.remove(TableColumnSortListener.class, listener);
    }

    @Override
    public void setColumnHidden(TableColumn column, boolean isHidden) {
        if (isHidden) {
            if (this.hiddenCols == null) {
                this.hiddenCols = new ArrayList();
            }
            if (this.hiddenCols.contains(column)) {
                return;
            }
            this.hiddenCols.add(column);
            super.removeColumn(column);
        } else {
            if (this.hiddenCols == null) {
                return;
            }
            if (!this.hiddenCols.remove(column)) {
                return;
            }
            Object col = null;
            ListIterator iterator = this.cols.listIterator(this.cols.indexOf(column) + 1);
            while (iterator.hasNext()) {
                if (this.hiddenCols.contains(iterator.next())) continue;
                col = iterator.previous();
                break;
            }
            if (col == null) {
                super.addColumn(column);
            } else {
                int ndx = this.tableColumns.indexOf(col);
                this.tableColumns.add(ndx, column);
                column.addPropertyChangeListener(this);
                this.recalcWidthCache();
                this.fireColumnAdded(new TableColumnModelEvent(this, 0, ndx));
            }
            if (this.hiddenCols.size() == 0) {
                this.hiddenCols = null;
            }
        }
    }

    @Override
    public void setColumnNotSorted(EnhancedTableColumn column, boolean isCurrentColumnSortOrderKept) {
        this.setColumnSortStatus(column, false, column.isSortedAscending(), isCurrentColumnSortOrderKept);
    }

    @Override
    public void setColumnSortedAscending(EnhancedTableColumn column, boolean isCurrentColumnSortOrderKept) {
        this.setColumnSortStatus(column, true, true, isCurrentColumnSortOrderKept);
    }

    @Override
    public void setColumnSortedDescending(EnhancedTableColumn column, boolean isCurrentColumnSortOrderKept) {
        this.setColumnSortStatus(column, true, false, isCurrentColumnSortOrderKept);
    }

    protected void setColumnSortStatus(EnhancedTableColumn column, boolean isSorted, boolean isSortedAscending, boolean isCurrentColumnSortOrderKept) {
        this.setColumnSortStatus(column, isSorted, isSortedAscending, isCurrentColumnSortOrderKept, true);
    }

    protected void setColumnSortStatus(EnhancedTableColumn column, boolean isSorted, boolean isSortedAscending, boolean isCurrentColumnSortOrderKept, boolean fireSortEvent) {
        int oldSortPriority = column.getSortPriority();
        boolean oldIsSorted = column.isSorted();
        boolean oldIsSortedAscending = column.isSortedAscending();
        if (!isCurrentColumnSortOrderKept) {
            this.setColumnsNotSorted();
        }
        if (isSorted) {
            if (isSortedAscending) {
                column.setSortedAscending();
            } else {
                column.setSortedDescending();
            }
            if (!oldIsSorted || !isCurrentColumnSortOrderKept) {
                if (this.sortedCols == null) {
                    this.sortedCols = new ArrayList();
                }
                this.sortedCols.add(column);
                column.setSortPriority(this.sortedCols.size());
                if (fireSortEvent) {
                    this.fireColumnSorted();
                }
            } else if (oldIsSortedAscending != isSortedAscending && fireSortEvent) {
                this.fireColumnSorted();
            }
        } else {
            column.setNotSorted();
            if (oldIsSorted && isCurrentColumnSortOrderKept) {
                this.sortedCols.remove(column);
                if (this.sortedCols.size() == 0) {
                    this.sortedCols = null;
                } else {
                    for (EnhancedTableColumn col : this.sortedCols) {
                        int priority = col.getSortPriority();
                        if (priority <= oldSortPriority) continue;
                        col.setSortPriority(priority - 1);
                    }
                }
            }
            if (oldIsSorted && fireSortEvent) {
                this.fireColumnSorted();
            }
        }
    }

    @Override
    public void setColumnsHidden(boolean isHidden) {
        if (isHidden) {
            while (this.getColumnCount() > 0) {
                this.setColumnHidden(this.getColumn(0), true);
            }
        } else {
            while (this.hiddenCols != null) {
                this.setColumnHidden((TableColumn)this.hiddenCols.get(0), false);
            }
        }
    }

    @Override
    public void setColumnsNotSorted() {
        if (this.sortedCols == null) {
            return;
        }
        Iterator iterator = this.sortedCols.iterator();
        while (iterator.hasNext()) {
            ((EnhancedTableColumn)iterator.next()).setNotSorted();
        }
        this.sortedCols = null;
    }

    public TableColumn getColumnFromModelIndex(int modelIndex) {
        return (TableColumn)this.cols.get(modelIndex);
    }
}

