/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.table;

import com.metamatrix.toolbox.ui.widget.table.TableComparator;

public class DefaultTableComparator
implements TableComparator {
    private static final DefaultTableComparator INSTANCE = new DefaultTableComparator();
    private boolean ignoresCase;

    public static DefaultTableComparator getInstance() {
        return INSTANCE;
    }

    protected int compare(Comparable firstValue, Comparable secondValue) {
        if (firstValue instanceof String && this.ignoresCase) {
            return ((String)((Object)firstValue)).compareToIgnoreCase((String)((Object)secondValue));
        }
        return firstValue.compareTo(secondValue);
    }

    @Override
    public int compare(Object firstValue, Object secondValue, int columnIndex) {
        if (firstValue == null && secondValue == null) {
            return 0;
        }
        if (firstValue == null) {
            return -1;
        }
        if (secondValue == null) {
            return 1;
        }
        if (firstValue instanceof Number && secondValue instanceof Number) {
            double diff = ((Number)firstValue).doubleValue() - ((Number)secondValue).doubleValue();
            if (diff > 0.0) {
                return 1;
            }
            if (diff < 0.0) {
                return -1;
            }
            return 0;
        }
        if (firstValue instanceof Comparable && firstValue.getClass().isInstance(secondValue)) {
            return this.compare((Comparable)firstValue, (Comparable)secondValue);
        }
        return this.compare((Comparable)((Object)firstValue.toString()), (Comparable)((Object)secondValue.toString()));
    }

    public boolean ignoresCase() {
        return this.ignoresCase;
    }

    public void setIgnoresCase(boolean ignoresCase) {
        this.ignoresCase = ignoresCase;
    }
}

