/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.table;

import com.metamatrix.toolbox.ui.widget.ConfigurationPanel;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.PopupMenu;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.table.AbstractTableFilterOptionPanel;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumnModel;
import com.metamatrix.toolbox.ui.widget.table.TableConstants;
import com.metamatrix.toolbox.ui.widget.table.TableHeader;
import com.metamatrix.toolbox.ui.widget.table.TableOptionPanel;
import com.metamatrix.toolbox.ui.widget.table.TableReorderOptionPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class DefaultTableHeader
extends JTableHeader
implements TableConstants,
TableHeader {
    private int armedColNdx = -1;
    private int pressedColNdx = -1;
    private AbstractTableFilterOptionPanel filterPanel;
    private TableOptionPanel optionPanel;
    private boolean allOptionsEnabled;
    private boolean popupMenuEnabled;

    public DefaultTableHeader(TableColumnModel model) {
        super(model);
        this.initializeDefaultTableHeader();
    }

    protected TableOptionPanel createOptionPanel() {
        return new TableOptionPanel(this);
    }

    @Override
    public int getArmedColumnIndex() {
        return this.armedColNdx;
    }

    public AbstractTableFilterOptionPanel getFilterOptionPanel() {
        return this.filterPanel;
    }

    public TableOptionPanel getOptionPanel() {
        return this.optionPanel;
    }

    @Override
    public int getPressedColumnIndex() {
        return this.pressedColNdx;
    }

    protected void initializeDefaultTableHeader() {
        this.allOptionsEnabled = true;
        this.popupMenuEnabled = true;
        MouseInputAdapter listener = new MouseInputAdapter(){
            EnhancedTableColumn resizingCol = null;

            @Override
            public void mouseClicked(MouseEvent event) {
                final TableWidget table = (TableWidget)DefaultTableHeader.this.getTable();
                if (this.resizingCol != null) {
                    if (SwingUtilities.isLeftMouseButton(event) && event.getClickCount() == 2 && table.getRowCount() > 0) {
                        table.sizeColumnToFitData(this.resizingCol);
                    }
                    return;
                }
                int colNdx = table.columnAtPoint(event.getPoint());
                if (colNdx < 0) {
                    return;
                }
                final EnhancedTableColumnModel colModel = table.getEnhancedColumnModel();
                final EnhancedTableColumn col = (EnhancedTableColumn)colModel.getColumn(colNdx);
                if (SwingUtilities.isRightMouseButton(event) && DefaultTableHeader.this.popupMenuEnabled) {
                    JMenuItem item;
                    PopupMenu menu = new PopupMenu();
                    if (table.isSortable()) {
                        final int count = colModel.getSortedColumnCount();
                        item = new JMenuItem("Sort Ascending");
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent event) {
                                if (DefaultTableHeader.this.shouldCurrentColumnSortOrderBeCleared(count, col)) {
                                    colModel.setColumnSortedAscending(col, false);
                                } else if (!col.isSortedAscending()) {
                                    colModel.setColumnSortedAscending(col, true);
                                } else {
                                    return;
                                }
                                DefaultTableHeader.this.repaint();
                                table.repaint();
                            }
                        });
                        menu.add(item);
                        item = new JMenuItem("Sort Descending");
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent event) {
                                if (DefaultTableHeader.this.shouldCurrentColumnSortOrderBeCleared(count, col)) {
                                    colModel.setColumnSortedDescending(col, false);
                                } else if (!col.isSortedDescending()) {
                                    colModel.setColumnSortedDescending(col, true);
                                } else {
                                    return;
                                }
                                DefaultTableHeader.this.repaint();
                                table.repaint();
                            }
                        });
                        menu.add(item);
                        item = new JMenuItem("Do Not Sort");
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent event) {
                                if (DefaultTableHeader.this.shouldCurrentColumnSortOrderBeCleared(count, col)) {
                                    colModel.setColumnNotSorted(col, false);
                                } else if (col.isSorted()) {
                                    colModel.setColumnNotSorted(col, true);
                                } else {
                                    return;
                                }
                                DefaultTableHeader.this.repaint();
                                table.repaint();
                            }
                        });
                        menu.add(item);
                        menu.addSeparator();
                    }
                    if (colModel.getColumnCount() > 1) {
                        item = new JMenuItem("Hide");
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent event) {
                                colModel.setColumnHidden(col, true);
                                table.sizeColumnsToFitContainer(-1);
                                DefaultTableHeader.this.repaint();
                                table.repaint();
                            }
                        });
                        menu.add(item);
                        menu.addSeparator();
                    }
                    if (DefaultTableHeader.this.getReorderingAllowed()) {
                        item = new JMenuItem("Reorder");
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent event) {
                                final TableReorderOptionPanel reorderPanel = new TableReorderOptionPanel(table);
                                reorderPanel.setSelectedColumn(col);
                                ConfigurationPanel configPanel = new ConfigurationPanel(reorderPanel);
                                configPanel.addApplyActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent event) {
                                        DefaultTableHeader.this.reorderColumns(reorderPanel);
                                    }
                                });
                                DialogWindow.show(table, "Reorder Columns", configPanel);
                                DefaultTableHeader.this.repaint();
                                table.repaint();
                            }
                        });
                        menu.add(item);
                        menu.addSeparator();
                    }
                    if (DefaultTableHeader.this.getResizingAllowed()) {
                        item = new JMenuItem("Fit To Contents");
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent event) {
                                table.sizeColumnToFitData(col);
                                DefaultTableHeader.this.repaint();
                                table.repaint();
                            }
                        });
                        menu.add(item);
                        menu.addSeparator();
                    }
                    if (DefaultTableHeader.this.allOptionsEnabled) {
                        item = new JMenuItem("All Options...");
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent event) {
                                DefaultTableHeader.this.optionPanel = DefaultTableHeader.this.createOptionPanel();
                                DialogWindow.show(table.getParent(), "Table Options", DefaultTableHeader.this.optionPanel);
                                SwingUtilities.windowForComponent(DefaultTableHeader.this).repaint();
                            }
                        });
                        menu.add(item);
                    }
                    menu.show(DefaultTableHeader.this, event.getX(), event.getY());
                    return;
                }
                if (!table.isSortable()) {
                    return;
                }
                int count = colModel.getSortedColumnCount();
                if (event.isAltDown()) {
                    if (!event.isShiftDown() && !event.isControlDown() && DefaultTableHeader.this.shouldCurrentColumnSortOrderBeCleared(count, col)) {
                        colModel.setColumnSortedDescending(col, false);
                    } else if (!col.isSorted() || col.isSortedAscending() && !event.isControlDown()) {
                        colModel.setColumnSortedDescending(col, table.allowsMultipleColumnSorting());
                    } else if (col.isSortedDescending()) {
                        colModel.setColumnSortedAscending(col, table.allowsMultipleColumnSorting());
                    } else {
                        colModel.setColumnNotSorted(col, table.allowsMultipleColumnSorting());
                    }
                } else if (!event.isShiftDown() && !event.isControlDown() && DefaultTableHeader.this.shouldCurrentColumnSortOrderBeCleared(count, col)) {
                    colModel.setColumnSortedAscending(col, false);
                } else if (!col.isSorted() || col.isSortedDescending() && !event.isControlDown()) {
                    colModel.setColumnSortedAscending(col, table.allowsMultipleColumnSorting());
                } else if (col.isSortedAscending()) {
                    colModel.setColumnSortedDescending(col, table.allowsMultipleColumnSorting());
                } else {
                    colModel.setColumnNotSorted(col, table.allowsMultipleColumnSorting());
                }
                DefaultTableHeader.this.repaint();
                table.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent event) {
                DefaultTableHeader.this.armedColNdx = DefaultTableHeader.this.getTable().columnAtPoint(event.getPoint());
            }

            @Override
            public void mouseExited(MouseEvent event) {
                DefaultTableHeader.this.armedColNdx = -1;
            }

            @Override
            public void mouseMoved(MouseEvent event) {
                DefaultTableHeader.this.armedColNdx = DefaultTableHeader.this.getTable().columnAtPoint(event.getPoint());
            }

            @Override
            public void mousePressed(MouseEvent event) {
                this.resizingCol = (EnhancedTableColumn)DefaultTableHeader.this.getResizingColumn();
                if (this.resizingCol != null || SwingUtilities.isRightMouseButton(event)) {
                    return;
                }
                DefaultTableHeader.this.pressedColNdx = DefaultTableHeader.this.getTable().columnAtPoint(event.getPoint());
                DefaultTableHeader.this.repaint();
            }

            @Override
            public void mouseDragged(MouseEvent event) {
                DefaultTableHeader.this.pressedColNdx = -1;
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                DefaultTableHeader.this.pressedColNdx = -1;
                DefaultTableHeader.this.repaint();
            }
        };
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    protected boolean shouldCurrentColumnSortOrderBeCleared(int count, EnhancedTableColumn column) {
        return count > 0 && (count > 1 || !column.isSorted());
    }

    protected void reorderColumns(TableReorderOptionPanel reorderPanel) {
        EnhancedTableColumnModel model = ((TableWidget)this.getTable()).getEnhancedColumnModel();
        Object[] cols = reorderPanel.getColumns();
        for (int ndx = 0; ndx < cols.length; ++ndx) {
            model.moveHiddenOrShownColumn(model.getHiddenOrShownColumnIndex(cols[ndx]), ndx);
        }
    }

    public void setPopupAllOptionsEnabled(boolean enabled) {
        this.allOptionsEnabled = enabled;
    }

    public void setFilterOptionPanel(AbstractTableFilterOptionPanel filterPanel) {
        this.filterPanel = filterPanel;
    }

    public void setPopupMenuEnabled(boolean enabled) {
        this.popupMenuEnabled = enabled;
    }
}

