/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.table;

import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumnModel;
import com.metamatrix.toolbox.ui.widget.table.TableHeader;
import com.metamatrix.toolbox.ui.widget.table.TableHeaderButton;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class DefaultTableHeaderRenderer
extends TableHeaderButton
implements TableCellRenderer {
    private static final DefaultTableHeaderRenderer INSTANCE = new DefaultTableHeaderRenderer();

    public static DefaultTableHeaderRenderer getInstance() {
        return INSTANCE;
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
        this.setText(value.toString());
        if (!(table instanceof TableWidget)) {
            return this;
        }
        TableWidget widget = (TableWidget)table;
        this.setTableWidget(widget);
        EnhancedTableColumnModel colModel = (EnhancedTableColumnModel)widget.getColumnModel();
        this.setColumnModel(colModel);
        this.setColumn((EnhancedTableColumn)colModel.getColumn(columnIndex));
        if (!widget.isSortable()) {
            return this;
        }
        JTableHeader hdr = widget.getTableHeader();
        if (!(hdr instanceof TableHeader)) {
            return this;
        }
        TableHeader widgetHdr = (TableHeader)((Object)hdr);
        ButtonModel buttonModel = this.getModel();
        if (widgetHdr.getArmedColumnIndex() == columnIndex) {
            buttonModel.setArmed(true);
        } else {
            buttonModel.setArmed(false);
        }
        if (widgetHdr.getPressedColumnIndex() == columnIndex) {
            buttonModel.setPressed(true);
        } else {
            buttonModel.setPressed(false);
        }
        return this;
    }

    @Override
    public void repaint(Rectangle bounds) {
    }

    @Override
    public void repaint(long time, int x, int y, int width, int height) {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void validate() {
    }
}

