/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.table;

import com.metamatrix.toolbox.ui.widget.table.EnhancedTableModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class DefaultTableModel
extends javax.swing.table.DefaultTableModel
implements EnhancedTableModel {
    private static final int COLUMN_EDITABILITY = 0;
    private static final int CELL_EXCEPTIONS = 1;
    private List colEditStatusList;

    public DefaultTableModel() {
        this.initializeDefaultTableModel();
    }

    public DefaultTableModel(Vector columnNames) {
        super(columnNames, 0);
        this.initializeDefaultTableModel();
    }

    public DefaultTableModel(int rowCount, int columnCount) {
        super(rowCount, columnCount);
        this.initializeDefaultTableModel();
    }

    public DefaultTableModel(Vector columnNames, int rowCount) {
        super(columnNames, rowCount);
        this.initializeDefaultTableModel();
    }

    public DefaultTableModel(Vector data, Vector columnNames) {
        super(data, columnNames);
        this.initializeDefaultTableModel();
    }

    public DefaultTableModel(Object[][] data, Object[] columnNames) {
        super(data, columnNames);
        this.initializeDefaultTableModel();
    }

    public void addColumn(Object columnName, Vector columnData) {
        super.addColumn(columnName, columnData);
        this.createColumnEditStatusList();
        this.addColumnEditStatus();
    }

    protected void addColumnEditStatus() {
        ArrayList<Serializable> colEditStatus = new ArrayList<Serializable>(2);
        colEditStatus.add(Boolean.TRUE);
        colEditStatus.add(new HashSet());
        this.colEditStatusList.add(colEditStatus);
    }

    protected void createColumnEditStatusList() {
        if (this.colEditStatusList == null) {
            this.colEditStatusList = new ArrayList();
        }
    }

    protected void initializeDefaultTableModel() {
        this.createColumnEditStatusList();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        List colEditStatus = (List)this.colEditStatusList.get(columnIndex);
        boolean isColEditable = (Boolean)colEditStatus.get(0);
        boolean isCellException = ((Set)colEditStatus.get(1)).contains(new Integer(rowIndex));
        return isColEditable && !isCellException || !isColEditable && isCellException;
    }

    @Override
    public boolean isColumnEditable(int columnIndex) {
        List colEditStatus = (List)this.colEditStatusList.get(columnIndex);
        return (Boolean)colEditStatus.get(0) != false || ((Set)colEditStatus.get(1)).size() > 0;
    }

    @Override
    public boolean isEditable() {
        int ndx = this.colEditStatusList.size();
        while (--ndx >= 0) {
            if (!this.isColumnEditable(ndx)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRowEditable(int rowIndex) {
        int ndx = this.colEditStatusList.size();
        while (--ndx >= 0) {
            if (!this.isCellEditable(rowIndex, ndx)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setCellEditable(int rowIndex, int columnIndex, boolean isCellEditable) {
        List colEditStatus = (List)this.colEditStatusList.get(columnIndex);
        boolean isColEditable = (Boolean)colEditStatus.get(0);
        Set cellEditStatusSet = (Set)colEditStatus.get(1);
        if (isColEditable == isCellEditable) {
            cellEditStatusSet.remove(new Integer(rowIndex));
        } else {
            cellEditStatusSet.add(new Integer(rowIndex));
            if (cellEditStatusSet.size() == this.getRowCount()) {
                this.setColumnEditable(columnIndex, !isColEditable);
            }
        }
    }

    @Override
    public void setColumnEditable(int columnIndex, boolean isEditable) {
        List colEditStatus = (List)this.colEditStatusList.get(columnIndex);
        colEditStatus.set(0, new Boolean(isEditable));
        ((Set)colEditStatus.get(1)).clear();
    }

    protected void setColumnEditStatusList(Vector columnNames) {
        if (columnNames != null) {
            int count = columnNames.size() - this.colEditStatusList.size();
            while (--count >= 0) {
                this.addColumnEditStatus();
            }
        }
    }

    @Override
    public void setColumnIdentifiers(Vector columnNames) {
        this.createColumnEditStatusList();
        this.colEditStatusList.clear();
        super.setColumnIdentifiers(columnNames);
        this.setColumnEditStatusList(columnNames);
    }

    public void setDataVector(Vector data, Vector columnNames) {
        this.createColumnEditStatusList();
        this.colEditStatusList.clear();
        if (this.getDataVector() != null) {
            this.setRowCount(0);
        }
        super.setDataVector(data, columnNames);
        this.setColumnEditStatusList(columnNames);
    }

    @Override
    public void setEditable(boolean isEditable) {
        int ndx = this.colEditStatusList.size();
        while (--ndx >= 0) {
            this.setColumnEditable(ndx, isEditable);
        }
    }

    @Override
    public void setRowEditable(int rowIndex, boolean isEditable) {
        int ndx = this.colEditStatusList.size();
        while (--ndx >= 0) {
            this.setCellEditable(rowIndex, ndx, isEditable);
        }
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        super.setValueAt(value, rowIndex, columnIndex);
    }
}

