/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.table;

import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.tree.directory.DirectoryEntryNameAndTypeComparator;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableComparator;
import com.metamatrix.toolbox.ui.widget.table.TableComparator;

public class DirectoryEntryTableComparator
extends DefaultTableComparator
implements TableComparator {
    private static final DirectoryEntryTableComparator INSTANCE = new DirectoryEntryTableComparator();
    private static DirectoryEntryNameAndTypeComparator directoryEntryComparator;

    public static DefaultTableComparator getInstance() {
        directoryEntryComparator = new DirectoryEntryNameAndTypeComparator();
        return INSTANCE;
    }

    @Override
    public int compare(Object firstValue, Object secondValue, int columnIndex) {
        if (firstValue == null && secondValue == null) {
            return 0;
        }
        if (firstValue == null) {
            return -1;
        }
        if (secondValue == null) {
            return 1;
        }
        if (firstValue instanceof Number && secondValue instanceof Number) {
            double diff = ((Number)firstValue).doubleValue() - ((Number)secondValue).doubleValue();
            if (diff > 0.0) {
                return 1;
            }
            if (diff < 0.0) {
                return -1;
            }
            return 0;
        }
        if (firstValue instanceof String && secondValue instanceof String) {
            return firstValue.toString().compareToIgnoreCase(secondValue.toString());
        }
        if (firstValue instanceof DirectoryEntry && secondValue instanceof DirectoryEntry) {
            DirectoryEntry de1 = (DirectoryEntry)firstValue;
            DirectoryEntry de2 = (DirectoryEntry)secondValue;
            return directoryEntryComparator.compare(de1, de2);
        }
        if (firstValue instanceof Comparable && firstValue.getClass().isInstance(secondValue)) {
            return ((Comparable)firstValue).compareTo(secondValue);
        }
        return firstValue.toString().compareTo(secondValue.toString());
    }
}

