/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.table;

import javax.swing.table.TableColumn;

public class EnhancedTableColumn
extends TableColumn {
    private boolean isHidden = false;
    private boolean isSorted = false;
    private boolean isSortedAscending = true;
    private int sortPriority = 0;

    public EnhancedTableColumn(int modelIndex) {
        super(modelIndex);
        this.initializeEnhancedTableColumn();
    }

    public int getSortPriority() {
        return this.sortPriority;
    }

    protected void initializeEnhancedTableColumn() {
        this.setMaxWidth(Short.MAX_VALUE);
        this.setPreferredWidth(this.getMinWidth());
        this.setWidth(this.getPreferredWidth());
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isSorted() {
        return this.isSorted;
    }

    public boolean isSortedAscending() {
        return this.isSorted && this.isSortedAscending;
    }

    public boolean isSortedDescending() {
        return this.isSorted && !this.isSortedAscending;
    }

    void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    void setNotSorted() {
        this.isSorted = false;
    }

    @Override
    public void setMaxWidth(int width) {
        if (width > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Max column width cannot exceed Short.MAX_VALUE");
        }
        super.setMaxWidth(width);
        if (width < this.getPreferredWidth()) {
            this.setPreferredWidth(width);
        }
    }

    @Override
    public void setMinWidth(int width) {
        super.setMinWidth(width);
        if (width > this.getPreferredWidth()) {
            this.setPreferredWidth(width);
        }
    }

    @Override
    public void setPreferredWidth(int width) {
        super.setPreferredWidth(width);
        if (width < this.getMinWidth()) {
            this.setMinWidth(width);
        }
        if (width > this.getMaxWidth()) {
            this.setMaxWidth(width);
        }
    }

    void setSortPriority(int sortPriority) {
        this.sortPriority = sortPriority;
    }

    void setSortedAscending() {
        this.isSorted = true;
        this.isSortedAscending = true;
    }

    void setSortedDescending() {
        this.isSorted = true;
        this.isSortedAscending = false;
    }
}

