/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.table;

import com.metamatrix.toolbox.ui.widget.ConfigurationPanel;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.table.AbstractTableFilterOptionPanel;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableHeader;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumnModel;
import com.metamatrix.toolbox.ui.widget.table.TableConstants;
import com.metamatrix.toolbox.ui.widget.table.TableFilter;
import com.metamatrix.toolbox.ui.widget.table.TableHideOptionPanel;
import com.metamatrix.toolbox.ui.widget.table.TableReorderOptionPanel;
import com.metamatrix.toolbox.ui.widget.table.TableSortOptionPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTabbedPane;

public class TableOptionPanel
extends ConfigurationPanel
implements TableConstants {
    private DefaultTableHeader hdr;
    private TableSortOptionPanel sortPanel;
    private TableHideOptionPanel hidePanel;
    private TableReorderOptionPanel reorderPanel;

    public TableOptionPanel(DefaultTableHeader hdr) {
        this.hdr = hdr;
        this.initializeTableOptionPanel();
    }

    public AbstractTableFilterOptionPanel getFilterPanel() {
        return this.hdr.getFilterOptionPanel();
    }

    protected TableHideOptionPanel getHidePanel() {
        return this.hidePanel;
    }

    protected TableReorderOptionPanel getReorderPanel() {
        return this.reorderPanel;
    }

    protected TableSortOptionPanel getSortPanel() {
        return this.sortPanel;
    }

    public DefaultTableHeader getTableHeader() {
        return this.hdr;
    }

    protected void initializeTableOptionPanel() {
        final TableWidget table = (TableWidget)this.hdr.getTable();
        if (table.isSortable()) {
            this.sortPanel = new TableSortOptionPanel(table);
        }
        this.hidePanel = new TableHideOptionPanel(table);
        if (this.hdr.getReorderingAllowed()) {
            this.reorderPanel = new TableReorderOptionPanel(table);
        }
        ArrayList tabNames = new ArrayList();
        this.populateTabNames(tabNames);
        ArrayList tabContents = new ArrayList();
        this.populateTabContents(tabContents);
        JTabbedPane tabs = new JTabbedPane();
        Iterator nameIterator = tabNames.iterator();
        Iterator panelIterator = tabContents.iterator();
        while (nameIterator.hasNext()) {
            tabs.addTab((String)nameIterator.next(), (Component)panelIterator.next());
        }
        this.setContent(tabs);
        this.addApplyActionListener(new ActionListener(){
            final EnhancedTableColumnModel colModel;
            {
                this.colModel = table.getEnhancedColumnModel();
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                EnhancedTableColumn col;
                int ndx;
                if (TableOptionPanel.this.sortPanel != null) {
                    this.colModel.setColumnsNotSorted();
                    for (ndx = 0; ndx < TableOptionPanel.this.sortPanel.getColumnCount(); ++ndx) {
                        col = TableOptionPanel.this.sortPanel.getColumn(ndx);
                        if (col == null) continue;
                        if (TableOptionPanel.this.sortPanel.isColumnSortedAscending(ndx)) {
                            this.colModel.setColumnSortedAscending(col, true);
                            continue;
                        }
                        this.colModel.setColumnSortedDescending(col, true);
                    }
                }
                table.setColumnsHidden(false);
                for (ndx = 0; ndx < TableOptionPanel.this.hidePanel.getColumnCount(); ++ndx) {
                    col = TableOptionPanel.this.hidePanel.getColumn(ndx);
                    if (col == null || col.isHidden()) continue;
                    this.colModel.setColumnHidden(col, true);
                }
                table.sizeColumnsToFitContainer(-1);
                AbstractTableFilterOptionPanel filterPanel = TableOptionPanel.this.hdr.getFilterOptionPanel();
                if (filterPanel != null) {
                    table.clearFilters();
                    for (int ndx2 = 0; ndx2 < filterPanel.getFilterCount(); ++ndx2) {
                        TableFilter filter = filterPanel.getFilter(ndx2);
                        if (filter == null || table.isFilteredBy(filter)) continue;
                        table.addFilter(filter);
                    }
                }
                if (TableOptionPanel.this.reorderPanel != null) {
                    TableOptionPanel.this.hdr.reorderColumns(TableOptionPanel.this.reorderPanel);
                }
                TableOptionPanel.this.hdr.repaint();
                table.repaint();
            }
        });
    }

    protected void populateTabContents(List tabContents) {
        AbstractTableFilterOptionPanel filterPanel = this.hdr.getFilterOptionPanel();
        if (filterPanel != null) {
            tabContents.add(filterPanel);
        }
        if (this.sortPanel != null) {
            tabContents.add(this.sortPanel);
        }
        tabContents.add(this.hidePanel);
        if (this.reorderPanel != null) {
            tabContents.add(this.reorderPanel);
        }
    }

    protected void populateTabNames(List tabNames) {
        if (this.hdr.getFilterOptionPanel() != null) {
            tabNames.add("Filter Rows");
        }
        if (this.sortPanel != null) {
            tabNames.add("Sort Rows");
        }
        tabNames.add("Hide Columns");
        if (this.reorderPanel != null) {
            tabNames.add("Reorder Columns");
        }
    }
}

