/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.table;

import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.ListWidget;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.util.WidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class TableReorderOptionPanel
extends JPanel {
    private final TableWidget table;
    private ListWidget list = null;

    public TableReorderOptionPanel(TableWidget table) {
        this.table = table;
        this.initializeTableReorderOptionPanel();
    }

    public Object[] getColumns() {
        return ((DefaultListModel)this.list.getModel()).toArray();
    }

    protected void initializeTableReorderOptionPanel() {
        final ButtonWidget upButton = new ButtonWidget("Up");
        final ButtonWidget downButton = new ButtonWidget("Down");
        WidgetUtilities.equalizeSizeConstraints(Arrays.asList(upButton, downButton));
        final DefaultListModel<Object> model = new DefaultListModel<Object>();
        Iterator iterator = this.table.getEnhancedColumnModel().getHiddenAndShownColumns().iterator();
        while (iterator.hasNext()) {
            model.addElement(((TableColumn)iterator.next()).getIdentifier());
        }
        this.list = new ListWidget((ListModel)model);
        this.list.setSelectionMode(0);
        this.updateUpDownEnabled(this.list, upButton, downButton);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                TableReorderOptionPanel.this.updateUpDownEnabled(TableReorderOptionPanel.this.list, upButton, downButton);
            }
        });
        upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int ndx = TableReorderOptionPanel.this.list.getSelectedIndex();
                Object val = model.remove(ndx--);
                model.add(ndx, val);
                TableReorderOptionPanel.this.list.setSelectedIndex(ndx);
            }
        });
        downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int ndx = TableReorderOptionPanel.this.list.getSelectedIndex();
                Object val = model.remove(ndx++);
                model.add(ndx, val);
                TableReorderOptionPanel.this.list.setSelectedIndex(ndx);
            }
        });
        this.setLayout(new BorderLayout());
        Box box = Box.createVerticalBox();
        box.add(upButton);
        box.add(downButton);
        this.add((Component)box, "East");
        this.add((Component)new JScrollPane(this.list), "Center");
    }

    public void setSelectedColumn(TableColumn column) {
        this.list.setSelectedValue(column.getIdentifier(), true);
    }

    protected void updateUpDownEnabled(ListWidget list, ButtonWidget upButton, ButtonWidget downButton) {
        int ndx = list.getSelectedIndex();
        upButton.setEnabled(ndx > 0);
        downButton.setEnabled(ndx >= 0 && ndx < list.getModel().getSize() - 1);
    }
}

