/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.table;

import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.table.AbstractTableOptionPanel;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class TableSortOptionPanel
extends AbstractTableOptionPanel {
    private static final String[] ORDERS = new String[]{"Ascending", "Descending"};

    public TableSortOptionPanel(TableWidget table) {
        super(table);
        this.initializeTableSortOptionPanel();
    }

    @Override
    protected void customizeColumnPanel(final JComponent columnPanel, ButtonWidget andButton, ButtonWidget deleteButton) {
        andButton.setText(", then");
        columnPanel.add(new LabelWidget(" in "));
        final JComboBox<String> orderBox = new JComboBox<String>(ORDERS);
        orderBox.setMaximumSize(orderBox.getPreferredSize());
        columnPanel.add(orderBox);
        columnPanel.add(new LabelWidget(" order"));
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JComponent colsPanel = (JComponent)columnPanel.getParent();
                if (colsPanel.getComponentCount() == 1) {
                    orderBox.setSelectedItem("Ascending");
                } else {
                    colsPanel.remove(columnPanel);
                    colsPanel.revalidate();
                    colsPanel.repaint();
                }
            }
        });
    }

    protected void initializeTableSortOptionPanel() {
        TableWidget table = this.getTable();
        JComponent colPanel = null;
        if (table.getSortedColumnCount() > 0) {
            Iterator iterator = table.getSortedColumns().iterator();
            int colNdx = 0;
            while (iterator.hasNext()) {
                EnhancedTableColumn col = (EnhancedTableColumn)iterator.next();
                colPanel = this.addColumnPanel(colNdx);
                ((JComboBox)colPanel.getComponent(1)).setSelectedItem(col.getIdentifier());
                if (col.isSortedDescending()) {
                    ((JComboBox)colPanel.getComponent(3)).setSelectedItem("Descending");
                }
                ++colNdx;
            }
        }
        this.initializeColumnsPanel(colPanel);
    }

    public boolean isColumnSortedAscending(int index) {
        return ((JComboBox)this.getColumnPanel(index).getComponent(3)).getSelectedItem().equals("Ascending");
    }
}

