/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.text;

import com.metamatrix.toolbox.ui.Validator;
import com.metamatrix.toolbox.ui.widget.text.TextConstants;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DefaultTextFieldModel
extends PlainDocument
implements TextConstants {
    private static final int MAX_CEILING = Short.MAX_VALUE;
    private boolean isModified;
    private boolean isValid = true;
    private Object validationResult;
    private List validChrs;
    private List invalidChrs;
    private List validChrRanges;
    private List invalidChrRanges;
    private List validators;
    private String oldText;
    private List listeners;
    private int maxLen = Short.MAX_VALUE;

    public DefaultTextFieldModel() {
        this.initializeDefaultTextFieldModel();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void addValidator(Validator validator) {
        if (this.validators == null) {
            this.validators = new ArrayList();
        }
        this.validators.add(validator);
    }

    public void addValidator(Validator validator, int index) {
        if (this.validators == null) {
            this.validators = new ArrayList();
        }
        this.validators.add(index, validator);
    }

    public void commit() {
        this.oldText = null;
    }

    protected void firePropertyChangeEvent(PropertyChangeEvent event) {
        ListIterator iterator = this.listeners.listIterator(this.listeners.size());
        while (iterator.hasPrevious()) {
            ((PropertyChangeListener)iterator.previous()).propertyChange(event);
        }
    }

    protected void firePropertyChangeEvent(String prop, String oldText, String newText) {
        if (this.listeners == null) {
            return;
        }
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, prop, oldText, newText));
    }

    protected void firePropertyChangeEvent(String prop, boolean oldVal, boolean newVal) {
        if (this.listeners == null) {
            return;
        }
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, prop, new Boolean(oldVal), new Boolean(newVal)));
    }

    protected void firePropertyChangeEvent(String prop, int oldVal, int newVal) {
        if (this.listeners == null) {
            return;
        }
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, prop, new Integer(oldVal), new Integer(newVal)));
    }

    public int getMaximumLength() {
        return this.maxLen;
    }

    public Object getValidationResult() {
        return this.validationResult;
    }

    protected void initializeDefaultTextFieldModel() {
    }

    @Override
    public void insertString(int index, String text, AttributeSet ignored) throws BadLocationException {
        if (this.oldText == null) {
            this.oldText = this.getText(0, this.getLength());
        }
        if (text != null) {
            if (this.maxLen > 0) {
                int availLen = this.maxLen - this.getLength();
                if (text.length() > availLen) {
                    this.invalidInsertionAttempted(text.charAt(availLen), this.maxLen);
                    if (availLen == 0) {
                        return;
                    }
                    text = text.substring(0, availLen);
                }
            }
            if (this.validChrs != null || this.validChrRanges != null || this.invalidChrs != null || this.invalidChrRanges != null) {
                StringCharacterIterator iterator = new StringCharacterIterator(text);
                int subNdx = index;
                char chr = iterator.current();
                while (chr != '\uffff') {
                    Iterator chrIterator;
                    boolean isValid = true;
                    if (this.invalidChrs != null) {
                        chrIterator = this.invalidChrs.iterator();
                        while (chrIterator.hasNext()) {
                            if (chr != ((Character)chrIterator.next()).charValue()) continue;
                            isValid = false;
                            break;
                        }
                    }
                    if (isValid && this.invalidChrRanges != null) {
                        chrIterator = this.invalidChrRanges.iterator();
                        while (chrIterator.hasNext()) {
                            if (chr < ((Character)chrIterator.next()).charValue() || chr > ((Character)chrIterator.next()).charValue()) continue;
                            isValid = false;
                            break;
                        }
                    }
                    if (isValid && (this.validChrs != null || this.validChrRanges != null)) {
                        isValid = false;
                        if (this.validChrs != null) {
                            chrIterator = this.validChrs.iterator();
                            while (chrIterator.hasNext()) {
                                if (chr != ((Character)chrIterator.next()).charValue()) continue;
                                isValid = true;
                                break;
                            }
                        }
                        if (!isValid && this.validChrRanges != null) {
                            chrIterator = this.validChrRanges.iterator();
                            while (chrIterator.hasNext()) {
                                if (chr < ((Character)chrIterator.next()).charValue() || chr > ((Character)chrIterator.next()).charValue()) continue;
                                isValid = true;
                                break;
                            }
                        }
                    }
                    if (!isValid) {
                        this.invalidInsertionAttempted(chr, subNdx);
                        return;
                    }
                    ++subNdx;
                    chr = iterator.next();
                }
            }
        }
        String oldText = this.getText(0, this.getLength());
        super.insertString(index, text, ignored);
        if (text != null && text.length() > 0) {
            this.firePropertyChangeEvent("text", oldText, this.getText(0, this.getLength()));
            this.setModified(true);
        }
    }

    protected void invalidInsertionAttempted(char character, int subIndex) {
        Toolkit.getDefaultToolkit().beep();
    }

    public boolean isValid() {
        if (!this.isModified) {
            return this.isValid;
        }
        this.setModified(false);
        boolean isValid = true;
        if (this.validators != null) {
            Iterator iterator = this.validators.iterator();
            while (iterator.hasNext()) {
                try {
                    this.validationResult = ((Validator)iterator.next()).validate(this.getText(0, this.getLength()));
                }
                catch (Exception err) {
                    this.validationResult = err;
                }
                if (Boolean.TRUE.equals(this.validationResult)) {
                    this.validationResult = null;
                    continue;
                }
                isValid = false;
            }
        }
        this.setValid(isValid);
        return isValid;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.size() == 0) {
            this.listeners = null;
        }
    }

    @Override
    public void remove(int index, int length) throws BadLocationException {
        if (this.oldText == null) {
            this.oldText = this.getText(0, this.getLength());
        }
        String oldText = this.getText(0, this.getLength());
        super.remove(index, length);
        if (length > 0) {
            this.firePropertyChangeEvent("text", oldText, this.getText(0, this.getLength()));
            this.setModified(true);
        }
    }

    public void removeValiditor(int index) {
        if (this.validators == null || this.validators.isEmpty()) {
            return;
        }
        this.validators.remove(index);
    }

    public void removeValiditor(Validator validator) {
        if (this.validators == null) {
            return;
        }
        this.validators.remove(validator);
    }

    public void rollback() throws BadLocationException {
        this.remove(0, this.getLength());
        this.insertString(0, this.oldText, null);
        this.oldText = null;
    }

    public void setInvalidCharacters(String invalidCharacters) throws ParseException {
        char nextChr;
        this.invalidChrRanges = null;
        this.invalidChrs = null;
        StringCharacterIterator iterator = new StringCharacterIterator(invalidCharacters);
        char chr = iterator.current();
        if (chr == '\uffff') {
            return;
        }
        int ndx = 0;
        do {
            nextChr = iterator.next();
            ++ndx;
            if (nextChr == '-') {
                if (this.invalidChrRanges == null) {
                    this.invalidChrRanges = new ArrayList();
                }
                this.invalidChrRanges.add(new Character(chr));
                chr = iterator.next();
                ++ndx;
                if (chr == '\uffff') {
                    throw new ParseException("Missing character after dash", ndx);
                }
                this.invalidChrRanges.add(new Character(chr));
                nextChr = iterator.next();
                ++ndx;
            } else {
                if (this.invalidChrs == null) {
                    this.invalidChrs = new ArrayList();
                }
                this.invalidChrs.add(new Character(chr));
            }
            chr = nextChr;
        } while (nextChr != '\uffff');
    }

    public void setMaximumLength(int length) {
        int oldLen = this.maxLen;
        if (length <= 0) {
            this.maxLen = Short.MAX_VALUE;
        } else {
            int n = this.maxLen = length < Short.MAX_VALUE ? length : Short.MAX_VALUE;
            if (this.getLength() > length) {
                try {
                    this.remove(length, this.getLength() - length);
                }
                catch (BadLocationException err) {
                    throw new RuntimeException(err.getMessage());
                }
            }
        }
        this.firePropertyChangeEvent("maximumLength", oldLen, this.maxLen);
    }

    public void setModified(boolean isModified) {
        boolean wasModified = this.isModified;
        if (wasModified != isModified) {
            this.isModified = isModified;
            this.firePropertyChangeEvent("modified", wasModified, isModified);
        }
    }

    public void setValid(boolean isValid) {
        boolean wasValid = this.isValid;
        if (wasValid != isValid) {
            this.isValid = isValid;
            this.firePropertyChangeEvent("valid", wasValid, isValid);
        }
    }

    public void setValidCharacters(String validCharacters) throws ParseException {
        char nextChr;
        this.validChrRanges = null;
        this.validChrs = null;
        StringCharacterIterator iterator = new StringCharacterIterator(validCharacters);
        char chr = iterator.current();
        if (chr == '\uffff') {
            return;
        }
        int ndx = 0;
        do {
            nextChr = iterator.next();
            ++ndx;
            if (nextChr == '-') {
                if (this.validChrRanges == null) {
                    this.validChrRanges = new ArrayList();
                }
                this.validChrRanges.add(new Character(chr));
                chr = iterator.next();
                ++ndx;
                if (chr == '\uffff') {
                    throw new ParseException("Missing character after dash", ndx);
                }
                this.validChrRanges.add(new Character(chr));
                nextChr = iterator.next();
                ++ndx;
            } else {
                if (this.validChrs == null) {
                    this.validChrs = new ArrayList();
                }
                this.validChrs.add(new Character(chr));
            }
            chr = nextChr;
        } while (nextChr != '\uffff');
    }
}

