/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.transfer;

import com.metamatrix.toolbox.ui.widget.transfer.DragAndDropController;
import java.awt.Component;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.InputEvent;
import java.util.Iterator;

public abstract class AbstractDragAndDropController
implements DragAndDropController,
DragGestureListener,
DragSourceListener,
DropTargetListener {
    private static final int DRAG_THRESHOLD = 3;
    private static transient Object dragSrc;
    private static transient Object dropTarget;
    private static transient boolean dragging;
    private static transient int actDropAction;
    private static boolean debug;
    private Component comp;
    private int allowedDragActions;
    private int allowedDropActions;
    private DragGestureRecognizer dragGestureRecognizer;
    private DropTarget dropTargetMgr;

    protected AbstractDragAndDropController() {
        this.constructAbstractDragAndDropController();
    }

    protected void constructAbstractDragAndDropController() {
        this.dragGestureRecognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(null, 0, this);
        this.dropTargetMgr = new DropTarget(null, 0, this);
        this.setAllowedDragActions(this.getDefaultAllowedDragActions());
        this.setAllowedDropActions(this.getDefaultAllowedDropActions());
    }

    protected void debug(String message) {
        if (!debug) {
            return;
        }
        String name = this.getClass().getName();
        System.out.println(name.substring(name.lastIndexOf(46) + 1) + ": " + message);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent event) {
        this.debug("dragDropEnd (No impl)");
        dragging = false;
        dropTarget = null;
        dragSrc = null;
        this.comp.repaint();
    }

    @Override
    public void dragEnter(DragSourceDragEvent event) {
        this.debug("dragEnter(source) (No impl)");
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        this.debug("dragEnter(target)");
        actDropAction = event.getDropAction();
        int allowedActions = this.getAllowedDropActions();
        if ((actDropAction & allowedActions) == 0) {
            actDropAction = (allowedActions & 2) != 0 ? 2 : 1;
        }
    }

    @Override
    public void dragExit(DragSourceEvent event) {
        this.debug("dragEnter(source) (No impl)");
    }

    @Override
    public void dragExit(DropTargetEvent event) {
        this.debug("dragEnter(target)");
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        int count;
        this.debug("dragGestureRecognized");
        Iterator<InputEvent> i = event.iterator();
        for (count = 0; count < 3 && i.hasNext(); ++count) {
            i.next();
        }
        dragging = count >= 3;
    }

    @Override
    public void dragOver(DragSourceDragEvent event) {
        this.debug("dragOver(source) (No impl)");
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
        this.debug("dragOver(target) (No impl)");
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        this.debug("drop (No impl)");
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent event) {
        this.debug("dropActionChanged(source) (No impl)");
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
        this.debug("dropActionChanged(target) (No impl)");
    }

    protected int getActualDropAction() {
        return actDropAction;
    }

    @Override
    public int getAllowedDragActions() {
        return this.allowedDragActions;
    }

    @Override
    public int getAllowedDropActions() {
        return this.allowedDropActions;
    }

    @Override
    public Component getComponent() {
        return this.comp;
    }

    protected int getDefaultAllowedDragActions() {
        return 3;
    }

    protected int getDefaultAllowedDropActions() {
        return 3;
    }

    @Override
    public Object getDragSource() {
        return dragSrc;
    }

    @Override
    public Object getDropTarget() {
        return dropTarget;
    }

    @Override
    public boolean isDragging() {
        return dragging;
    }

    @Override
    public void setAllowedDragActions(int actions) {
        this.allowedDragActions = actions;
        this.dragGestureRecognizer.setSourceActions(actions);
    }

    @Override
    public void setAllowedDropActions(int actions) {
        this.allowedDropActions = actions;
        this.dropTargetMgr.setDefaultActions(actions);
    }

    @Override
    public void setComponent(Component component) {
        this.comp = component;
        this.dragGestureRecognizer.setComponent(component);
        this.dropTargetMgr.setComponent(component);
    }

    public void setDragSource(Object source) {
        dragSrc = source;
    }

    public void setDropTarget(Object target) {
        dropTarget = target;
    }
}

