/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.transfer;

import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.transaction.TransactionException;
import com.metamatrix.common.transaction.UserTransaction;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.TreeNodeEditor;
import com.metamatrix.common.tree.TreeView;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.toolbox.ui.widget.transfer.AbstractDragAndDropController;
import com.metamatrix.toolbox.ui.widget.transfer.TransferableTreeNode;
import com.metamatrix.toolbox.ui.widget.transfer.TreeNodeDragAndDropController;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTreeNodeDragAndDropController
extends AbstractDragAndDropController
implements TreeNodeDragAndDropController {
    protected static transient TreeNode dragParent;
    protected static transient TreeNode dropParent;
    protected static transient int dropNdx;
    protected static transient int dragNdx;
    protected static transient TransferableTreeNode xferable;
    protected static transient boolean validDragSrc;
    protected static transient boolean validDropTarget;
    protected boolean allowsDropsWithinNodes;
    protected boolean allowsDropsBetweenNodes;
    protected TreeView view;
    protected transient boolean dragSrc;
    protected transient boolean dropTarget;
    protected boolean willDropAboveTarget;
    protected boolean willDropBelowTarget;
    protected boolean willDropOnTarget;

    public static int getDragIndex() {
        return dragNdx;
    }

    public static TreeNode getDragParent() {
        return dragParent;
    }

    public static int getDropIndex() {
        return dropNdx;
    }

    public static TreeNode getDropParent() {
        return dropParent;
    }

    protected static TransferableTreeNode getTransferable() {
        return xferable;
    }

    protected static boolean isValidDragSource() {
        return validDragSrc;
    }

    protected AbstractTreeNodeDragAndDropController(boolean allowsDropsWithinNodes, boolean allowsDropsBetweenNodes) {
        this.constructAbstractTreeNodeDragAndDropController(allowsDropsWithinNodes, allowsDropsBetweenNodes);
    }

    protected boolean addNode() {
        this.debug("addNode");
        if (this.getActualDropAction() == 2) {
            return this.transferNode();
        }
        return false;
    }

    public boolean allowsDropsBetweenNodes() {
        return this.allowsDropsBetweenNodes;
    }

    public boolean allowsDropsWithinNodes() {
        return this.allowsDropsWithinNodes;
    }

    protected void constructAbstractTreeNodeDragAndDropController(boolean allowsDropsWithinNodes, boolean allowsDropsBetweenNodes) {
        this.allowsDropsWithinNodes = allowsDropsWithinNodes;
        this.allowsDropsBetweenNodes = allowsDropsBetweenNodes;
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent event) {
        this.debug("dragDropEnd");
        dropParent = null;
        dragParent = null;
        validDropTarget = false;
        validDragSrc = false;
        this.dropTarget = false;
        this.dragSrc = false;
        super.dragDropEnd(event);
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        this.debug("dragEnter(target)");
        super.dragEnter(event);
        validDragSrc = this.getValidDragSource(event.getCurrentDataFlavors());
    }

    @Override
    public void dragExit(DragSourceEvent event) {
        this.debug("dragExit(source)");
        event.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
    }

    @Override
    public void dragExit(DropTargetEvent event) {
        this.debug("dragExit(target)");
        super.dragExit(event);
        validDropTarget = false;
    }

    @Override
    public void dragOver(DragSourceDragEvent event) {
        this.debug("dragOver(source)");
        int action = this.getActualDropAction();
        if (validDropTarget) {
            if (action == 1) {
                event.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
            } else {
                event.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
            }
        } else if (action == 1) {
            event.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
        } else {
            event.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
        this.debug("dragOver(target)");
        this.willDropOnTarget = false;
        this.willDropBelowTarget = false;
        this.willDropAboveTarget = false;
        this.setDropTarget(null);
        validDropTarget = false;
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        this.debug("drop");
        this.dropTarget = true;
        if (this.getDropTarget() != null) {
            if (this.dragSrc) {
                if (this.moveNode()) {
                    this.debug("drop moveNode()");
                    event.acceptDrop(event.getDropAction());
                } else {
                    this.debug("drop moveNode() rejectDrop()");
                    event.rejectDrop();
                }
            } else if (this.addNode()) {
                this.debug("drop addNode()");
                event.acceptDrop(event.getDropAction());
            } else {
                this.debug("drop addNode() rejectDrop()");
                event.rejectDrop();
            }
        } else {
            event.rejectDrop();
        }
        event.getDropTargetContext().dropComplete(true);
    }

    @Override
    protected int getDefaultAllowedDragActions() {
        return 2;
    }

    @Override
    protected int getDefaultAllowedDropActions() {
        return 2;
    }

    protected TreeView getTreeView() {
        return this.view;
    }

    protected boolean getValidDragSource(DataFlavor[] flavors) {
        int ndx = flavors.length;
        while (--ndx >= 0) {
            DataFlavor flavor = flavors[ndx];
            if (!this.isTreeNodeFlavor(flavor)) continue;
            return true;
        }
        return false;
    }

    protected boolean getValidDropTarget() {
        return validDropTarget;
    }

    protected boolean isDragSource() {
        return this.dragSrc;
    }

    protected boolean isDropTarget() {
        return this.dropTarget;
    }

    protected boolean isTreeNodeFlavor(DataFlavor flavor) {
        int ndx = TransferableTreeNode.FLAVORS.length;
        while (--ndx >= 0) {
            if (!flavor.equals(TransferableTreeNode.FLAVORS[ndx])) continue;
            return true;
        }
        return false;
    }

    protected boolean moveNode() {
        this.debug("moveNode");
        return this.transferNode();
    }

    public void setAllowsDropsBetweenNodes(boolean allowsDropsBetweenNodes) {
        this.debug("setAllowsDropsBetweenNodes: " + allowsDropsBetweenNodes);
        this.allowsDropsBetweenNodes = allowsDropsBetweenNodes;
    }

    public void setAllowsDropsWithinNodes(boolean allowsDropsWithinNodes) {
        this.debug("setAllowsDropsWithinNodes: " + allowsDropsWithinNodes);
        this.allowsDropsWithinNodes = allowsDropsWithinNodes;
    }

    protected void setDropNode(TreeNode dropNode, boolean betweenNodes) {
        TreeNode parent;
        TreeNode dragNode = (TreeNode)this.getDragSource();
        if (!betweenNodes && this.allowsDropsWithinNodes && this.view.allowsChildren(dropNode) && this.view.allowsChild(dropNode, dragNode) && dropNode != dragNode && dropNode != this.view.getParent(dragNode) && !this.view.isAncestorOf(dragNode, dropNode) && !this.view.getTreeNodeEditor().isReadOnly((PropertiedObject)dropNode)) {
            this.setDropTarget(dropNode);
            dropParent = dropNode;
            List children = this.view.getChildren(dropNode);
            dropNdx = children == null ? 0 : children.size();
            validDropTarget = true;
            return;
        }
        if (betweenNodes && this.allowsDropsBetweenNodes && (parent = this.view.getParent(dropNode)) != null && this.view.allowsChild(parent, dragNode) && parent != dragNode && !this.view.isAncestorOf(dragNode, parent) && !this.view.getTreeNodeEditor().isReadOnly((PropertiedObject)parent) && dropNode != dragNode) {
            List children = this.view.getChildren(parent);
            if (parent != this.view.getParent(dragNode) || (this.willDropBelowTarget || children.indexOf(dropNode) != children.indexOf(dragNode) + 1) && (this.willDropAboveTarget || children.indexOf(dropNode) != children.indexOf(dragNode) - 1)) {
                this.setDropTarget(dropNode);
                dropParent = parent;
                dropNdx = this.view.getChildren(parent).indexOf(dropNode);
                if (this.willDropBelowTarget) {
                    ++dropNdx;
                }
                validDropTarget = true;
                return;
            }
        }
    }

    protected void setTreeView(TreeView view) {
        this.view = view;
    }

    public void setWillDropAboveTarget(boolean aboveTarget) {
        this.willDropAboveTarget = aboveTarget;
    }

    public void setWillDropBelowTarget(boolean belowTarget) {
        this.willDropBelowTarget = belowTarget;
    }

    public void setWillDropOnTarget(boolean onTarget) {
        this.willDropOnTarget = onTarget;
    }

    protected void setValidDropTarget(boolean valid) {
        validDropTarget = valid;
    }

    protected void startDrag(DragGestureEvent event, TreeNode dragNode) {
        this.debug("startDrag TreeNode: " + dragNode);
        Assertion.isNotNull((Object)this.view, (String)("The setTreeView(TreeView) method must first be called with an instance of " + TreeView.class));
        ArrayList<TreeNode> listOfOne = new ArrayList<TreeNode>();
        listOfOne.add(dragNode);
        if (this.isDragCandidate(listOfOne)) {
            this.dragSrc = true;
            this.setDragSource(dragNode);
            xferable = new TransferableTreeNode(listOfOne);
            dragParent = this.view.getParent(dragNode);
            dragNdx = this.view.getChildren(dragParent).indexOf(dragNode);
            this.debug("startDrag: dragParent=" + dragParent + ", dragNdx=" + dragNdx);
            if (event.getDragAction() == 1) {
                DragSource.getDefaultDragSource().startDrag(event, DragSource.DefaultCopyDrop, xferable, this);
            } else {
                DragSource.getDefaultDragSource().startDrag(event, DragSource.DefaultMoveDrop, xferable, this);
            }
            super.dragGestureRecognized(event);
        }
    }

    protected void startDrag(DragGestureEvent event, List dragNode) {
        this.debug("startDrag List: " + dragNode);
        Assertion.isNotNull((Object)this.view, (String)("The setTreeView(TreeView) method must first be called with an instance of " + TreeView.class));
        if (this.isDragCandidate(dragNode)) {
            this.dragSrc = true;
            this.setDragSource(dragNode);
            xferable = new TransferableTreeNode(dragNode);
            dragParent = this.view.getParent((TreeNode)dragNode.get(0));
            dragNdx = this.view.getChildren(dragParent).indexOf(dragNode);
            this.debug("startDrag: dragParent=" + dragParent + ", dragNdx=" + dragNdx);
            if (event.getDragAction() == 1) {
                DragSource.getDefaultDragSource().startDrag(event, DragSource.DefaultCopyDrop, xferable, this);
            } else {
                DragSource.getDefaultDragSource().startDrag(event, DragSource.DefaultMoveDrop, xferable, this);
            }
            super.dragGestureRecognized(event);
        }
    }

    protected boolean isDragCandidate(List dragNode) {
        TreeNode parent = this.view.getParent((TreeNode)dragNode.get(0));
        return dragNode != null && parent != null && !this.view.getTreeNodeEditor().isReadOnly((PropertiedObject)parent);
    }

    protected boolean transferNode() {
        this.debug("transferNode");
        TreeNodeEditor editor = this.view.getTreeNodeEditor();
        boolean allSuccessful = false;
        if (this.getDragSource() instanceof TreeNode) {
            UserTransaction xaction = editor.createWriteTransaction((Object)this);
            boolean wasErr = true;
            try {
                xaction.begin();
                allSuccessful = editor.move((TreeNode)this.getDragSource(), dropParent, dropNdx);
                xaction.commit();
                wasErr = false;
            }
            catch (TransactionException err) {
                throw new RuntimeException(err.getMessage());
            }
            finally {
                try {
                    if (wasErr) {
                        xaction.rollback();
                    }
                }
                catch (TransactionException err) {
                    throw new RuntimeException(err.getMessage());
                }
            }
        }
        if (this.getDragSource() instanceof List) {
            for (TreeNode node : (List)this.getDragSource()) {
                UserTransaction xaction = editor.createWriteTransaction((Object)this);
                allSuccessful = true;
                boolean wasSuccessful = false;
                boolean wasErr = true;
                try {
                    xaction.begin();
                    wasSuccessful = editor.move(node, dropParent, dropNdx++);
                    if (!wasSuccessful) {
                        allSuccessful = false;
                    }
                    xaction.commit();
                    wasErr = false;
                }
                catch (TransactionException err) {
                    throw new RuntimeException(err.getMessage());
                }
                finally {
                    try {
                        if (!wasErr) continue;
                        xaction.rollback();
                    }
                    catch (TransactionException err) {
                        throw new RuntimeException(err.getMessage());
                    }
                }
            }
        }
        return allSuccessful;
    }

    @Override
    public boolean willDropAboveTarget() {
        return this.willDropAboveTarget;
    }

    @Override
    public boolean willDropBelowTarget() {
        return this.willDropBelowTarget;
    }

    @Override
    public boolean willDropOnTarget() {
        return this.willDropOnTarget;
    }
}

