/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.transfer;

import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.toolbox.ui.widget.transfer.Flavor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.List;

public class TransferableTreeNode
implements Transferable {
    static final DataFlavor[] FLAVORS = new DataFlavor[]{new Flavor("application/x-java-jvm-local-objectref", "Tree Node")};
    private TreeNode node;
    private List nodes;

    public TransferableTreeNode(TreeNode node) {
        this.initializeTransferableTreeNode(node);
    }

    public TransferableTreeNode(List nodes) {
        this.initializeTransferableTreeNode(nodes);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (this.isDataFlavorSupported(flavor)) {
            if (this.node != null) {
                return this.node;
            }
            return this.nodes;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])FLAVORS.clone();
    }

    protected void initializeTransferableTreeNode(List nodes) {
        this.nodes = nodes;
        ((Flavor)FLAVORS[0]).setTransferable(this);
    }

    protected void initializeTransferableTreeNode(TreeNode node) {
        this.node = node;
        ((Flavor)FLAVORS[0]).setTransferable(this);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        int ndx = FLAVORS.length;
        while (--ndx >= 0) {
            if (!flavor.equals(FLAVORS[ndx])) continue;
            return true;
        }
        return false;
    }
}

