/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.tree;

import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.TreeNodeEditor;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.TreeWidget;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeModel;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DefaultTreeCellEditor
extends javax.swing.tree.DefaultTreeCellEditor {
    public DefaultTreeCellEditor(TreeWidget tree, DefaultTreeCellRenderer renderer) {
        super(tree, renderer);
    }

    @Override
    protected TreeCellEditor createTreeCellEditor() {
        DefaultCellEditor editor = new DefaultCellEditor(new TextFieldWidget()){

            @Override
            public boolean shouldSelectCell(EventObject event) {
                boolean retValue = super.shouldSelectCell(event);
                this.getComponent().requestFocus();
                return retValue;
            }
        };
        editor.setClickCountToStart(1);
        return editor;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        this.renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, false);
        return super.getTreeCellEditorComponent(tree, value, selected, expanded, leaf, row);
    }

    @Override
    protected void prepareForEditing() {
        super.prepareForEditing();
        if (this.editingComponent != null) {
            this.editingComponent.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent event) {
                    if (DefaultTreeCellEditor.this.tree.isEditing()) {
                        DefaultTreeCellEditor.this.stopCellEditing();
                    }
                }
            });
        }
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        TreeNode node;
        TreeModel model = this.tree.getModel();
        TreePath path = this.tree.getSelectionPath();
        if (!(model instanceof DefaultTreeModel) || path == null) {
            return super.isCellEditable(event);
        }
        TreeNodeEditor editor = ((DefaultTreeModel)model).getTreeView().getTreeNodeEditor();
        PropertyDefinition nameDef = editor.getNamePropertyDefinition(node = (TreeNode)path.getLastPathComponent());
        if (nameDef == null || !editor.isReadOnly((PropertiedObject)node, nameDef)) {
            return super.isCellEditable(event);
        }
        return false;
    }
}

