/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.tree;

import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TreeWidget;
import com.metamatrix.toolbox.ui.widget.text.TextContainer;
import com.metamatrix.toolbox.ui.widget.transfer.TreeNodeDragAndDropController;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;

public class DefaultTreeCellRenderer
extends LabelWidget
implements TreeCellRenderer {
    static final Rectangle BOUNDS = new Rectangle();
    private static final String DROP_TARGET_SELECTION_COLOR = "DefaultTreeCellRenderer.dropTargetSelectionColor";
    private static final String DROP_TARGET_SELECTION_STROKE_WIDTH = "DefaultTreeCellRenderer.dropTargetSelectionStrokeWidth";
    private javax.swing.tree.DefaultTreeCellRenderer javaRenderer = new javax.swing.tree.DefaultTreeCellRenderer();
    private transient boolean isSelected;
    private transient boolean hasFocus;
    private boolean isFocusBorderDrawnAroundIcon;
    private boolean willDropAboveTarget;
    private boolean willDropBelowTarget;
    private boolean willDropOnTarget;

    public DefaultTreeCellRenderer() {
        this.initializeDefaultTreeCellRenderer();
    }

    public Color getBackgroundNonSelectionColor() {
        return this.javaRenderer.getBackgroundNonSelectionColor();
    }

    public Color getBackgroundSelectionColor() {
        return this.javaRenderer.getBackgroundSelectionColor();
    }

    public Color getBorderSelectionColor() {
        return this.javaRenderer.getBorderSelectionColor();
    }

    public Icon getClosedIcon() {
        return this.javaRenderer.getClosedIcon();
    }

    public Component getComponent() {
        return this;
    }

    public Icon getDisabledClosedIcon() {
        return this.javaRenderer.getClosedIcon();
    }

    public Icon getDisabledLeafIcon() {
        return this.javaRenderer.getLeafIcon();
    }

    public Icon getDisabledOpenIcon() {
        return this.javaRenderer.getOpenIcon();
    }

    private int getLabelStart() {
        Icon icon = this.getIcon();
        if (icon != null && this.getText() != null) {
            return icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        return 0;
    }

    public Icon getLeafIcon() {
        return this.javaRenderer.getLeafIcon();
    }

    public Icon getOpenIcon() {
        return this.javaRenderer.getOpenIcon();
    }

    public Color getTextNonSelectionColor() {
        return this.javaRenderer.getTextNonSelectionColor();
    }

    public Color getTextSelectionColor() {
        return this.javaRenderer.getTextSelectionColor();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
        Object target;
        if (value == null) {
            return this;
        }
        this.hasFocus = hasFocus;
        this.isSelected = isSelected;
        String text = tree.convertValueToText(value, isSelected, isExpanded, isLeaf, row, hasFocus);
        if (((TextContainer)((Object)tree)).isClipTipEnabled() && hasFocus) {
            Rectangle rowBounds = tree.getRowBounds(row);
            Container parent = tree.getParent();
            if (!tree.getBounds(BOUNDS).contains(rowBounds) || parent instanceof JViewport && parent.getWidth() < rowBounds.x + rowBounds.width) {
                this.setToolTipText(text);
            } else if (this.getToolTipText() != null) {
                this.setToolTipText(null);
            }
        }
        this.setText(text);
        this.setBackground(tree.getBackground());
        if (isSelected) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        if (!tree.isEnabled()) {
            this.setEnabled(false);
            if (isLeaf) {
                this.setDisabledIcon(this.getDisabledLeafIcon());
            } else if (isExpanded) {
                this.setDisabledIcon(this.getDisabledOpenIcon());
            } else {
                this.setDisabledIcon(this.getDisabledClosedIcon());
            }
        } else {
            this.setEnabled(true);
            if (isLeaf) {
                this.setIcon(this.getLeafIcon());
            } else if (isExpanded) {
                this.setIcon(this.getOpenIcon());
            } else {
                this.setIcon(this.getClosedIcon());
            }
        }
        this.willDropOnTarget = false;
        this.willDropBelowTarget = false;
        this.willDropAboveTarget = false;
        TreeWidget treeWidget = (TreeWidget)tree;
        TreeNodeDragAndDropController dndCtrlr = treeWidget.getDragAndDropController();
        if (dndCtrlr != null && dndCtrlr.isDragging() && (target = dndCtrlr.getDropTarget()) == value) {
            this.willDropAboveTarget = dndCtrlr.willDropAboveTarget();
            this.willDropBelowTarget = dndCtrlr.willDropBelowTarget();
            this.willDropOnTarget = dndCtrlr.willDropOnTarget();
        }
        return this;
    }

    protected void initializeDefaultTreeCellRenderer() {
        Object value = UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this.isFocusBorderDrawnAroundIcon = value != null && value instanceof Boolean && (Boolean)value != false;
    }

    public boolean isFocusBorderDrawnAroundIcon() {
        return this.isFocusBorderDrawnAroundIcon;
    }

    @Override
    public void paint(Graphics canvas) {
        Color color;
        if (this.isSelected) {
            color = this.getBackgroundSelectionColor();
        } else {
            color = this.getBackgroundNonSelectionColor();
            if (color == null) {
                color = this.getBackground();
            }
        }
        int imageOffset = -1;
        if (color != null) {
            imageOffset = this.getLabelStart();
            canvas.setColor(color);
            canvas.fillRect(imageOffset, 0, this.getWidth() - 1 - imageOffset, this.getHeight());
        }
        if (this.hasFocus && (color = this.getBorderSelectionColor()) != null) {
            if (this.isFocusBorderDrawnAroundIcon) {
                imageOffset = 0;
            } else if (imageOffset == -1) {
                imageOffset = this.getLabelStart();
            }
            canvas.setColor(color);
            canvas.drawRect(imageOffset, 0, this.getWidth() - 1 - imageOffset, this.getHeight() - 1);
        }
        super.paint(canvas);
        if (this.willDropOnTarget || this.willDropAboveTarget || this.willDropBelowTarget) {
            canvas.setColor(UIManager.getColor(DROP_TARGET_SELECTION_COLOR));
            int strokeWth = UIManager.getInt(DROP_TARGET_SELECTION_STROKE_WIDTH);
            ((Graphics2D)canvas).setStroke(new BasicStroke(strokeWth));
            strokeWth /= 2;
            if (this.willDropOnTarget) {
                canvas.drawRect(strokeWth, strokeWth, this.getWidth() - 1 - strokeWth, this.getHeight() - 1 - strokeWth);
            } else if (this.willDropAboveTarget) {
                canvas.drawLine(strokeWth, strokeWth, this.getWidth() - 1 - strokeWth, strokeWth);
            } else if (this.willDropBelowTarget) {
                canvas.drawLine(strokeWth, this.getHeight() - 1 - strokeWth, this.getWidth() - 1 - strokeWth, this.getHeight() - 1 - strokeWth);
            }
        }
    }

    public void setBackgroundNonSelectionColor(Color color) {
        this.javaRenderer.setBackgroundNonSelectionColor(color);
    }

    public void setBackgroundSelectionColor(Color color) {
        this.javaRenderer.setBackgroundSelectionColor(color);
    }

    public void setBorderSelectionColor(Color color) {
        this.javaRenderer.setBorderSelectionColor(color);
    }

    public void setClosedIcon(Icon icon) {
        this.javaRenderer.setClosedIcon(icon);
    }

    public void setDisabledClosedIcon(Icon icon) {
        this.javaRenderer.setClosedIcon(icon);
    }

    public void setDisabledLeafIcon(Icon icon) {
        this.javaRenderer.setLeafIcon(icon);
    }

    public void setDisabledOpenIcon(Icon icon) {
        this.javaRenderer.setOpenIcon(icon);
    }

    public void setFocusBorderDrawnAroundIcon(boolean isFocusBorderDrawnAroundIcon) {
        this.isFocusBorderDrawnAroundIcon = isFocusBorderDrawnAroundIcon;
    }

    public void setLeafIcon(Icon icon) {
        this.javaRenderer.setLeafIcon(icon);
    }

    public void setOpenIcon(Icon icon) {
        this.javaRenderer.setOpenIcon(icon);
    }

    public void setTextNonSelectionColor(Color color) {
        this.javaRenderer.setTextNonSelectionColor(color);
    }

    public void setTextSelectionColor(Color color) {
        this.javaRenderer.setTextSelectionColor(color);
    }
}

