/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.tree;

import com.metamatrix.api.exception.MultipleRuntimeException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.transaction.TransactionException;
import com.metamatrix.common.transaction.UserTransaction;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.TreeNodeEditor;
import com.metamatrix.common.tree.TreeView;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.toolbox.property.VetoedChangeEvent;
import com.metamatrix.toolbox.property.VetoedChangeListener;
import com.metamatrix.toolbox.ui.widget.TreeWidget;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeNode;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeView;
import com.metamatrix.toolbox.ui.widget.tree.TreeConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DefaultTreeModel
implements TreeConstants,
TreeModel {
    public static final int MODEL_CHANGED = 0;
    public static final int NODE_CHANGED = 1;
    public static final int NODE_ADDED = 2;
    public static final int NODE_REMOVED = 3;
    public static final int NODES_CHANGED = 4;
    private static final String HIDDEN_ROOT_NAME = "Root";
    private TreeView view;
    private List modelListeners;
    private List vetoListeners;
    private transient Object value;
    private Object xactionSrc;
    private DefaultTreeNode hiddenRoot;
    private boolean forceHiddenRoot;
    private transient TreeNode node;

    public DefaultTreeModel() {
        this(null, false);
    }

    public DefaultTreeModel(TreeView view) {
        this(view, false);
    }

    public DefaultTreeModel(TreeView view, boolean forceHiddenRoot) {
        this.view = view;
        this.forceHiddenRoot = forceHiddenRoot;
        this.initializeDefaultTreeModel();
    }

    public DefaultTreeModel(Object value) {
        this.value = value;
        this.initializeDefaultTreeModel();
    }

    public TreeNode addNode(final TreeNode parent, final String childName) {
        Assertion.assertTrue((this.hiddenRoot == null || parent != this.hiddenRoot ? 1 : 0) != 0, (String)"Nodes may not be added to the temporary root");
        boolean succeeded = this.executeTransaction(new EditorTask(){

            @Override
            public boolean execute(TreeNodeEditor editor) {
                Assertion.assertTrue((!editor.isReadOnly((PropertiedObject)parent) ? 1 : 0) != 0, (String)"Parent node is read-only");
                DefaultTreeModel.this.node = editor.create(parent, childName, null);
                DefaultTreeModel.this.fireEvent(2, DefaultTreeModel.this.getTransactionSource(), DefaultTreeModel.this.node);
                return true;
            }
        }, "addNode(TreeNode, String)");
        if (!succeeded) {
            return null;
        }
        return this.node;
    }

    @Override
    public synchronized void addTreeModelListener(TreeModelListener listener) {
        if (this.modelListeners == null) {
            this.modelListeners = Collections.synchronizedList(new ArrayList());
        }
        this.modelListeners.add(listener);
    }

    public void addVetoedChangeListener(VetoedChangeListener listener) {
        if (this.vetoListeners == null) {
            this.vetoListeners = Collections.synchronizedList(new ArrayList());
        }
        this.vetoListeners.add(listener);
    }

    protected TreeView createDefaultTreeView(Object value) {
        return new DefaultTreeView(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean executeTransaction(EditorTask task, String context) {
        Throwable delayedErr = null;
        TreeNodeEditor editor = this.getEditor();
        Assertion.isNotNull((Object)editor);
        UserTransaction xaction = editor.createWriteTransaction(this.getTransactionSource());
        boolean succeeded = false;
        xaction.begin();
        succeeded = task.execute(editor);
        if (succeeded) {
            succeeded = false;
            xaction.commit();
            return true;
        }
        if (succeeded) return succeeded;
        try {
            xaction.rollback();
            return succeeded;
        }
        catch (TransactionException err) {
            if (delayedErr == null) {
                delayedErr = err;
            }
            delayedErr = new MultipleRuntimeException(new Throwable[]{delayedErr, err});
            return (boolean)delayedErr;
        }
        finally {
            if (delayedErr == null) return succeeded;
            if (!(delayedErr instanceof RuntimeException)) {
                delayedErr = new MetaMatrixRuntimeException(delayedErr);
            }
            LogManager.logCritical((String)(this.getClass().getName() + '.' + context), (Throwable)delayedErr, (String)null);
            throw (RuntimeException)delayedErr;
        }
        catch (Throwable err) {
            try {
                delayedErr = err;
                if (succeeded) return succeeded;
            }
            catch (Throwable throwable) {
                if (succeeded) throw throwable;
                try {
                    xaction.rollback();
                    throw throwable;
                }
                catch (TransactionException err2) {
                    if (delayedErr == null) {
                        delayedErr = err2;
                    }
                    delayedErr = new MultipleRuntimeException(new Throwable[]{delayedErr, err2});
                    return (boolean)delayedErr;
                }
                finally {
                    if (delayedErr == null) throw throwable;
                    if (!(delayedErr instanceof RuntimeException)) {
                        delayedErr = new MetaMatrixRuntimeException(delayedErr);
                    }
                    LogManager.logCritical((String)(this.getClass().getName() + '.' + context), (Throwable)delayedErr, (String)null);
                    throw (RuntimeException)delayedErr;
                }
            }
            try {
                xaction.rollback();
            }
            catch (TransactionException err3) {
                if (delayedErr == null) {
                    delayedErr = err3;
                }
                delayedErr = new MultipleRuntimeException(new Throwable[]{delayedErr, err3});
                return (boolean)delayedErr;
            }
            finally {
                if (delayedErr == null) return succeeded;
                if (!(delayedErr instanceof RuntimeException)) {
                    delayedErr = new MetaMatrixRuntimeException(delayedErr);
                }
                LogManager.logCritical((String)(this.getClass().getName() + '.' + context), (Throwable)delayedErr, (String)null);
                throw (RuntimeException)delayedErr;
            }
        }
    }

    public void fireChildrenChangedEvent(Object source, TreeNode parent) {
        List childList = this.view.getChildren(parent);
        int count = childList.size();
        int[] ndxs = new int[count];
        Object[] children = new Object[count];
        Iterator iter = childList.iterator();
        int ndx = 0;
        while (iter.hasNext()) {
            ndxs[ndx] = ndx;
            children[ndx] = iter.next();
            ++ndx;
        }
        this.fireEvent(0, source, this.getPath(parent, 0), ndxs, children);
    }

    protected void fireEvent(int type, Object source, TreeNode node) {
        TreeNode parent = this.view.getParent(node);
        if (parent == null) {
            if (this.hiddenRoot != null) {
                this.fireEvent(type, source, this.getPath(this.hiddenRoot, 0), new int[]{this.view.getRoots().indexOf(node)}, new Object[]{node});
            } else {
                this.fireEvent(type, source, this.getPath(node, 0), null, null);
            }
        } else {
            int index = this.getChildIndex(parent, node);
            if (index != -1) {
                this.fireEvent(type, source, this.getPath(parent, 0), new int[]{index}, new Object[]{node});
            }
        }
    }

    protected void fireEvent(Object source, TreeNode parent, TreeNode child, int childIndex) {
        if (parent == null && this.hiddenRoot != null) {
            this.fireEvent(3, source, this.getPath(this.hiddenRoot, 0), new int[]{childIndex}, new TreeNode[]{child});
        } else {
            this.fireEvent(3, source, this.getPath(parent, 0), new int[]{childIndex}, new TreeNode[]{child});
        }
    }

    protected void fireEvent(final int type, final Object source, final Object[] path, final int[] childIndices, final Object[] children) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.fireEventInner(type, source, path, childIndices, children);
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DefaultTreeModel.this.fireEventInner(type, source, path, childIndices, children);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private synchronized void fireEventInner(int type, Object source, Object[] path, int[] childIndices, Object[] children) {
        if (this.modelListeners == null) {
            return;
        }
        ArrayList listeners = new ArrayList(this.modelListeners);
        Iterator iterator = listeners.iterator();
        TreeModelEvent event = null;
        block5: while (iterator.hasNext()) {
            if (event == null) {
                event = new TreeModelEvent(source, path, childIndices, children);
            }
            TreeModelListener listener = (TreeModelListener)iterator.next();
            switch (type) {
                case 1: 
                case 4: {
                    listener.treeNodesChanged(event);
                    continue block5;
                }
                case 2: {
                    listener.treeNodesInserted(event);
                    continue block5;
                }
                case 3: {
                    listener.treeNodesRemoved(event);
                    continue block5;
                }
            }
            listener.treeStructureChanged(event);
        }
    }

    public void fireModelChangedEvent(Object source, TreeNode node) {
        this.fireEvent(0, source, this.getPath(node, 0), null, null);
    }

    public void fireNodeAddedEvent(Object source, TreeNode node) {
        this.fireEvent(2, source, node);
    }

    public void fireNodeChangedEvent(Object source, TreeNode node) {
        this.fireEvent(1, source, node);
    }

    public void fireNodeRemovedEvent(Object source, TreeNode parent, TreeNode child, int childIndex) {
        this.fireEvent(source, parent, child, childIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireVetoedChangeEvent(TreePath path, String property, Object name) {
        if (this.vetoListeners == null) {
            return;
        }
        VetoedChangeEvent event = new VetoedChangeEvent(path, property, name);
        List list = this.vetoListeners;
        synchronized (list) {
            Iterator iterator = this.vetoListeners.iterator();
            while (iterator.hasNext()) {
                ((VetoedChangeListener)iterator.next()).changeVetoed(event);
            }
        }
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (this.hiddenRoot != null && parent == this.hiddenRoot) {
            return this.view.getRoots().get(index);
        }
        List children = this.view.getChildren((TreeNode)parent);
        if (children == null || children.isEmpty() || index >= children.size()) {
            return null;
        }
        return children.get(index);
    }

    @Override
    public int getChildCount(Object parent) {
        if (this.hiddenRoot != null && parent == this.hiddenRoot) {
            return this.view.getRoots().size();
        }
        List children = this.view.getChildren((TreeNode)parent);
        if (children == null) {
            return 0;
        }
        return children.size();
    }

    protected int getChildIndex(Object parent, Object child) {
        if (parent == null) {
            return 0;
        }
        if (this.hiddenRoot != null && parent == this.hiddenRoot) {
            return this.view.getRoots().indexOf(child);
        }
        List children = this.view.getChildren((TreeNode)parent);
        if (children == null || children.isEmpty()) {
            return -1;
        }
        return children.indexOf(child);
    }

    public TreeNodeEditor getEditor() {
        return this.view.getTreeNodeEditor();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return this.getChildIndex(parent, child);
    }

    public String getName(TreeNode node) {
        return node.getName();
    }

    public TreeNode[] getPath(TreeNode node) {
        return this.getPath(node, 0);
    }

    protected TreeNode[] getPath(TreeNode node, int size) {
        if (node == null || node == this.hiddenRoot) {
            if (this.hiddenRoot != null) {
                TreeNode[] path = new TreeNode[size + 1];
                path[0] = this.hiddenRoot;
                return path;
            }
            return new TreeNode[size];
        }
        TreeNode[] path = this.getPath(this.view.getParent(node), ++size);
        path[path.length - size] = node;
        return path;
    }

    @Override
    public Object getRoot() {
        if (this.hiddenRoot != null) {
            return this.hiddenRoot;
        }
        return this.view.getRoots().get(0);
    }

    public Object getTransactionSource() {
        return this.xactionSrc;
    }

    public TreeView getTreeView() {
        return this.view;
    }

    protected void initializeDefaultTreeModel() {
        this.xactionSrc = this;
        if (this.view == null) {
            this.view = this.createDefaultTreeView(this.value);
        }
        this.setTreeView(this.view);
    }

    @Override
    public boolean isLeaf(Object node) {
        if (this.hiddenRoot != null && node == this.hiddenRoot) {
            return false;
        }
        return !this.view.allowsChildren((TreeNode)node);
    }

    public boolean isRootHidden() {
        return this.hiddenRoot != null;
    }

    public boolean moveNode(TreeNode node, TreeNode parent) {
        return this.moveNode(node, parent, this.getChildCount(parent));
    }

    public boolean moveNode(final TreeNode node, final TreeNode parent, final int index) {
        Assertion.assertTrue((this.hiddenRoot == null || parent != this.hiddenRoot && !this.view.getRoots().contains(parent) ? 1 : 0) != 0, (String)"Nodes may not be moved within the temporary root");
        return this.executeTransaction(new EditorTask(){

            @Override
            public boolean execute(TreeNodeEditor editor) {
                TreeNode oldParent = DefaultTreeModel.this.view.getParent(node);
                Assertion.assertTrue((!editor.isReadOnly((PropertiedObject)oldParent) ? 1 : 0) != 0, (String)"Node's original parent is read-only");
                Assertion.assertTrue((!editor.isReadOnly((PropertiedObject)parent) ? 1 : 0) != 0, (String)"Node's new parent is read-only");
                int ndx = DefaultTreeModel.this.getChildIndex(oldParent, node);
                if (editor.move(node, parent, index)) {
                    DefaultTreeModel.this.fireEvent(DefaultTreeModel.this.getTransactionSource(), oldParent, node, ndx);
                    DefaultTreeModel.this.fireNodeAddedEvent(DefaultTreeModel.this.getTransactionSource(), node);
                    return true;
                }
                return false;
            }
        }, "moveNode(TreeNode, TreeNode, int)");
    }

    public boolean removeNode(final TreeNode node) {
        Assertion.assertTrue((this.hiddenRoot == null || node != this.hiddenRoot && !this.view.getRoots().contains(node) ? 1 : 0) != 0, (String)"Nodes may not be removed from the temporary root");
        return this.executeTransaction(new EditorTask(){

            @Override
            public boolean execute(TreeNodeEditor editor) {
                TreeNode parent = DefaultTreeModel.this.view.getParent(node);
                Assertion.assertTrue((!editor.isReadOnly((PropertiedObject)parent) ? 1 : 0) != 0, (String)"Node's parent is read-only");
                int ndx = DefaultTreeModel.this.getChildIndex(parent, node);
                if (editor.delete(node)) {
                    DefaultTreeModel.this.fireEvent(DefaultTreeModel.this.getTransactionSource(), parent, node, ndx);
                    return true;
                }
                return false;
            }
        }, "removeNode(TreeNode)");
    }

    @Override
    public synchronized void removeTreeModelListener(TreeModelListener listener) {
        if (this.modelListeners == null) {
            return;
        }
        this.modelListeners.remove(listener);
        if (this.modelListeners.size() == 0) {
            this.modelListeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVetoedChangeListener(VetoedChangeListener listener) {
        List list = this.vetoListeners;
        synchronized (list) {
            if (this.vetoListeners == null) {
                return;
            }
            this.vetoListeners.remove(listener);
            if (this.vetoListeners.size() == 0) {
                this.vetoListeners = null;
            }
        }
    }

    public boolean setName(final TreeNode node, final String name) {
        if (this.hiddenRoot != null && node == this.hiddenRoot) {
            this.hiddenRoot.setName(name);
            return true;
        }
        return this.executeTransaction(new EditorTask(){

            @Override
            public boolean execute(TreeNodeEditor editor) {
                if (name != null && name.length() > 0 && !editor.isReadOnly((PropertiedObject)node) && editor.isValidValue((PropertiedObject)node, editor.getNamePropertyDefinition(node), (Object)name) && editor.rename(node, name)) {
                    DefaultTreeModel.this.fireEvent(1, DefaultTreeModel.this.getTransactionSource(), node);
                    return true;
                }
                return false;
            }
        }, "setName(TreeNode, String)");
    }

    public void setTreeWidget(TreeWidget treeWidget) {
    }

    public void setTransactionSource(Object source) {
        this.xactionSrc = source == null ? this : source;
    }

    public void setTreeView(TreeView view) {
        this.view = view;
        List roots = view.getRoots();
        if (this.forceHiddenRoot || roots.size() > 1) {
            this.hiddenRoot = new DefaultTreeNode(HIDDEN_ROOT_NAME);
            this.hiddenRoot.addChildren(roots);
            this.fireModelChangedEvent(this.xactionSrc, this.hiddenRoot);
        } else {
            this.hiddenRoot = null;
            this.fireModelChangedEvent(this.xactionSrc, (TreeNode)roots.get(0));
        }
    }

    @Override
    public void valueForPathChanged(TreePath path, Object name) {
        if (path != null) {
            TreeNode node = (TreeNode)path.getLastPathComponent();
            if (name != null) {
                if (name.equals(node.getName())) {
                    this.fireVetoedChangeEvent(path, "name", name);
                } else if (!this.setName(node, name.toString())) {
                    this.fireVetoedChangeEvent(path, "name", name);
                }
            }
        }
    }

    private static interface EditorTask {
        public boolean execute(TreeNodeEditor var1) throws Exception;
    }
}

