/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.tree;

import com.metamatrix.common.object.ObjectDefinition;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.toolbox.ui.EmptyObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class DefaultTreeNode
implements Cloneable,
TreeNode {
    private Object content = null;
    private String name = null;
    private DefaultTreeNode parent = null;
    private ArrayList children = null;
    private ArrayList rootList = null;

    public DefaultTreeNode() {
        this(null, null, null);
    }

    public DefaultTreeNode(String name) {
        this(name, null, null);
    }

    public DefaultTreeNode(DefaultTreeNode parent) {
        this(null, parent, null);
    }

    public DefaultTreeNode(Object content) {
        this(null, null, content);
    }

    public DefaultTreeNode(String name, DefaultTreeNode parent) {
        this(name, parent, null);
    }

    public DefaultTreeNode(String name, Object content) {
        this(name, null, content);
    }

    public DefaultTreeNode(Object content, DefaultTreeNode parent) {
        this(null, parent, content);
    }

    public DefaultTreeNode(String name, DefaultTreeNode parent, Object content) {
        this.name = name;
        this.parent = parent;
        this.content = content;
        this.initializeDefaultTreeNode();
    }

    public synchronized int addChild(Object child) {
        this.createChildList();
        int ndx = this.children.size();
        if (this.addChild(child, ndx)) {
            return ndx;
        }
        return -1;
    }

    public synchronized boolean addChild(Object child, int index) {
        if (!(child instanceof DefaultTreeNode)) {
            child = new DefaultTreeNode(child.toString());
        }
        this.createChildList();
        int oldCount = this.children.size();
        this.children.add(index, child);
        if (this.children.size() <= oldCount) {
            return false;
        }
        ((DefaultTreeNode)child).parent = this;
        return true;
    }

    public synchronized int addChildren(Object[] children) {
        this.createChildList();
        int count = 0;
        for (int ndx = 0; ndx < children.length; ++ndx) {
            if (this.addChild(children[ndx]) < 0) continue;
            ++count;
        }
        return count;
    }

    public synchronized int addChildren(Collection children) {
        this.createChildList();
        int count = 0;
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            if (this.addChild(iterator.next()) < 0) continue;
            ++count;
        }
        return count;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int compareTo(Object node) {
        return this.getName().compareTo(((DefaultTreeNode)node).getName());
    }

    public synchronized boolean contains(DefaultTreeNode child) {
        if (this.children == null) {
            return false;
        }
        return this.children.contains(child);
    }

    protected synchronized void createChildList() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
    }

    public boolean equals(Object node) {
        return this == node;
    }

    public boolean exists() {
        throw new UnsupportedOperationException();
    }

    public DefaultTreeNode getChild(int index) {
        return (DefaultTreeNode)this.children.get(index);
    }

    public synchronized int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public synchronized int getChildIndex(DefaultTreeNode child) {
        return this.children.indexOf(child);
    }

    public List getChildren() {
        return this.children;
    }

    public Object getContent() {
        return this.content;
    }

    public String getFullName() {
        return this.getName();
    }

    public synchronized Iterator getIterator() {
        if (this.children == null) {
            return EmptyObject.ITERATOR;
        }
        return this.children.iterator();
    }

    public synchronized ListIterator getListIterator() {
        if (this.children == null) {
            return EmptyObject.LIST_ITERATOR;
        }
        return this.children.listIterator();
    }

    public synchronized String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.content != null) {
            return this.content.toString();
        }
        return this.toString();
    }

    public String getNamespace() {
        throw new UnsupportedOperationException();
    }

    public DefaultTreeNode getParent() {
        return this.parent;
    }

    public synchronized DefaultTreeNode getRoot() {
        DefaultTreeNode node = this;
        DefaultTreeNode parent = node.getParent();
        while (parent != null) {
            node = parent;
            parent = node.getParent();
        }
        return node;
    }

    public synchronized List getRoots() {
        if (this.rootList == null) {
            this.rootList = new ArrayList();
            this.rootList.add(this.getRoot());
        } else {
            this.rootList.set(0, this.getRoot());
        }
        return Collections.unmodifiableList(this.rootList);
    }

    public String getSeparator() {
        throw new UnsupportedOperationException();
    }

    public char getSeparatorChar() {
        throw new UnsupportedOperationException();
    }

    public ObjectDefinition getType() {
        throw new UnsupportedOperationException();
    }

    protected synchronized void initializeDefaultTreeNode() {
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    public synchronized boolean isDescendentOf(DefaultTreeNode ancestor) {
        DefaultTreeNode parent;
        DefaultTreeNode descendent = this;
        do {
            if ((parent = descendent.getParent()) == ancestor) {
                return true;
            }
            descendent = parent;
        } while (parent != null);
        return false;
    }

    public synchronized boolean isEmpty() {
        if (this.children == null) {
            return true;
        }
        return this.children.isEmpty();
    }

    public boolean isModified() {
        return false;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public synchronized int removeAllChildren() {
        if (this.children == null || this.children.isEmpty()) {
            return 0;
        }
        int count = 0;
        while (!this.children.isEmpty()) {
            if (this.removeChild((DefaultTreeNode)this.children.get(0)) < 0) continue;
            ++count;
        }
        return count;
    }

    public synchronized int removeChild(DefaultTreeNode child) {
        if (this.children == null) {
            return -1;
        }
        int ndx = this.children.indexOf(child);
        if (ndx < 0 || !this.children.remove(child)) {
            return -1;
        }
        child.parent = null;
        return ndx;
    }

    public synchronized DefaultTreeNode removeChild(int index) {
        DefaultTreeNode child = (DefaultTreeNode)this.children.remove(index);
        if (child != null) {
            child.parent = null;
        }
        return child;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    public void setName(String name) {
        this.name = name;
    }
}

