/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.tree;

import com.metamatrix.common.object.ObjectDefinition;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertyAccessPolicy;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.transaction.UserTransaction;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.TreeNodeEditor;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DefaultTreeNodeEditor
implements TreeNodeEditor {
    private HashMap childrenMap;
    private HashMap parentMap;

    public DefaultTreeNodeEditor(DefaultTreeNode root, HashMap parentMap, HashMap childrenMap) {
        this.parentMap = parentMap;
        this.childrenMap = childrenMap;
        this.initializeDefaultTreeEditor();
    }

    public TreeNode create(TreeNode parent, ObjectDefinition type) {
        return this.create(parent, null, type);
    }

    public TreeNode create(TreeNode parent, String childName, ObjectDefinition type) {
        DefaultTreeNode dfltParent = this.toDefaultTreeNode(parent);
        if (childName == null) {
            childName = type.getDisplayName();
        }
        DefaultTreeNode child = new DefaultTreeNode(childName);
        if (this.childrenMap != null && this.childrenMap.containsKey(dfltParent)) {
            ArrayList<DefaultTreeNode> children = (ArrayList<DefaultTreeNode>)this.childrenMap.get(dfltParent);
            if (children == null) {
                children = new ArrayList<DefaultTreeNode>();
                this.childrenMap.put(dfltParent, children);
            }
            children.add(child);
            if (this.parentMap == null) {
                this.parentMap = new HashMap();
            }
            this.parentMap.put(child, parent);
        } else {
            dfltParent.addChild(child);
        }
        return child;
    }

    public UserTransaction createReadTransaction() {
        return new Transaction();
    }

    public UserTransaction createWriteTransaction() {
        throw new UnsupportedOperationException();
    }

    public UserTransaction createWriteTransaction(Object source) {
        return new Transaction(source);
    }

    public boolean delete(TreeNode node) {
        DefaultTreeNode dfltNode = this.toDefaultTreeNode(node);
        return dfltNode.getParent().removeChild(dfltNode) >= 0;
    }

    public PropertyAccessPolicy getPolicy() {
        throw new UnsupportedOperationException();
    }

    public List getPropertyDefinitions(PropertiedObject object) {
        throw new UnsupportedOperationException();
    }

    public List getAllowedValues(PropertiedObject object, PropertyDefinition def) {
        throw new UnsupportedOperationException();
    }

    public PropertyDefinition getNamePropertyDefinition(TreeNode obj) {
        return null;
    }

    public Object getValue(PropertiedObject object, PropertyDefinition definition) {
        throw new UnsupportedOperationException();
    }

    protected void initializeDefaultTreeEditor() {
    }

    public boolean isAncestorOf(TreeNode ancestor, TreeNode descendent) {
        DefaultTreeNode dfltAncestor = this.toDefaultTreeNode(ancestor);
        DefaultTreeNode dfltDescendent = this.toDefaultTreeNode(descendent);
        return dfltDescendent.isDescendentOf(dfltAncestor);
    }

    public boolean isMarked(TreeNode node) {
        throw new UnsupportedOperationException();
    }

    public boolean isParentOf(TreeNode parent, TreeNode child) {
        DefaultTreeNode dfltChild = this.toDefaultTreeNode(child);
        return dfltChild.getParent() == parent;
    }

    public boolean isReadOnly(PropertiedObject object) {
        return false;
    }

    public boolean isReadOnly(PropertiedObject object, PropertyDefinition definition) {
        return false;
    }

    public boolean isValidValue(PropertiedObject object, PropertyDefinition definition, Object value) {
        return true;
    }

    public boolean move(TreeNode child, TreeNode parent) {
        DefaultTreeNode dfltChild = this.toDefaultTreeNode(child);
        DefaultTreeNode dfltParent = this.toDefaultTreeNode(parent);
        if (dfltChild.getParent().removeChild(dfltChild) < 0) {
            return false;
        }
        return dfltParent.addChild(child) >= 0;
    }

    public boolean move(TreeNode child, TreeNode parent, int index) {
        DefaultTreeNode dfltChild = this.toDefaultTreeNode(child);
        DefaultTreeNode dfltParent = this.toDefaultTreeNode(parent);
        if (dfltChild.getParent().removeChild(dfltChild) < 0) {
            return false;
        }
        return dfltParent.addChild(child, index);
    }

    public boolean moveChild(TreeNode child, int index) {
        DefaultTreeNode dfltChild = this.toDefaultTreeNode(child);
        DefaultTreeNode parent = dfltChild.getParent();
        int oldNdx = parent.removeChild(dfltChild);
        if (oldNdx < 0) {
            return false;
        }
        if (oldNdx >= index) {
            return parent.addChild(dfltChild, index);
        }
        return parent.addChild(dfltChild, index - 1);
    }

    public TreeNode paste(TreeNode child, TreeNode parent, boolean isCopyDeep) {
        DefaultTreeNode dfltChild = this.toDefaultTreeNode(child);
        DefaultTreeNode dfltParent = this.toDefaultTreeNode(parent);
        try {
            dfltChild = (DefaultTreeNode)dfltChild.clone();
            dfltParent.addChild(dfltChild);
        }
        catch (CloneNotSupportedException notPossible) {
            // empty catch block
        }
        return dfltChild;
    }

    public boolean rename(TreeNode node, String name) {
        if (!(node instanceof DefaultTreeNode)) {
            throw new IllegalArgumentException("The node parameter must be an instance of DefaultTreeNode");
        }
        ((DefaultTreeNode)node).setName(name);
        return true;
    }

    public void reset(PropertiedObject object) {
        throw new UnsupportedOperationException();
    }

    public void setMarked(TreeNode node, boolean isMarked) {
        throw new UnsupportedOperationException();
    }

    public void setPolicy(PropertyAccessPolicy policy) {
        throw new UnsupportedOperationException();
    }

    public void setReadOnly(PropertiedObject object, boolean isReadOnly) {
        throw new UnsupportedOperationException();
    }

    public void setReadOnly(PropertiedObject object, PropertyDefinition definition, boolean isReadOnly) {
        throw new UnsupportedOperationException();
    }

    public void setValue(PropertiedObject object, PropertyDefinition definition, Object value) {
        throw new UnsupportedOperationException();
    }

    private DefaultTreeNode toDefaultTreeNode(TreeNode node) {
        if (!(node instanceof DefaultTreeNode)) {
            throw new IllegalArgumentException("TreeNode parameters must be an instance of DefaultTreeNode");
        }
        return (DefaultTreeNode)node;
    }

    private class Transaction
    implements UserTransaction {
        private Object src = null;

        private Transaction() {
            this((Object)null);
        }

        private Transaction(Object source) {
            this.src = source;
        }

        public void begin() {
        }

        public void commit() {
        }

        public Object getSource() {
            return this.src;
        }

        public int getStatus() {
            return 5;
        }

        public void rollback() {
        }

        public void setRollbackOnly() {
        }

        public void setTransactionTimeout(int seconds) {
        }
    }
}

