/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.tree;

import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.transaction.UserTransaction;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.TreeNodeEditor;
import com.metamatrix.common.tree.TreeNodeFilter;
import com.metamatrix.common.tree.TreeNodeIterator;
import com.metamatrix.common.tree.TreeView;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeNode;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeNodeEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DefaultTreeView
implements Comparator,
TreeView {
    private static final char SEPARATOR_CHARACTER = '/';
    private static final String SEPARATOR_STRING = "/";
    private DefaultTreeNode root = null;
    private HashMap childrenMap = null;
    private HashMap parentMap = null;
    private ArrayList rootList = null;
    private transient Object value = null;
    private TreeNodeEditor editor = null;

    public DefaultTreeView() {
        this(new DefaultTreeNode());
    }

    public DefaultTreeView(DefaultTreeNode root) {
        this.root = root;
        this.initializeDefaultTreeView();
    }

    public DefaultTreeView(Object value) {
        this.value = value;
        this.initializeDefaultTreeView();
    }

    public boolean allowsChildren(TreeNode node) {
        return true;
    }

    public boolean allowsChild(TreeNode parent, TreeNode potentialChild) {
        return true;
    }

    public int compare(Object firstNode, Object secondNode) {
        return ((TreeNode)firstNode).compareTo(secondNode);
    }

    public UserTransaction createReadTransaction() {
        throw new UnsupportedOperationException();
    }

    public UserTransaction createWriteTransaction() {
        throw new UnsupportedOperationException();
    }

    public UserTransaction createWriteTransaction(Object source) {
        throw new UnsupportedOperationException();
    }

    public String getAbsolutePath(TreeNode node) {
        return this.getPath(node);
    }

    public DefaultTreeNode getChild(DefaultTreeNode parent, int index) {
        if (this.childrenMap != null && this.childrenMap.containsKey(parent)) {
            List children = (List)this.childrenMap.get(parent);
            if (children == null || children.isEmpty() || index >= children.size()) {
                return null;
            }
            return (DefaultTreeNode)children.get(index);
        }
        return parent.getChild(index);
    }

    public int getChildCount(TreeNode parent) {
        if (this.childrenMap != null && this.childrenMap.containsKey(parent)) {
            List children = (List)this.childrenMap.get(parent);
            if (children == null) {
                return 0;
            }
            return children.size();
        }
        return ((DefaultTreeNode)parent).getChildCount();
    }

    public int getChildIndex(DefaultTreeNode parent, DefaultTreeNode child) {
        if (this.childrenMap != null && this.childrenMap.containsKey(parent)) {
            List children = (List)this.childrenMap.get(parent);
            if (children == null || children.isEmpty()) {
                return -1;
            }
            return children.indexOf(child);
        }
        return parent.getChildIndex(child);
    }

    public List getChildren(TreeNode parent) {
        if (this.childrenMap != null && this.childrenMap.containsKey(parent)) {
            return (List)this.childrenMap.get(parent);
        }
        return ((DefaultTreeNode)parent).getChildren();
    }

    public Iterator iterator() {
        return new TreeNodeIterator((TreeNode)this.getRoot(), (TreeView)this);
    }

    public Iterator iterator(TreeNode startingPoint) {
        return new TreeNodeIterator(startingPoint, (TreeView)this);
    }

    public Comparator getComparator() {
        throw new UnsupportedOperationException();
    }

    public PropertiedObjectEditor getPropertiedObjectEditor() {
        throw new UnsupportedOperationException();
    }

    public TreeNodeFilter getFilter() {
        throw new UnsupportedOperationException();
    }

    public TreeNode getHome() {
        return this.getRoot();
    }

    public TreeNode getParent(TreeNode child) {
        if (this.parentMap != null && this.parentMap.containsKey(child)) {
            return (TreeNode)this.parentMap.get(child);
        }
        return ((DefaultTreeNode)child).getParent();
    }

    public String getPath(TreeNode node) {
        StringBuffer buf = new StringBuffer(47);
        buf.append(node);
        TreeNode parent = this.getParent(node);
        while (parent != null) {
            buf.insert(0, parent);
            buf.insert(0, '/');
            parent = this.getParent(node);
        }
        return buf.toString();
    }

    public List getPropertyDefinitions() {
        throw new UnsupportedOperationException();
    }

    public DefaultTreeNode getRoot() {
        return this.root;
    }

    public List getRoots() {
        if (this.rootList == null) {
            this.rootList = new ArrayList();
            this.rootList.add(this.getRoot());
        } else {
            this.rootList.set(0, this.getRoot());
        }
        return Collections.unmodifiableList(this.rootList);
    }

    public String getSeparator() {
        return SEPARATOR_STRING;
    }

    public char getSeparatorChar() {
        return '/';
    }

    public TreeNodeEditor getTreeNodeEditor() {
        if (this.editor == null) {
            this.editor = new DefaultTreeNodeEditor(this.root, this.parentMap, this.childrenMap);
        }
        return this.editor;
    }

    protected void initializeDefaultTreeView() {
        if (this.root == null) {
            this.root = this.value == null ? new DefaultTreeNode() : (this.value instanceof DefaultTreeNode ? (DefaultTreeNode)this.value : new DefaultTreeNode(this.value.toString()));
        }
    }

    public boolean isAncestorOf(TreeNode ancestor, TreeNode descendent) {
        TreeNode parent;
        do {
            if ((parent = this.getParent(descendent)) == ancestor) {
                return true;
            }
            descendent = parent;
        } while (parent != null);
        return false;
    }

    public boolean isHidden(TreeNode node) {
        throw new UnsupportedOperationException();
    }

    public boolean isMarked(TreeNode node) {
        throw new UnsupportedOperationException();
    }

    public boolean isParentOf(TreeNode parent, TreeNode child) {
        return this.getParent(child) == parent;
    }

    public boolean isRoot(TreeNode node) {
        return this.root == node;
    }

    public void setComparator(Comparator comparator) {
        throw new UnsupportedOperationException();
    }

    public void setFilter(TreeNodeFilter filter) {
        throw new UnsupportedOperationException();
    }

    public void setMarked(TreeNode node, boolean isMarked) {
        throw new UnsupportedOperationException();
    }

    public Set getMarked() {
        throw new UnsupportedOperationException();
    }
}

