/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.util;

import com.metamatrix.core.util.Assertion;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class FileResourceConstants {
    private static Set XMI_FILE_EXTENSIONS = new HashSet();
    public static final String EXTENSION_DELIMITER = ".";
    public static final String XMI_FILE_EXTENSION = ".xmi";
    public static final String XMI_MODEL_FILE_EXTENSION = ".xml";
    public static final String XMI_METAMODEL_FILE_EXTENSION = ".xml";
    public static final String XMI_METAMETAMODEL_FILE_EXTENSION = ".xml";
    public static final String XMI_PROJECT_FILE_EXTENSION = ".prj";
    public static final String XMI_DTC_FILE_EXTENSION = ".xml";
    public static final String ARCHIVE_EXTENSION = ".zip";

    public static Collection getXMIFileExtensions() {
        return Collections.unmodifiableSet(XMI_FILE_EXTENSIONS);
    }

    public static boolean hasXMIFileExtension(String filename) {
        Assertion.isNotNull((Object)filename, (String)"The filename may not be null");
        if (filename.length() == 0 || XMI_FILE_EXTENSIONS.isEmpty()) {
            return false;
        }
        for (String extension : XMI_FILE_EXTENSIONS) {
            if (!filename.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidXMIFileExtension(String extension) {
        String ext = extension;
        if (!extension.startsWith(EXTENSION_DELIMITER)) {
            ext = EXTENSION_DELIMITER + extension;
        }
        return XMI_FILE_EXTENSIONS.contains(ext);
    }

    static {
        XMI_FILE_EXTENSIONS.add(XMI_FILE_EXTENSION);
        XMI_FILE_EXTENSIONS.add(".xml");
        XMI_FILE_EXTENSIONS.add(".xml");
        XMI_FILE_EXTENSIONS.add(".xml");
        XMI_FILE_EXTENSIONS.add(XMI_PROJECT_FILE_EXTENSION);
        XMI_FILE_EXTENSIONS.add(".xml");
        XMI_FILE_EXTENSIONS.add(ARCHIVE_EXTENSION);
    }
}

