/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.ImageIcon;

public class IconFactory {
    private static String defaultJarPath = null;
    private static String defaultRelativePath = ".";

    public static void setDefaultJarPath(String path) {
        defaultJarPath = path;
    }

    public static void setDefaultRelativePath(String path) {
        defaultRelativePath = path;
    }

    public static ImageIcon getIconForImageFile(String fileName) {
        if (defaultJarPath == null || defaultRelativePath == null) {
            throw new RuntimeException("Code Error: IconFactory paths must be set before calling getIconForImageFile");
        }
        return IconFactory.getIconForImageFile(fileName, defaultJarPath, defaultRelativePath);
    }

    public static ImageIcon getIconForImageFile(String fileName, String jarPath, String relativePath) {
        URL url;
        ImageIcon imageIcon = null;
        String path = jarPath.endsWith("/") ? jarPath : jarPath + '/';
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((url = ClassLoader.getSystemResource(path + fileName)) != null) {
            imageIcon = new ImageIcon(url);
        }
        if (imageIcon == null) {
            InputStream imageStream = IconFactory.class.getResourceAsStream(path + fileName);
            if (imageStream != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    int c = 0;
                    while ((c = imageStream.read()) >= 0) {
                        baos.write(c);
                    }
                    Image image = Toolkit.getDefaultToolkit().createImage(baos.toByteArray());
                    imageIcon = new ImageIcon(image);
                }
                catch (IOException e) {
                    imageIcon = new ImageIcon(relativePath + fileName);
                }
            } else {
                path = relativePath.endsWith("/") ? relativePath : relativePath + '/';
                imageIcon = new ImageIcon(path + fileName);
            }
        }
        return imageIcon;
    }
}

