/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.util;

import com.metamatrix.common.properties.TextManager;
import com.metamatrix.toolbox.ui.widget.util.PropertyLoaderException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertyLoader {
    public static final String PROPERTY_PREFIX = "PROPERTY_PREFIX";
    private static final String PROPERTY_DELIM = ".";
    private Properties properties = null;
    private String propertyFile = null;

    public PropertyLoader(String propertiesFile) {
        this.propertyFile = propertiesFile;
    }

    public PropertyLoader(Properties props) {
        this.properties = props;
    }

    public Properties getProperties() throws PropertyLoaderException {
        if (this.properties != null) {
            return this.properties;
        }
        this.properties = new Properties();
        InputStream propStream = this.getClass().getClassLoader().getResourceAsStream(this.propertyFile);
        if (propStream == null) {
            try {
                propStream = new FileInputStream(this.propertyFile);
            }
            catch (FileNotFoundException ex) {
                throw new PropertyLoaderException(TextManager.INSTANCE.getText("ERR.003.030.0032", this.propertyFile));
            }
        }
        try {
            if (propStream != null) {
                this.properties.load(propStream);
                propStream.close();
            }
        }
        catch (IOException e) {
            throw new PropertyLoaderException(TextManager.INSTANCE.getText("ERR.003.030.0032", this.propertyFile));
        }
        return this.properties;
    }

    public Properties getPropertiesBranch(String prefix) throws PropertyLoaderException {
        Properties props = this.getProperties();
        Properties branch = new Properties();
        if (prefix.endsWith(PROPERTY_DELIM)) {
            branch.put(PROPERTY_PREFIX, prefix.substring(0, prefix.length() - 1));
        } else {
            branch.put(PROPERTY_PREFIX, prefix);
        }
        for (String string : props.keySet()) {
            Object val;
            if (!string.startsWith(prefix) || (val = props.get(string)) == null || ((String)val).equals("")) continue;
            int indx = prefix.length();
            String newKey = string.substring(indx);
            if (newKey.startsWith(PROPERTY_DELIM)) {
                newKey = newKey.substring(1);
            }
            branch.put(newKey, val);
        }
        return branch;
    }

    public static void main(String[] args) {
        try {
            Properties testProps = new Properties();
            testProps.setProperty("TestA.A.A", "TestA.A.A value");
            testProps.setProperty("TestA.B.A", "TestA.B.A value");
            testProps.setProperty("TestA.C.A", "TestA.C.A value");
            testProps.setProperty("TestA.D.A", "TestA.D.A value");
            testProps.setProperty("TestA.E.A", "TestA.E.A value");
            testProps.setProperty("TestB.A.A", "TestB.A.A value");
            testProps.setProperty("TestB.B.A", "TestB.B.A value");
            testProps.setProperty("TestB.C.A", "TestB.C.A value");
            testProps.setProperty("TestB.D.A", "TestB.D.A value");
            testProps.setProperty("TestB.E.A", "TestB.E.A value");
            PropertyLoader loader = new PropertyLoader(testProps);
            Properties p = loader.getPropertiesBranch("TestB.");
            for (String string : p.keySet()) {
                String val = (String)p.get(string);
                System.out.print(string + " = " + val + "\n");
            }
        }
        catch (PropertyLoaderException e) {
            e.printStackTrace();
        }
    }
}

