/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.toolbox.ui.widget.util;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;

public final class WidgetUtilities {
    public static void equalizeSizeConstraints(Component[] components) {
        WidgetUtilities.equalizeSizeConstraints(Arrays.asList(components));
    }

    public static void equalizeSizeConstraints(List components) {
        Dimension maxSize = WidgetUtilities.getMaximumPreferredSize(components, true);
        for (Component comp : components) {
            if (!(comp instanceof JComponent)) continue;
            JComponent jComp = (JComponent)comp;
            jComp.setPreferredSize(maxSize);
            jComp.setMinimumSize(maxSize);
            jComp.setMaximumSize(maxSize);
        }
    }

    public static Dimension getMaximumPreferredSize(Component[] components) {
        return WidgetUtilities.getMaximumPreferredSize(components, false);
    }

    public static Dimension getMaximumPreferredSize(Component[] components, boolean reset) {
        return WidgetUtilities.getMaximumPreferredSize(Arrays.asList(components), reset);
    }

    public static Dimension getMaximumPreferredSize(List components) {
        return WidgetUtilities.getMaximumPreferredSize(components, false);
    }

    public static Dimension getMaximumPreferredSize(List components, boolean reset) {
        Dimension maxSize = new Dimension();
        for (Component comp : components) {
            if (comp instanceof JComponent) {
                JComponent jComp = (JComponent)comp;
                if (reset && jComp.isPreferredSizeSet()) {
                    jComp.setPreferredSize(null);
                }
            }
            Dimension size = comp.getPreferredSize();
            maxSize.width = Math.max(maxSize.width, size.width);
            maxSize.height = Math.max(maxSize.height, size.height);
        }
        return maxSize;
    }
}

