/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.uddi.publish;

import com.metamatrix.uddi.UddiPlugin;
import com.metamatrix.uddi.exception.MMUddiException;
import com.metamatrix.uddi.util.MMUddiUtil;
import java.net.MalformedURLException;
import java.security.InvalidParameterException;
import java.util.Vector;
import javax.xml.soap.SOAPException;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Name;
import org.uddi4j.response.AuthToken;
import org.uddi4j.response.DispositionReport;
import org.uddi4j.response.ServiceInfo;
import org.uddi4j.response.ServiceList;
import org.uddi4j.transport.TransportException;
import org.uddi4j.util.FindQualifier;
import org.uddi4j.util.FindQualifiers;

public class UnPublishWSDL {
    public void unpublish(String user, String password, String businessKey, String wsdlUrl, String inquiryUrl, String publishUrl) throws MMUddiException, UDDIException, InvalidParameterException, SOAPException, TransportException, MalformedURLException {
        UDDIProxy proxy = MMUddiUtil.getUddiProxy(inquiryUrl, publishUrl);
        AuthToken token = proxy.get_authToken(user, password);
        Vector<Name> names = new Vector<Name>();
        names.add(new Name(wsdlUrl));
        FindQualifiers findQualifiers = new FindQualifiers();
        Vector<FindQualifier> qualifier = new Vector<FindQualifier>();
        qualifier.add(new FindQualifier("exactNameMatch"));
        findQualifiers.setFindQualifierVector(qualifier);
        ServiceList serviceList = proxy.find_service(businessKey, names, null, null, findQualifiers, 1);
        Vector serviceInfoVector = serviceList.getServiceInfos().getServiceInfoVector();
        ServiceInfo serviceInfo = new ServiceInfo();
        for (int i = 0; i < serviceInfoVector.size(); ++i) {
            serviceInfo = (ServiceInfo)serviceInfoVector.elementAt(i);
        }
        DispositionReport dr = proxy.delete_service(token.getAuthInfoString(), serviceInfo.getServiceKey());
        if (!dr.success()) {
            Object[] parms = new Object[]{dr.getOperator(), dr.getGeneric()};
            String msg = UddiPlugin.Util.getString("UnPublishWSDL.UnpublishWsdl.ErrorDeletingService", parms);
            throw new MMUddiException(msg);
        }
    }
}

