/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.uddi.util;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.uddi.UddiPlugin;
import com.metamatrix.uddi.exception.MMUddiException;
import com.metamatrix.uddi.publish.PublishWSDL;
import com.metamatrix.uddi.publish.UnPublishWSDL;
import com.metamatrix.uddi.query.FindBusiness;
import com.metamatrix.uddi.query.GetWSDL;
import com.metamatrix.uddi.util.UddiHelper;
import java.net.MalformedURLException;
import java.security.InvalidParameterException;
import javax.xml.soap.SOAPException;
import org.uddi4j.UDDIException;
import org.uddi4j.response.BusinessList;
import org.uddi4j.transport.TransportException;

public class MMUddiHelper
implements UddiHelper {
    @Override
    public void publish(String uddiUserName, String uddiPassword, String busKey, String wsdlUrl, String inquiryUrl, String publishUrl) throws MMUddiException {
        PublishWSDL pubWSDL = new PublishWSDL();
        try {
            pubWSDL.publish(uddiUserName, uddiPassword, busKey, wsdlUrl, inquiryUrl, publishUrl);
        }
        catch (TransportException err) {
            this.processException((Exception)((Object)err), "PublishWSDL.TransportException_in_WSDL_publish");
        }
        catch (MalformedURLException err) {
            this.processException(err, "MMUddiHelper.MalformedURLException_in_WSDL_publish");
        }
        catch (UDDIException err) {
            this.processException((Exception)((Object)err), "MMUddiHelper.UDDIException_in_WSDL_publish");
        }
        catch (InvalidParameterException err) {
            this.processException(err, "MMUddiHelper.InvalidParameterException_in_WSDL_publish");
        }
        catch (SOAPException err) {
            this.processException((Exception)((Object)err), "MMUddiHelper.SOAPException_in_WSDL_publish");
        }
    }

    private void processException(Exception err, String msgKey) throws MMUddiException {
        Object[] params = new Object[]{err};
        String msg = UddiPlugin.Util.getString(msgKey, params);
        LogManager.logError((String)this.getClass().getName(), (String)msg);
        throw new MMUddiException(err, msg);
    }

    @Override
    public void unPublish(String UddiUserName, String UddiPassword, String busKey, String wsdlUrl, String inquiryUrl, String publishUrl) throws MMUddiException {
        UnPublishWSDL pubWSDL = new UnPublishWSDL();
        try {
            pubWSDL.unpublish(UddiUserName, UddiPassword, busKey, wsdlUrl, inquiryUrl, publishUrl);
        }
        catch (TransportException err) {
            this.processException((Exception)((Object)err), "MMUddiHelper.TransportException_in_WSDL_unpublish");
        }
        catch (MalformedURLException err) {
            this.processException(err, "MMUddiHelper.MalformedURLException_in_WSDL_unpublish");
        }
        catch (UDDIException err) {
            this.processException((Exception)((Object)err), "MMUddiHelper.UDDIException_in_WSDL_unpublish");
        }
        catch (InvalidParameterException err) {
            this.processException(err, "MMUddiHelper.InvalidParameterException_in_WSDL_unpublish");
        }
        catch (SOAPException err) {
            this.processException((Exception)((Object)err), "MMUddiHelper.SOAPException_in_WSDL_publish");
        }
    }

    @Override
    public BusinessList getAllBusinesses(String inquiryUrl, String publishUrl, int maxRows) throws MMUddiException {
        FindBusiness findBusiness = new FindBusiness();
        BusinessList list = null;
        try {
            list = findBusiness.findBusiness(inquiryUrl, publishUrl, "%", maxRows);
        }
        catch (TransportException err) {
            this.processException((Exception)((Object)err), "MMUddiHelper.TransportException_finding_businesses");
        }
        catch (MalformedURLException err) {
            this.processException(err, "MMUddiHelper.MalformedURLException_all_businesses");
        }
        catch (UDDIException err) {
            this.processException((Exception)((Object)err), "MMUddiHelper.UDDIException_finding_all_businesses");
        }
        catch (InvalidParameterException err) {
            this.processException(err, "MMUddiHelper.InvalidParameterException_finding_all_businesses");
        }
        catch (SOAPException err) {
            this.processException((Exception)((Object)err), "MMUddiHelper.SOAPException_finding_all_businesses");
        }
        return list;
    }

    @Override
    public BusinessList getBusinessByName(String inquiryUrl, String publishUrl, String searchString, int maxRows) throws MMUddiException {
        FindBusiness findBusiness = new FindBusiness();
        BusinessList list = null;
        try {
            list = findBusiness.findBusiness(inquiryUrl, publishUrl, searchString, maxRows);
        }
        catch (TransportException err) {
            this.processException((Exception)((Object)err), "MMUddiHelper.TransportException_finding_businesses_by_name");
        }
        catch (MalformedURLException err) {
            this.processException(err, "MMUddiHelper.MalformedURLException_finding_businesses_by_name");
        }
        catch (UDDIException err) {
            this.processException((Exception)((Object)err), "MMUddiHelper.UDDIException_finding_businesses_by_name");
        }
        catch (InvalidParameterException err) {
            this.processException(err, "MMUddiHelper.InvalidParameterException_finding_businesses_by_name");
        }
        catch (SOAPException err) {
            this.processException((Exception)((Object)err), "MMUddiHelper.SOAPException_finding_businesses_by_name");
        }
        return list;
    }

    @Override
    public boolean isPublished(String UddiUserName, String UddiPassword, String busKey, String wsdlUrl, String inquiryUrl, String publishUrl) throws MMUddiException {
        GetWSDL wsdl = new GetWSDL();
        boolean published = false;
        try {
            published = wsdl.isPublished(UddiUserName, UddiPassword, busKey, wsdlUrl, inquiryUrl, publishUrl);
        }
        catch (MalformedURLException err) {
            this.processException(err, "MMUddiHelper.MalformedURLException_isPublished");
        }
        catch (TransportException err) {
            this.processException((Exception)((Object)err), "MMUddiHelper.TransportException_isPublished");
        }
        catch (UDDIException err) {
            this.processException((Exception)((Object)err), "MMUddiHelper.UDDIException_isPublished");
        }
        return published;
    }
}

