/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.rhq.admin;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.plugins.ManagedObjectImpl;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.GenericValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.teiid.adminapi.Request;
import org.teiid.adminapi.Session;
import org.teiid.adminapi.Transaction;
import org.teiid.adminapi.impl.RequestMetadata;
import org.teiid.adminapi.impl.RequestMetadataMapper;
import org.teiid.rhq.plugin.objects.ExecutedResult;
import org.teiid.rhq.plugin.util.PluginConstants;
import org.teiid.rhq.plugin.util.ProfileServiceUtil;

public class DQPManagementView
implements PluginConstants {
    private static ManagedComponent mc = null;
    private static final Log LOG = LogFactory.getLog((String)"org.rhq");
    private static final MetaValueFactory metaValueFactory = MetaValueFactory.getInstance();

    public Object getMetric(String componentType, String identifier, String metric, Map<String, Object> valueMap) {
        Object resultObject = new Object();
        if (componentType.equals("Platform")) {
            resultObject = this.getPlatformMetric(componentType, metric, valueMap);
        } else if (componentType.equals("Teiid Virtual Database")) {
            resultObject = this.getVdbMetric(componentType, identifier, metric, valueMap);
        }
        return resultObject;
    }

    private Object getPlatformMetric(String componentType, String metric, Map<String, Object> valueMap) {
        Object resultObject = new Object();
        if (metric.equals("queryCount")) {
            resultObject = new Double(this.getQueryCount().doubleValue());
        } else if (metric.equals("sessionCount")) {
            resultObject = new Double(this.getSessionCount().doubleValue());
        } else if (metric.equals("longRunningQueries")) {
            ArrayList<Request> longRunningQueries = new ArrayList<Request>();
            this.getRequestCollectionValue(this.getLongRunningQueries(), longRunningQueries);
            resultObject = new Double(longRunningQueries.size());
        }
        return resultObject;
    }

    private Object getVdbMetric(String componentType, String identifier, String metric, Map<String, Object> valueMap) {
        Object resultObject = new Object();
        if (metric.equals("errorCount")) {
            resultObject = this.getErrorCount((String)valueMap.get("Teiid Virtual Database"));
        } else if (metric.equals("status")) {
            resultObject = DQPManagementView.getVDBStatus((String)valueMap.get("Teiid Virtual Database"), 1);
        } else if (metric.equals("queryCount")) {
            resultObject = new Double(this.getQueryCount().doubleValue());
        } else if (metric.equals("sessionCount")) {
            resultObject = new Double(this.getSessionCount().doubleValue());
        } else if (metric.equals("longRunningQueries")) {
            ArrayList<Request> longRunningQueries = new ArrayList<Request>();
            this.getRequestCollectionValue(this.getLongRunningQueries(), longRunningQueries);
            resultObject = new Double(longRunningQueries.size());
        }
        return resultObject;
    }

    public void executeOperation(ExecutedResult operationResult, Map<String, Object> valueMap) {
        if (operationResult.getComponentType().equals("Platform")) {
            this.executePlatformOperation(operationResult, operationResult.getOperationName(), valueMap);
        } else if (operationResult.getComponentType().equals("Teiid Virtual Database")) {
            this.executeVdbOperation(operationResult, operationResult.getOperationName(), valueMap);
        }
    }

    private void executePlatformOperation(ExecutedResult operationResult, String operationName, Map<String, Object> valueMap) {
        ArrayList<Request> resultObject = new ArrayList<Request>();
        ArrayList<Session> activeSessionsCollection = new ArrayList<Session>();
        ArrayList<Transaction> transactionsCollection = new ArrayList<Transaction>();
        if (operationName.equals("getLongRunningRequests")) {
            List<String> fieldNameList = operationResult.getFieldNameList();
            this.getRequestCollectionValue(this.getLongRunningQueries(), resultObject);
            operationResult.setContent(this.createReportResultList(fieldNameList, resultObject.iterator()));
        } else if (operationName.equals("getSessions")) {
            List<String> fieldNameList = operationResult.getFieldNameList();
            MetaValue sessionMetaValue = this.getSessions();
            DQPManagementView.getSessionCollectionValue(sessionMetaValue, activeSessionsCollection);
            operationResult.setContent(this.createReportResultList(fieldNameList, activeSessionsCollection.iterator()));
        } else if (operationName.equals("getRequests")) {
            List<String> fieldNameList = operationResult.getFieldNameList();
            MetaValue requestMetaValue = this.getRequests();
            this.getRequestCollectionValue(requestMetaValue, resultObject);
            operationResult.setContent(this.createReportResultList(fieldNameList, resultObject.iterator()));
        } else if (operationName.equals("getTransactions")) {
            List<String> fieldNameList = operationResult.getFieldNameList();
            MetaValue transactionMetaValue = this.getTransactions();
            DQPManagementView.getTransactionCollectionValue(transactionMetaValue, transactionsCollection);
            operationResult.setContent(this.createReportResultList(fieldNameList, resultObject.iterator()));
        } else if (operationName.equals("terminateTransaction")) {
            Long sessionID = (Long)valueMap.get("transactionID");
            MetaValue[] args = new MetaValue[]{metaValueFactory.create((Object)sessionID)};
            try {
                DQPManagementView.executeManagedOperation(mc, "terminateTransaction", args);
            }
            catch (Exception e) {
                String msg = "Exception executing operation: terminateTransaction";
                LOG.error((Object)"Exception executing operation: terminateTransaction", (Throwable)e);
            }
        } else if (operationName.equals("terminateSession")) {
            Long sessionID = (Long)valueMap.get("sessionID");
            MetaValue[] args = new MetaValue[]{metaValueFactory.create((Object)sessionID)};
            try {
                DQPManagementView.executeManagedOperation(mc, "terminateSession", args);
            }
            catch (Exception e) {
                String msg = "Exception executing operation: terminateSession";
                LOG.error((Object)"Exception executing operation: terminateSession", (Throwable)e);
            }
        } else if (operationName.equals("cancelRequest")) {
            Long requestID = (Long)valueMap.get("requestID");
            Long sessionID = (Long)valueMap.get("sessionID");
            MetaValue[] args = new MetaValue[]{metaValueFactory.create((Object)requestID), metaValueFactory.create((Object)sessionID)};
            try {
                DQPManagementView.executeManagedOperation(mc, "cancelRequest", args);
            }
            catch (Exception e) {
                String msg = "Exception executing operation: cancelRequest";
                LOG.error((Object)"Exception executing operation: cancelRequest", (Throwable)e);
            }
        }
    }

    private void executeVdbOperation(ExecutedResult operationResult, String operationName, Map<String, Object> valueMap) {
        ArrayList<Request> resultObject = new ArrayList<Request>();
        ArrayList<Session> activeSessionsCollection = new ArrayList<Session>();
        String vdbName = (String)valueMap.get("Teiid Virtual Database");
        String vdbVersion = (String)valueMap.get("version");
        if (operationName.equals("getProperties")) {
            List<String> fieldNameList = operationResult.getFieldNameList();
            this.getProperties("Teiid Virtual Database");
            operationResult.setContent(this.createReportResultList(fieldNameList, resultObject.iterator()));
        } else if (operationName.equals("getSessions")) {
            List<String> fieldNameList = operationResult.getFieldNameList();
            MetaValue sessionMetaValue = this.getSessions();
            DQPManagementView.getSessionCollectionValueForVDB(sessionMetaValue, activeSessionsCollection, vdbName);
            operationResult.setContent(this.createReportResultList(fieldNameList, activeSessionsCollection.iterator()));
        } else if (operationName.equals("getRequestsUsingVDB")) {
            List<String> fieldNameList = operationResult.getFieldNameList();
            MetaValue requestMetaValue = this.getRequestsForVDB(vdbName, Integer.parseInt(vdbVersion));
            this.getRequestCollectionValue(requestMetaValue, resultObject);
            operationResult.setContent(this.createReportResultList(fieldNameList, resultObject.iterator()));
        }
    }

    public MetaValue getProperties(String component) {
        MetaValue propertyValue = null;
        Object args = null;
        try {
            propertyValue = DQPManagementView.executeManagedOperation(mc, "getProperties", args);
        }
        catch (Exception e) {
            String msg = "Exception executing operation: getProperties";
            LOG.error((Object)"Exception executing operation: getProperties", (Throwable)e);
        }
        return propertyValue;
    }

    protected MetaValue getRequests() {
        MetaValue requestsCollection = null;
        Object args = null;
        try {
            requestsCollection = DQPManagementView.executeManagedOperation(mc, "getRequests", args);
        }
        catch (Exception e) {
            String msg = "Exception executing operation: getRequests";
            LOG.error((Object)"Exception executing operation: getRequests", (Throwable)e);
        }
        return requestsCollection;
    }

    protected MetaValue getRequestsForVDB(String vdbName, int vdbVersion) {
        MetaValue requestsCollection = null;
        MetaValue[] args = new MetaValue[]{MetaValueFactory.getInstance().create((Object)vdbName), MetaValueFactory.getInstance().create((Object)vdbVersion)};
        try {
            requestsCollection = DQPManagementView.executeManagedOperation(mc, "getRequestsUsingVDB", args);
        }
        catch (Exception e) {
            String msg = "Exception executing operation: getRequests";
            LOG.error((Object)"Exception executing operation: getRequests", (Throwable)e);
        }
        return requestsCollection;
    }

    protected MetaValue getTransactions() {
        MetaValue transactionsCollection = null;
        Object args = null;
        try {
            transactionsCollection = DQPManagementView.executeManagedOperation(mc, "getTransactions", args);
        }
        catch (Exception e) {
            String msg = "Exception executing operation: getTransactions";
            LOG.error((Object)"Exception executing operation: getTransactions", (Throwable)e);
        }
        return transactionsCollection;
    }

    public MetaValue getSessions() {
        MetaValue sessionCollection = null;
        Object args = null;
        try {
            sessionCollection = DQPManagementView.executeManagedOperation(mc, "getActiveSessions", args);
        }
        catch (Exception e) {
            String msg = "Exception executing operation: getSessions";
            LOG.error((Object)"Exception executing operation: getSessions", (Throwable)e);
        }
        return sessionCollection;
    }

    public static String getVDBStatus(String vdbName, int version) {
        ManagedComponent mcVdb = null;
        try {
            mcVdb = ProfileServiceUtil.getManagedComponent(new ComponentType("teiid", "vdb"), vdbName);
        }
        catch (NamingException e) {
            String msg = "NamingException in getVDBStatus(): " + e.getExplanation();
            LOG.error((Object)msg, (Throwable)e);
        }
        catch (Exception e) {
            String msg = "Exception in getVDBStatus(): " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
        }
        return ProfileServiceUtil.getSimpleValue(mcVdb, "status", String.class);
    }

    public static MetaValue executeManagedOperation(ManagedComponent mc, String operation, MetaValue ... args) throws Exception {
        mc = DQPManagementView.getDQPManagementView(mc);
        for (ManagedOperation mo : mc.getOperations()) {
            String opName = mo.getName();
            if (!opName.equals(operation)) continue;
            try {
                if (args.length == 1 && args[0] == null) {
                    return mo.invoke(new MetaValue[0]);
                }
                return mo.invoke(args);
            }
            catch (Exception e) {
                String msg = "Exception getting the AdminApi in " + operation;
                LOG.error((Object)msg, (Throwable)e);
            }
        }
        throw new Exception("No operation found with given name =" + operation);
    }

    private static ManagedComponent getDQPManagementView(ManagedComponent mc) {
        try {
            mc = ProfileServiceUtil.getDQPManagementView();
        }
        catch (NamingException e) {
            String msg = "NamingException getting the DQPManagementView";
            LOG.error((Object)"NamingException getting the DQPManagementView", (Throwable)e);
        }
        catch (Exception e1) {
            String msg = "Exception getting the DQPManagementView";
            LOG.error((Object)"Exception getting the DQPManagementView", (Throwable)e1);
        }
        return mc;
    }

    public static MetaValue getManagedProperty(ManagedComponent mc, String property, MetaValue ... args) throws Exception {
        mc = DQPManagementView.getDQPManagementView(mc);
        try {
            mc.getProperty(property);
        }
        catch (Exception e) {
            String msg = "Exception getting the AdminApi in " + property;
            LOG.error((Object)msg, (Throwable)e);
        }
        throw new Exception("No property found with given name =" + property);
    }

    private Integer getQueryCount() {
        Integer count = new Integer(0);
        MetaValue requests = null;
        ArrayList<Request> requestsCollection = new ArrayList<Request>();
        requests = this.getRequests();
        this.getRequestCollectionValue(requests, requestsCollection);
        if (requestsCollection != null && !requestsCollection.isEmpty()) {
            count = requestsCollection.size();
        }
        return count;
    }

    private Integer getSessionCount() {
        ArrayList<Session> activeSessionsCollection = new ArrayList<Session>();
        MetaValue sessionMetaValue = this.getSessions();
        DQPManagementView.getSessionCollectionValue(sessionMetaValue, activeSessionsCollection);
        return activeSessionsCollection.size();
    }

    private int getErrorCount(String vdbName) {
        MetaValue[] metaValues;
        String msg;
        ManagedComponent mcVdb = null;
        try {
            mcVdb = ProfileServiceUtil.getManagedComponent(new ComponentType("teiid", "vdb"), vdbName);
        }
        catch (NamingException e) {
            msg = "NamingException in getVDBStatus(): " + e.getExplanation();
            LOG.error((Object)msg, (Throwable)e);
        }
        catch (Exception e) {
            msg = "Exception in getVDBStatus(): " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
        }
        int count = 0;
        ManagedProperty property = mcVdb.getProperty("models");
        CollectionValueSupport valueSupport = (CollectionValueSupport)property.getValue();
        for (MetaValue value : metaValues = valueSupport.getElements()) {
            GenericValueSupport genValueSupport = (GenericValueSupport)value;
            ManagedObjectImpl managedObject = (ManagedObjectImpl)genValueSupport.getValue();
            MetaValue errors = managedObject.getProperty("errors").getValue();
            if (errors == null) continue;
            CollectionValueSupport errorValueSupport = (CollectionValueSupport)errors;
            MetaValue[] errorArray = errorValueSupport.getElements();
            count += errorArray.length;
        }
        return count;
    }

    protected MetaValue getLongRunningQueries() {
        MetaValue requestsCollection = null;
        Object args = null;
        try {
            requestsCollection = DQPManagementView.executeManagedOperation(mc, "getLongRunningRequests", args);
        }
        catch (Exception e) {
            String msg = "Exception executing operation: getLongRunningRequests";
            LOG.error((Object)"Exception executing operation: getLongRunningRequests", (Throwable)e);
        }
        return requestsCollection;
    }

    private void getRequestCollectionValue(MetaValue pValue, Collection<Request> list) {
        MetaType metaType = pValue.getMetaType();
        if (metaType.isCollection()) {
            for (MetaValue value : ((CollectionValueSupport)pValue).getElements()) {
                if (!value.getMetaType().isComposite()) {
                    throw new IllegalStateException(pValue + " is not a Composite type");
                }
                RequestMetadataMapper rmm = new RequestMetadataMapper();
                RequestMetadata request = rmm.unwrapMetaValue(value);
                list.add((Request)request);
            }
        }
    }

    private Collection<Session> getSessionsForVDB(String vdbName) {
        List<Session> activeSessionsCollection = Collections.emptyList();
        MetaValue sessionMetaValue = this.getSessions();
        DQPManagementView.getSessionCollectionValueForVDB(sessionMetaValue, activeSessionsCollection, vdbName);
        return activeSessionsCollection;
    }

    public static <T> void getTransactionCollectionValue(MetaValue pValue, Collection<Transaction> list) {
        MetaType metaType = pValue.getMetaType();
        if (metaType.isCollection()) {
            for (MetaValue value : ((CollectionValueSupport)pValue).getElements()) {
                if (!value.getMetaType().isComposite()) {
                    throw new IllegalStateException(pValue + " is not a Composite type");
                }
                Transaction transaction = (Transaction)MetaValueFactory.getInstance().unwrap(value);
                list.add(transaction);
            }
        }
    }

    public static <T> void getSessionCollectionValue(MetaValue pValue, Collection<Session> list) {
        MetaType metaType = pValue.getMetaType();
        if (metaType.isCollection()) {
            for (MetaValue value : ((CollectionValueSupport)pValue).getElements()) {
                if (!value.getMetaType().isComposite()) {
                    throw new IllegalStateException(pValue + " is not a Composite type");
                }
                Session Session2 = (Session)MetaValueFactory.getInstance().unwrap(value);
                list.add(Session2);
            }
        }
    }

    public static <T> void getSessionCollectionValueForVDB(MetaValue pValue, Collection<Session> list, String vdbName) {
        MetaType metaType = pValue.getMetaType();
        if (metaType.isCollection()) {
            for (MetaValue value : ((CollectionValueSupport)pValue).getElements()) {
                if (value.getMetaType().isComposite()) {
                    Session session = (Session)MetaValueFactory.getInstance().unwrap(value);
                    if (!session.getVDBName().equals(vdbName)) continue;
                    list.add(session);
                    continue;
                }
                throw new IllegalStateException(pValue + " is not a Composite type");
            }
        }
    }

    private Collection createReportResultList(List fieldNameList, Iterator objectIter) {
        ArrayList reportResultList = new ArrayList();
        while (objectIter.hasNext()) {
            Object object = objectIter.next();
            Class<?> cls = null;
            try {
                cls = object.getClass();
                Iterator methodIter = fieldNameList.iterator();
                HashMap<String, Object> reportValueMap = new HashMap<String, Object>();
                while (methodIter.hasNext()) {
                    String fieldName;
                    String methodName = fieldName = (String)methodIter.next();
                    Method meth = cls.getMethod(methodName, null);
                    Object retObj = meth.invoke(object, (Object[])null);
                    reportValueMap.put(fieldName, retObj);
                }
                reportResultList.add(reportValueMap);
            }
            catch (Throwable e) {
                System.err.println(e);
            }
        }
        return reportResultList;
    }
}

