/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.rhq.plugin;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.deployers.spi.management.deploy.DeploymentStatus;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.content.version.PackageVersions;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.teiid.rhq.admin.DQPManagementView;
import org.teiid.rhq.plugin.objects.ExecutedOperationResultImpl;
import org.teiid.rhq.plugin.objects.ExecutedResult;
import org.teiid.rhq.plugin.util.DeploymentUtils;
import org.teiid.rhq.plugin.util.ProfileServiceUtil;

public abstract class Facet
implements ResourceComponent,
MeasurementFacet,
OperationFacet,
ConfigurationFacet,
ContentFacet,
DeleteResourceFacet,
CreateChildResourceFacet {
    protected final Log LOG = LogFactory.getLog((String)"org.rhq");
    protected Configuration resourceConfiguration;
    protected ResourceContext<?> resourceContext;
    protected String name;
    private String identifier;
    protected String componentType;
    protected boolean isAvailable = false;
    private final Log log = LogFactory.getLog(this.getClass());
    protected String deploymentName;
    private PackageVersions versions = null;
    private static final String PKG_TYPE_VDB = "vdb";
    private static final String ARCHITECTURE = "noarch";

    abstract String getComponentType();

    public void start(ResourceContext context) {
        this.resourceContext = context;
        this.deploymentName = context.getResourceKey();
    }

    public void stop() {
        this.isAvailable = false;
    }

    public Configuration getResourceConfiguration() {
        return this.resourceConfiguration;
    }

    public void setResourceConfiguration(Configuration resourceConfiguration) {
        this.resourceConfiguration = resourceConfiguration;
    }

    public String componentType() {
        return this.name;
    }

    protected void setComponentName(String componentName) {
        this.name = componentName;
    }

    public String getComponentIdentifier() {
        return this.identifier;
    }

    protected void setComponentIdentifier(String identifier) {
        this.identifier = identifier;
    }

    protected void setOperationArguments(String name, Configuration configuration, Map<String, Object> argumentMap) {
        throw new InvalidPluginConfigurationException("Not implemented on component type " + this.getComponentType() + " named " + this.name);
    }

    protected void setMetricArguments(String name, Configuration configuration, Map<String, Object> argumentMap) {
        throw new InvalidPluginConfigurationException("Not implemented on component type " + this.getComponentType() + " named " + this.name);
    }

    protected void execute(ExecutedResult result, Map valueMap) {
        DQPManagementView dqp = new DQPManagementView();
        dqp.executeOperation(result, valueMap);
    }

    public AvailabilityType getAvailability() {
        this.LOG.debug((Object)("Checking availability of  " + this.identifier));
        return AvailabilityType.UP;
    }

    protected boolean isAvailable() {
        return true;
    }

    public abstract void getValues(MeasurementReport var1, Set<MeasurementScheduleRequest> var2) throws Exception;

    public OperationResult invokeOperation(String name, Configuration configuration) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        Set operationDefinitionSet = this.resourceContext.getResourceType().getOperationDefinitions();
        ExecutedOperationResultImpl result = new ExecutedOperationResultImpl(this.getComponentType(), name, operationDefinitionSet);
        this.setOperationArguments(name, configuration, valueMap);
        this.execute(result, valueMap);
        return result.getOperationResult();
    }

    public Configuration loadResourceConfiguration() {
        if (this.resourceConfiguration == null) {
            this.resourceConfiguration = this.resourceContext.getPluginConfiguration();
        }
        Configuration config = this.resourceConfiguration;
        return config;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        this.resourceConfiguration = report.getConfiguration().deepCopy();
        Configuration resourceConfig = report.getConfiguration();
        ManagementView managementView = null;
        ComponentType componentType = null;
        if (this.getComponentType().equals("Teiid Virtual Database")) {
            componentType = new ComponentType("teiid", PKG_TYPE_VDB);
        } else {
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            report.setErrorMessage("Update not implemented for the component type.");
        }
        ManagedComponent managedComponent = null;
        report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        try {
            managementView = ProfileServiceUtil.getManagementView(ProfileServiceUtil.getProfileService(), true);
            managedComponent = managementView.getComponent(this.name, componentType);
            Map managedProperties = managedComponent.getProperties();
            ProfileServiceUtil.convertConfigurationToManagedProperties(managedProperties, resourceConfig, this.resourceContext.getResourceType());
            try {
                managementView.updateComponent(managedComponent);
            }
            catch (Exception e) {
                this.LOG.error((Object)("Unable to update component [" + managedComponent.getName() + "] of type " + componentType + "."), (Throwable)e);
                report.setStatus(ConfigurationUpdateStatus.FAILURE);
                report.setErrorMessageFromThrowable((Throwable)e);
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)"Unable to process update request", (Throwable)e);
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            report.setErrorMessageFromThrowable((Throwable)e);
        }
    }

    protected Map<String, ManagedProperty> getManagedProperties() throws Exception {
        return null;
    }

    protected void updateComponent(ManagedComponent managedComponent) throws Exception {
        this.log.trace((Object)("Updating " + this.name + " with component " + managedComponent.toString() + "..."));
        ManagementView managementView = ProfileServiceUtil.getManagementView(ProfileServiceUtil.getProfileService(), false);
        managementView.updateComponent(managedComponent);
    }

    public void deleteResource() throws Exception {
        DeploymentManager deploymentManager = ProfileServiceUtil.getDeploymentManager();
        this.log.debug((Object)("Stopping deployment [" + this.deploymentName + "]..."));
        DeploymentProgress progress = deploymentManager.stop(new String[]{this.deploymentName});
        DeploymentStatus stopStatus = DeploymentUtils.run(progress);
        if (stopStatus.isFailed()) {
            this.log.error((Object)("Failed to stop deployment '" + this.deploymentName + "'."), (Throwable)stopStatus.getFailure());
            throw new Exception("Failed to stop deployment '" + this.deploymentName + "' - cause: " + stopStatus.getFailure());
        }
        this.log.debug((Object)("Removing deployment [" + this.deploymentName + "]..."));
        progress = deploymentManager.remove(new String[]{this.deploymentName});
        DeploymentStatus removeStatus = DeploymentUtils.run(progress);
        if (removeStatus.isFailed()) {
            this.log.error((Object)("Failed to remove deployment '" + this.deploymentName + "'."), (Throwable)removeStatus.getFailure());
            throw new Exception("Failed to remove deployment '" + this.deploymentName + "' - cause: " + removeStatus.getFailure());
        }
    }

    public DeployPackagesResponse deployPackages(Set<ResourcePackageDetails> packages, ContentServices contentServices) {
        return null;
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType arg0) {
        File deploymentFile = null;
        if (this.deploymentName != null) {
            deploymentFile = new File(this.deploymentName.substring(7));
        }
        if (!deploymentFile.exists()) {
            throw new IllegalStateException("Deployment file '" + deploymentFile + "' for " + this.getComponentType() + " does not exist.");
        }
        String fileName = deploymentFile.getName();
        PackageVersions packageVersions = this.loadPackageVersions();
        String version = packageVersions.getVersion(fileName);
        if (version == null) {
            version = "1.0";
            packageVersions.putVersion(fileName, version);
            packageVersions.saveToDisk();
        }
        PackageDetailsKey key = new PackageDetailsKey(fileName, version, PKG_TYPE_VDB, ARCHITECTURE);
        ResourcePackageDetails packageDetails = new ResourcePackageDetails(key);
        packageDetails.setFileName(fileName);
        packageDetails.setLocation(deploymentFile.getPath());
        if (!deploymentFile.isDirectory()) {
            packageDetails.setFileSize(Long.valueOf(deploymentFile.length()));
        }
        packageDetails.setFileCreatedDate(null);
        HashSet<ResourcePackageDetails> packages = new HashSet<ResourcePackageDetails>();
        packages.add(packageDetails);
        return packages;
    }

    public List<DeployPackageStep> generateInstallationSteps(ResourcePackageDetails arg0) {
        return null;
    }

    public RemovePackagesResponse removePackages(Set<ResourcePackageDetails> arg0) {
        return null;
    }

    public InputStream retrievePackageBits(ResourcePackageDetails packageDetails) {
        return null;
    }

    protected static Configuration getDefaultPluginConfiguration(ResourceType resourceType) {
        ConfigurationTemplate pluginConfigDefaultTemplate = resourceType.getPluginConfigurationDefinition().getDefaultTemplate();
        return pluginConfigDefaultTemplate != null ? pluginConfigDefaultTemplate.createConfiguration() : new Configuration();
    }

    public CreateResourceReport createResource(CreateResourceReport report) {
        ResourceType resourceType = report.getResourceType();
        this.createContentBasedResource(report);
        return report;
    }

    private CreateResourceReport createConfigurationBasedResource(CreateResourceReport createResourceReport) {
        ResourceType resourceType = createResourceReport.getResourceType();
        Configuration defaultPluginConfig = Facet.getDefaultPluginConfiguration(resourceType);
        Configuration resourceConfig = createResourceReport.getResourceConfiguration();
        String resourceName = Facet.getResourceName(defaultPluginConfig, resourceConfig);
        ComponentType componentType = ProfileServiceUtil.getComponentType(resourceType);
        ManagementView managementView = null;
        try {
            managementView = ProfileServiceUtil.getManagementView(ProfileServiceUtil.getProfileService(), true);
        }
        catch (NamingException e1) {
            e1.printStackTrace();
        }
        if (ProfileServiceUtil.isManagedComponent(managementView, resourceName, componentType)) {
            createResourceReport.setStatus(CreateResourceStatus.FAILURE);
            createResourceReport.setErrorMessage("A " + resourceType.getName() + " named '" + resourceName + "' already exists.");
            return createResourceReport;
        }
        createResourceReport.setResourceName(resourceName);
        String resourceKey = this.getResourceKey(resourceType, resourceName);
        createResourceReport.setResourceKey(resourceKey);
        PropertySimple templateNameProperty = resourceConfig.getSimple("template-name");
        String templateName = templateNameProperty.getStringValue();
        Set templateNamesSet = managementView.getTemplateNames();
        try {
            DeploymentTemplateInfo template = managementView.getTemplate(templateName);
            Map managedProperties = template.getProperties();
            ProfileServiceUtil.convertConfigurationToManagedProperties(managedProperties, resourceConfig, resourceType);
            this.LOG.debug((Object)("Applying template [" + templateName + "] to create ManagedComponent of type [" + componentType + "]..."));
            try {
                managementView.applyTemplate(resourceName, template);
                managementView.process();
                createResourceReport.setStatus(CreateResourceStatus.SUCCESS);
            }
            catch (Exception e) {
                this.LOG.error((Object)("Unable to apply template [" + templateName + "] to create ManagedComponent of type " + componentType + "."), (Throwable)e);
                createResourceReport.setStatus(CreateResourceStatus.FAILURE);
                createResourceReport.setException((Throwable)e);
            }
        }
        catch (NoSuchDeploymentException e) {
            this.LOG.error((Object)("Unable to find template [" + templateName + "]."), (Throwable)e);
            createResourceReport.setStatus(CreateResourceStatus.FAILURE);
            createResourceReport.setException((Throwable)e);
        }
        catch (Exception e) {
            this.LOG.error((Object)"Unable to process create request", (Throwable)e);
            createResourceReport.setStatus(CreateResourceStatus.FAILURE);
            createResourceReport.setException((Throwable)e);
        }
        return createResourceReport;
    }

    protected void createContentBasedResource(CreateResourceReport createResourceReport) {
        ResourcePackageDetails details = createResourceReport.getPackageDetails();
        PackageDetailsKey key = details.getKey();
        String archivePath = key.getName();
        try {
            File archiveFile = new File(archivePath);
            if (!DeploymentUtils.hasCorrectExtension(archiveFile.getName(), this.resourceContext.getResourceType())) {
                createResourceReport.setStatus(CreateResourceStatus.FAILURE);
                createResourceReport.setErrorMessage("Incorrect extension specified on filename [" + archivePath + "]");
            }
            DeploymentManager deploymentManager = ProfileServiceUtil.getDeploymentManager();
            DeploymentUtils.deployArchive(deploymentManager, archiveFile, false);
            this.deploymentName = archivePath;
            createResourceReport.setResourceName(archivePath);
            createResourceReport.setResourceKey(archivePath);
            createResourceReport.setStatus(CreateResourceStatus.SUCCESS);
        }
        catch (Throwable t) {
            this.log.error((Object)("Error deploying application for report: " + createResourceReport), t);
            createResourceReport.setStatus(CreateResourceStatus.FAILURE);
            createResourceReport.setException(t);
        }
    }

    private static String getResourceName(Configuration pluginConfig, Configuration resourceConfig) {
        PropertySimple resourceNameProp = pluginConfig.getSimple("resourceName");
        if (resourceNameProp == null || resourceNameProp.getStringValue() == null) {
            throw new IllegalStateException("Property [resourceName] is not defined in the default plugin configuration.");
        }
        String resourceNamePropName = resourceNameProp.getStringValue();
        PropertySimple propToUseAsResourceName = resourceConfig.getSimple(resourceNamePropName);
        if (propToUseAsResourceName == null) {
            throw new IllegalStateException("Property [" + resourceNamePropName + "] is not defined in initial Resource configuration.");
        }
        return propToUseAsResourceName.getStringValue();
    }

    private String getResourceKey(ResourceType resourceType, String resourceName) {
        ComponentType componentType = ProfileServiceUtil.getComponentType(resourceType);
        if (componentType == null) {
            throw new IllegalStateException("Unable to map " + resourceType + " to a ComponentType.");
        }
        return componentType.getType() + ":" + componentType.getSubtype() + ":" + resourceName;
    }

    private PackageVersions loadPackageVersions() {
        if (this.versions == null) {
            ResourceType resourceType = this.resourceContext.getResourceType();
            String pluginName = resourceType.getPlugin();
            File dataDirectoryFile = this.resourceContext.getDataDirectory();
            dataDirectoryFile.mkdirs();
            String dataDirectory = dataDirectoryFile.getAbsolutePath();
            this.log.trace((Object)("Creating application versions store with plugin name [" + pluginName + "] and data directory [" + dataDirectory + "]"));
            this.versions = new PackageVersions(pluginName, dataDirectory);
            this.versions.loadFromDisk();
        }
        return this.versions;
    }
}

