/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.rhq.plugin;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.RunState;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.teiid.rhq.admin.DQPManagementView;
import org.teiid.rhq.plugin.Facet;
import org.teiid.rhq.plugin.util.ProfileServiceUtil;

public class PlatformComponent
extends Facet {
    private final Log LOG = LogFactory.getLog((String)"org.rhq");
    String[] PLATFORM_SERVICES_NAMES = new String[]{"org.teiid.jboss.deployers.RuntimeEngineDeployer", "org.teiid.services.BufferServiceImpl", "org.teiid.services.SessionServiceImpl", "org.teiid.transport.SocketConfiguration"};

    @Override
    public void start(ResourceContext context) {
        this.setComponentName(context.getPluginConfiguration().getSimpleValue("name", null));
        this.resourceConfiguration = context.getPluginConfiguration();
        super.start(context);
    }

    @Override
    String getComponentType() {
        return "Platform";
    }

    @Override
    public AvailabilityType getAvailability() {
        RunState runState;
        try {
            runState = ProfileServiceUtil.getDQPManagementView().getRunState();
        }
        catch (NamingException e) {
            this.LOG.error((Object)"Naming exception getting: org.teiid.jboss.deployers.RuntimeEngineDeployer");
            return AvailabilityType.DOWN;
        }
        catch (Exception e) {
            this.LOG.error((Object)"Exception getting: org.teiid.jboss.deployers.RuntimeEngineDeployer");
            return AvailabilityType.DOWN;
        }
        return runState == RunState.RUNNING ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    @Override
    protected void setOperationArguments(String name, Configuration configuration, Map<String, Object> valueMap) {
        if (name.equals("cancelRequest")) {
            valueMap.put("requestID", configuration.getSimple("requestID").getLongValue());
            valueMap.put("sessionID", configuration.getSimple("sessionID").getLongValue());
        } else if (name.equals("cancelRequest")) {
            valueMap.put("transactionID", configuration.getSimple("transactionID").getLongValue());
        } else if (name.equals("terminateSession")) {
            valueMap.put("sessionID", configuration.getSimple("sessionID").getLongValue());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        DQPManagementView view = new DQPManagementView();
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        try {
            for (MeasurementScheduleRequest request : requests) {
                String name = request.getName();
                this.LOG.debug((Object)("Measurement name = " + name));
                Object metricReturnObject = view.getMetric(this.getComponentType(), this.getComponentIdentifier(), name, valueMap);
                try {
                    if (request.getName().equals("queryCount")) {
                        report.addData(new MeasurementDataNumeric(request, (Double)metricReturnObject));
                        continue;
                    }
                    if (request.getName().equals("sessionCount")) {
                        report.addData(new MeasurementDataNumeric(request, (Double)metricReturnObject));
                        continue;
                    }
                    if (!request.getName().equals("longRunningQueries")) continue;
                    report.addData(new MeasurementDataNumeric(request, (Double)metricReturnObject));
                }
                catch (Exception e) {
                    this.LOG.error((Object)("Failed to obtain measurement [" + name + "]. Cause: " + e));
                    throw e;
                    return;
                }
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)("Failed to obtain measurement [" + this.name + "]. Cause: " + e));
            throw e;
        }
    }

    @Override
    public void stop() {
        super.stop();
    }

    @Override
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        this.resourceConfiguration = report.getConfiguration().deepCopy();
        Configuration resourceConfig = report.getConfiguration();
        ManagementView managementView = null;
        ComponentType componentType = new ComponentType("teiid", "dqp");
        ManagedComponent managedComponent = null;
        report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        try {
            managementView = ProfileServiceUtil.getManagementView(ProfileServiceUtil.getProfileService(), true);
            for (String serviceName : this.PLATFORM_SERVICES_NAMES) {
                managedComponent = managementView.getComponent(serviceName, componentType);
                Map managedProperties = managedComponent.getProperties();
                ProfileServiceUtil.convertConfigurationToManagedProperties(managedProperties, resourceConfig, this.resourceContext.getResourceType());
                try {
                    managementView.updateComponent(managedComponent);
                }
                catch (Exception e) {
                    this.LOG.error((Object)("Unable to update component [" + managedComponent.getName() + "] of type " + componentType + "."), (Throwable)e);
                    report.setStatus(ConfigurationUpdateStatus.FAILURE);
                    report.setErrorMessageFromThrowable((Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)"Unable to process update request", (Throwable)e);
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            report.setErrorMessageFromThrowable((Throwable)e);
        }
    }

    @Override
    public Configuration loadResourceConfiguration() {
        Configuration c = this.resourceContext.getPluginConfiguration();
        this.getProperties(c);
        return c;
    }

    private void getProperties(Configuration configuration) {
        Set<ManagedComponent> mcSet = null;
        try {
            mcSet = ProfileServiceUtil.getManagedComponents(new ComponentType("teiid", "dqp"));
        }
        catch (NamingException e) {
            this.LOG.error((Object)("NamingException getting components in Platform loadConfiguration(): " + e.getMessage()));
        }
        catch (Exception e) {
            this.LOG.error((Object)("Exception getting components in Platform loadConfiguration(): " + e.getMessage()));
        }
        for (ManagedComponent mc : mcSet) {
            Map mcMap = mc.getProperties();
            this.setProperties(mcMap, configuration);
        }
    }

    private void setProperties(Map<String, ManagedProperty> mcMap, Configuration configuration) {
        for (ManagedProperty mProp : mcMap.values()) {
            try {
                String value = ProfileServiceUtil.stringValue(mProp.getValue());
                PropertySimple prop = new PropertySimple(mProp.getName(), (Object)value);
                configuration.put((Property)prop);
            }
            catch (Exception e) {
                this.LOG.error((Object)("Exception setting properties in Platform loadConfiguration(): " + e.getMessage()));
            }
        }
    }
}

