/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.rhq.plugin;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.teiid.rhq.plugin.util.ProfileServiceUtil;

public class TranslatorDiscoveryComponent
implements ResourceDiscoveryComponent {
    private final Log log = LogFactory.getLog((String)"org.rhq");

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext discoveryContext) throws InvalidPluginConfigurationException, Exception {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        Set<ManagedComponent> translators = ProfileServiceUtil.getManagedComponents(new ComponentType("teiid", "translator"));
        for (ManagedComponent translator : translators) {
            String translatorKey = translator.getName();
            String translatorName = ProfileServiceUtil.getSimpleValue(translator, "name", String.class);
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(discoveryContext.getResourceType(), translatorKey, translatorName, null, "Teiid Translator", discoveryContext.getDefaultPluginConfiguration(), null);
            Configuration configuration = detail.getPluginConfiguration();
            configuration.put((Property)new PropertySimple("name", (Object)translatorName));
            detail.setPluginConfiguration(configuration);
            ManagedProperty translatorProps = translator.getProperty("property");
            PropertyList list = new PropertyList("translatorList");
            PropertyMap propMap = null;
            TranslatorDiscoveryComponent.getTranslatorValues(translatorProps.getValue(), propMap, list);
            configuration.put((Property)new PropertySimple("name", (Object)translatorName));
            configuration.put((Property)new PropertySimple("type", (Object)ProfileServiceUtil.getSimpleValue(translator, "type", String.class)));
            detail.setPluginConfiguration(configuration);
            discoveredResources.add(detail);
            this.log.debug((Object)("Discovered Teiid Translator: " + translatorName));
        }
        return discoveredResources;
    }

    public static <T> void getTranslatorValues(MetaValue pValue, PropertyMap map, PropertyList list) {
        MetaType metaType = pValue.getMetaType();
        Map unwrappedvalue = null;
        if (metaType.isComposite()) {
            unwrappedvalue = (Map)MetaValueFactory.getInstance().unwrap(pValue);
            for (String key : unwrappedvalue.keySet()) {
                map = new PropertyMap("properties");
                map.put((Property)new PropertySimple("name", (Object)key));
                map.put((Property)new PropertySimple("value", unwrappedvalue.get(key)));
                list.add((Property)map);
            }
        } else {
            throw new IllegalStateException(pValue + " is not a Composite type");
        }
    }
}

