/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.rhq.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedCommon;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.plugins.ManagedObjectImpl;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.GenericValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.teiid.rhq.plugin.Facet;
import org.teiid.rhq.plugin.VDBComponent;
import org.teiid.rhq.plugin.util.ProfileServiceUtil;

public class DataRoleComponent
extends Facet {
    private final Log LOG = LogFactory.getLog((String)"org.rhq");

    @Override
    public void start(ResourceContext context) {
        this.resourceConfiguration = context.getPluginConfiguration();
        this.componentType = "VDB Data Role";
        super.start(context);
    }

    @Override
    public AvailabilityType getAvailability() {
        return ((VDBComponent)this.resourceContext.getParentResourceComponent()).getAvailability();
    }

    @Override
    String getComponentType() {
        return "VDB Data Role";
    }

    @Override
    public void getValues(MeasurementReport arg0, Set<MeasurementScheduleRequest> arg1) throws Exception {
    }

    @Override
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        Configuration resourceConfig = report.getConfiguration();
        this.resourceConfiguration = resourceConfig.deepCopy();
        ManagementView managementView = null;
        ComponentType componentType = new ComponentType("teiid", "vdb");
        ManagedComponent managedComponent = null;
        ManagedProperty anyAuthenticatedMp = null;
        report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        try {
            managementView = this.getConnection().getManagementView();
            managedComponent = managementView.getComponent(((VDBComponent)this.resourceContext.getParentResourceComponent()).name, componentType);
            ManagedProperty mp = managedComponent.getProperty("dataPolicies");
            List dataRolesListMp = (List)MetaValueFactory.getInstance().unwrap(mp.getValue());
            String name = this.resourceConfiguration.getSimpleValue("name", null);
            String anyAuthenticated = this.resourceConfiguration.getSimpleValue("anyAuthenticated", null);
            for (ManagedObject mo : dataRolesListMp) {
                String pname = ProfileServiceUtil.stringValue(mo.getProperty("name").getValue());
                if (!pname.equals(name)) continue;
                anyAuthenticatedMp = mo.getProperty("anyAuthenticated");
                anyAuthenticatedMp.setValue((MetaValue)ProfileServiceUtil.wrap((MetaType)SimpleMetaType.BOOLEAN, anyAuthenticated));
                List mappedRoleNamePropertyList = this.resourceConfiguration.getList("mappedRoleNameList").getList();
                ArrayList<String> mappedRoleNameList = new ArrayList<String>();
                for (Property mappedRoleNameProperty : mappedRoleNamePropertyList) {
                    String mappedRoleNameString = ((PropertyMap)mappedRoleNameProperty).getSimpleValue("name", null);
                    mappedRoleNameList.add(mappedRoleNameString);
                }
                ManagedProperty mappedRoleNameMp = mo.getProperty("mappedRoleNames");
                mappedRoleNameMp.setValue(MetaValueFactory.getInstance().create(mappedRoleNameList));
            }
            try {
                managementView.updateComponent(managedComponent);
            }
            catch (Exception e) {
                this.LOG.error((Object)("Unable to update component [" + managedComponent.getName() + "] of type " + componentType + "."), (Throwable)e);
                report.setStatus(ConfigurationUpdateStatus.FAILURE);
                report.setErrorMessageFromThrowable((Throwable)e);
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)"Unable to process update request", (Throwable)e);
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            report.setErrorMessageFromThrowable((Throwable)e);
        }
    }

    @Override
    public Configuration loadResourceConfiguration() {
        String msg;
        VDBComponent parentComponent = (VDBComponent)this.resourceContext.getParentResourceComponent();
        ManagedComponent mcVdb = null;
        Configuration configuration = this.resourceContext.getPluginConfiguration();
        try {
            mcVdb = ProfileServiceUtil.getManagedComponent(this.getConnection(), new ComponentType("teiid", "vdb"), parentComponent.name);
        }
        catch (NamingException e) {
            msg = "NamingException in loadResourceConfiguration(): " + e.getMessage();
            this.LOG.error((Object)msg, (Throwable)e);
        }
        catch (Exception e) {
            msg = "Exception in loadResourceConfiguration(): " + e.getMessage();
            this.LOG.error((Object)msg, (Throwable)e);
        }
        ManagedProperty property = mcVdb.getProperty("dataPolicies");
        if (property != null) {
            MetaValue[] metaValues;
            CollectionValueSupport valueSupport = (CollectionValueSupport)property.getValue();
            for (MetaValue value : metaValues = valueSupport.getElements()) {
                GenericValueSupport genValueSupport = (GenericValueSupport)value;
                ManagedObjectImpl managedObject = (ManagedObjectImpl)genValueSupport.getValue();
                String dataRoleName = ProfileServiceUtil.getSimpleValue((ManagedCommon)managedObject, "name", String.class);
                Boolean anyAuthenticated = ProfileServiceUtil.getSimpleValue((ManagedCommon)managedObject, "anyAuthenticated", Boolean.class);
                String description = ProfileServiceUtil.getSimpleValue((ManagedCommon)managedObject, "description", String.class);
                configuration.put((Property)new PropertySimple("name", (Object)dataRoleName));
                configuration.put((Property)new PropertySimple("anyAuthenticated", (Object)anyAuthenticated));
                configuration.put((Property)new PropertySimple("description", (Object)description));
                PropertyList mappedRoleNameList = new PropertyList("mappedRoleNameList");
                configuration.put((Property)mappedRoleNameList);
                ManagedProperty mappedRoleNames = managedObject.getProperty("mappedRoleNames");
                if (mappedRoleNames == null) continue;
                List props = (List)MetaValueFactory.getInstance().unwrap(mappedRoleNames.getValue());
                for (String mappedRoleName : props) {
                    PropertyMap mappedRoleNameMap = null;
                    mappedRoleNameMap = new PropertyMap("map", new Property[]{new PropertySimple("name", (Object)mappedRoleName)});
                    mappedRoleNameList.add((Property)mappedRoleNameMap);
                }
            }
        }
        return configuration;
    }

    @Override
    public CreateResourceReport createResource(CreateResourceReport createResourceReport) {
        this.createContentBasedResource(createResourceReport);
        return createResourceReport;
    }

    public ProfileServiceConnection getConnection() {
        return ((VDBComponent)this.resourceContext.getParentResourceComponent()).getConnection();
    }

    public EmsConnection getEmsConnection() {
        return null;
    }
}

