/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.rhq.plugin;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.teiid.rhq.plugin.PlatformComponent;
import org.teiid.rhq.plugin.util.ProfileServiceUtil;

public class VDBDiscoveryComponent
implements ResourceDiscoveryComponent {
    private final Log log = LogFactory.getLog((String)"org.rhq");

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext discoveryContext) throws InvalidPluginConfigurationException, Exception {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        ProfileServiceConnection connection = ((PlatformComponent)discoveryContext.getParentResourceComponent()).getConnection();
        Set<ManagedComponent> vdbs = ProfileServiceUtil.getManagedComponents(connection, new ComponentType("teiid", "vdb"));
        for (ManagedComponent mcVdb : vdbs) {
            String vdbKey;
            String vdbName = vdbKey = mcVdb.getName();
            String fullName = ProfileServiceUtil.getSimpleValue(mcVdb, "fullName", String.class);
            Integer vdbVersion = ProfileServiceUtil.getSimpleValue(mcVdb, "version", Integer.class);
            String vdbDescription = ProfileServiceUtil.getSimpleValue(mcVdb, "description", String.class);
            String vdbStatus = ProfileServiceUtil.getSimpleValue(mcVdb, "status", String.class);
            String vdbURL = ProfileServiceUtil.getSimpleValue(mcVdb, "url", String.class);
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(discoveryContext.getResourceType(), vdbKey, vdbName, vdbVersion.toString(), "Teiid Virtual Database (VDB)", discoveryContext.getDefaultPluginConfiguration(), null);
            Configuration configuration = detail.getPluginConfiguration();
            configuration.put((Property)new PropertySimple("name", (Object)vdbName));
            configuration.put((Property)new PropertySimple("fullName", (Object)fullName));
            configuration.put((Property)new PropertySimple("version", (Object)vdbVersion));
            configuration.put((Property)new PropertySimple("description", (Object)vdbDescription));
            configuration.put((Property)new PropertySimple("status", (Object)vdbStatus));
            configuration.put((Property)new PropertySimple("url", (Object)vdbURL));
            detail.setPluginConfiguration(configuration);
            discoveredResources.add(detail);
            this.log.debug((Object)("Discovered Teiid VDB: " + vdbName));
        }
        return discoveredResources;
    }
}

