/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.rhq.plugin.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.deployers.spi.management.deploy.DeploymentStatus;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.util.exception.ThrowableUtil;

public class DeploymentUtils {
    private static final Log LOG = LogFactory.getLog((String)"org.rhq");

    public static boolean hasCorrectExtension(String archiveFileName, ResourceType resourceType) {
        String expectedExtension = "vdb";
        int lastPeriod = archiveFileName.lastIndexOf(".");
        String extension = lastPeriod != -1 ? archiveFileName.substring(lastPeriod + 1) : null;
        return extension != null && new File(extension).equals(new File(expectedExtension));
    }

    public static void deployArchive(DeploymentManager deploymentManager, File archiveFile, boolean deployExploded) throws Exception {
        URL contentURL;
        String archiveFileName = archiveFile.getName();
        LOG.debug((Object)("Deploying '" + archiveFileName + "' (deployExploded=" + deployExploded + ")..."));
        try {
            contentURL = archiveFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Failed to convert archive file path '" + archiveFile + "' to URL.", e);
        }
        DeploymentUtils.deployAndStart(deploymentManager, contentURL, archiveFileName);
    }

    public static void deployArchive(String fileName, DeploymentManager deploymentManager, URL contentURL, boolean deployExploded) throws Exception {
        String archiveFileName = fileName;
        LOG.debug((Object)("Deploying '" + archiveFileName + "' (deployExploded=" + deployExploded + ")..."));
        DeploymentUtils.deployAndStart(deploymentManager, contentURL, archiveFileName);
    }

    private static void deployAndStart(DeploymentManager deploymentManager, URL contentURL, String archiveFileName) throws Exception {
        DeploymentProgress progress = null;
        Exception distributeFailure = null;
        try {
            progress = deploymentManager.distribute(archiveFileName, contentURL, true);
            DeploymentStatus distributeStatus = DeploymentUtils.run(progress);
            if (distributeStatus.isFailed()) {
                distributeFailure = distributeStatus.getFailure() != null ? distributeStatus.getFailure() : new Exception("Distribute failed for unknown reason.");
            }
        }
        catch (Exception e) {
            distributeFailure = e;
        }
        if (distributeFailure != null) {
            throw new Exception("Failed to distribute '" + contentURL + "' to '" + archiveFileName + "' - cause: " + ThrowableUtil.getAllMessages((Throwable)distributeFailure));
        }
        String[] deploymentNames = progress.getDeploymentID().getRepositoryNames();
        Exception startFailure = null;
        try {
            progress = deploymentManager.start(deploymentNames);
            DeploymentStatus startStatus = DeploymentUtils.run(progress);
            if (startStatus.isFailed()) {
                startFailure = startStatus.getFailure() != null ? startStatus.getFailure() : new Exception("Start failed for unknown reason.");
            }
        }
        catch (Exception e) {
            startFailure = e;
        }
        if (startFailure != null) {
            LOG.error((Object)("Failed to start deployment " + Arrays.asList(deploymentNames) + " during deployment of '" + archiveFileName + "'. Backing out the deployment..."), (Throwable)startFailure);
            Exception removeFailure = null;
            try {
                progress = deploymentManager.remove(deploymentNames);
                DeploymentStatus removeStatus = DeploymentUtils.run(progress);
                if (removeStatus.isFailed()) {
                    removeFailure = removeStatus.getFailure() != null ? removeStatus.getFailure() : new Exception("Remove failed for unknown reason.");
                }
            }
            catch (Exception e) {
                removeFailure = e;
            }
            if (removeFailure != null) {
                LOG.error((Object)("Failed to remove deployment " + Arrays.asList(deploymentNames) + " after start failure."), (Throwable)removeFailure);
            }
            throw new Exception("Failed to start deployment " + Arrays.asList(deploymentNames) + " during deployment of '" + archiveFileName + "' - cause: " + ThrowableUtil.getAllMessages((Throwable)startFailure));
        }
    }

    public static DeploymentStatus run(DeploymentProgress progress) {
        progress.run();
        return progress.getDeploymentStatus();
    }

    private DeploymentUtils() {
    }
}

