/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.rhq.plugin;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedCommon;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.plugins.ManagedObjectImpl;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.GenericValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.teiid.rhq.plugin.VDBComponent;
import org.teiid.rhq.plugin.util.ProfileServiceUtil;

public class DataRoleDiscoveryComponent
implements ResourceDiscoveryComponent {
    private final Log log = LogFactory.getLog((String)"org.rhq");

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext discoveryContext) throws InvalidPluginConfigurationException, Exception {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        VDBComponent parenComponent = (VDBComponent)discoveryContext.getParentResourceComponent();
        ProfileServiceConnection connection = parenComponent.getConnection();
        ManagedComponent mcVdb = ProfileServiceUtil.getManagedComponent(connection, new ComponentType("teiid", "vdb"), parenComponent.name);
        ManagedProperty property = mcVdb.getProperty("dataPolicies");
        if (property != null) {
            MetaValue[] metaValues;
            CollectionValueSupport valueSupport = (CollectionValueSupport)property.getValue();
            for (MetaValue value : metaValues = valueSupport.getElements()) {
                GenericValueSupport genValueSupport = (GenericValueSupport)value;
                ManagedObjectImpl managedObject = (ManagedObjectImpl)genValueSupport.getValue();
                String dataRoleName = ProfileServiceUtil.getSimpleValue((ManagedCommon)managedObject, "name", String.class);
                Boolean anyAuthenticated = ProfileServiceUtil.getSimpleValue((ManagedCommon)managedObject, "anyAuthenticated", Boolean.class);
                String description = ProfileServiceUtil.getSimpleValue((ManagedCommon)managedObject, "description", String.class);
                DiscoveredResourceDetails detail = new DiscoveredResourceDetails(discoveryContext.getResourceType(), dataRoleName, dataRoleName, null, "Data/Security Role for a Teiid Virtual Database (VDB)", discoveryContext.getDefaultPluginConfiguration(), null);
                Configuration configuration = detail.getPluginConfiguration();
                configuration.put((Property)new PropertySimple("name", (Object)dataRoleName));
                configuration.put((Property)new PropertySimple("anyAuthenticated", (Object)anyAuthenticated));
                configuration.put((Property)new PropertySimple("description", (Object)description));
                PropertyList mappedRoleNameList = new PropertyList("mappedRoleNameList");
                configuration.put((Property)mappedRoleNameList);
                ManagedProperty mappedRoleNames = managedObject.getProperty("mappedRoleNames");
                if (mappedRoleNames != null) {
                    CollectionValueSupport props = (CollectionValueSupport)mappedRoleNames.getValue();
                    for (MetaValue mappedRoleName : props.getElements()) {
                        mappedRoleNameList.add((Property)new PropertySimple("name", (Object)ProfileServiceUtil.stringValue(mappedRoleName)));
                    }
                }
                discoveredResources.add(detail);
                this.log.debug((Object)("Discovered Teiid VDB Data Role: " + dataRoleName));
            }
        }
        return discoveredResources;
    }
}

