/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.rhq.plugin;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jbossas5.ApplicationServerComponent;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.teiid.rhq.plugin.util.ProfileServiceUtil;

public class PlatformDiscoveryComponent
implements ResourceDiscoveryComponent {
    private final Log log = LogFactory.getLog((String)"org.rhq");

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext discoveryContext) throws InvalidPluginConfigurationException, Exception {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        ProfileServiceConnection connection = ((ApplicationServerComponent)discoveryContext.getParentResourceComponent()).getConnection();
        ManagedComponent mc = ProfileServiceUtil.getManagedComponent(connection, new ComponentType("teiid", "dqp"), "RuntimeEngineDeployer");
        if (mc == null) {
            return discoveredResources;
        }
        String version = ProfileServiceUtil.getSimpleValue(mc, "runtimeVersion", String.class);
        DiscoveredResourceDetails detail = new DiscoveredResourceDetails(discoveryContext.getResourceType(), mc.getName(), "Data Services", version, "Teiid Data Service Runtime Engine", discoveryContext.getDefaultPluginConfiguration(), null);
        Configuration configuration = detail.getPluginConfiguration();
        configuration.put((Property)new PropertySimple("displayPreviewVDBS", (Object)Boolean.FALSE));
        detail.setPluginConfiguration(configuration);
        discoveredResources.add(detail);
        this.log.debug((Object)("Discovered Teiid instance: " + mc.getName()));
        return discoveredResources;
    }
}

