/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.rhq.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedCommon;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.plugins.ManagedObjectImpl;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.CompositeValueSupport;
import org.jboss.metatype.api.values.EnumValueSupport;
import org.jboss.metatype.api.values.GenericValue;
import org.jboss.metatype.api.values.GenericValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.mc4j.ems.connection.EmsConnection;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.teiid.rhq.admin.DQPManagementView;
import org.teiid.rhq.plugin.Facet;
import org.teiid.rhq.plugin.PlatformComponent;
import org.teiid.rhq.plugin.util.ProfileServiceUtil;

public class VDBComponent
extends Facet {
    private final Log LOG = LogFactory.getLog((String)"org.rhq");

    @Override
    public void start(ResourceContext context) {
        this.setComponentName(context.getPluginConfiguration().getSimpleValue("fullName", null));
        this.resourceConfiguration = context.getPluginConfiguration();
        this.componentType = "Teiid Virtual Database";
        super.start(context);
    }

    @Override
    protected void setOperationArguments(String name, Configuration configuration, Map<String, Object> valueMap) {
        String key = "Teiid Virtual Database";
        valueMap.put(key, this.resourceConfiguration.getSimpleValue("name", null));
        String version = "version";
        valueMap.put(version, this.resourceConfiguration.getSimpleValue("version", null));
        if (name.equals("cancelRequest")) {
            valueMap.put("requestID", configuration.getSimple("requestID").getLongValue());
            valueMap.put("sessionID", configuration.getSimple("sessionID").getLongValue());
        } else if (name.equals("clearCache")) {
            valueMap.put("cacheType", configuration.getSimple("cacheType").getStringValue());
        } else if (name.equals("terminateSession")) {
            valueMap.put("sessionID", configuration.getSimple("sessionID").getLongValue());
        } else if (name.equals("terminateSession")) {
            valueMap.put("sessionID", configuration.getSimple("sessionID").getLongValue());
        } else if (name.equals("reloadMaterializedView")) {
            valueMap.put("schema", configuration.getSimple("schema").getStringValue());
            valueMap.put("table", configuration.getSimple("table").getStringValue());
            valueMap.put("invalidate", configuration.getSimple("invalidate").getBooleanValue());
        }
    }

    @Override
    public AvailabilityType getAvailability() {
        String version = this.resourceConfiguration.getSimpleValue("version", null);
        String status = DQPManagementView.getVDBStatus(this.getConnection(), this.name);
        if (status.equals("ACTIVE")) {
            return AvailabilityType.UP;
        }
        return AvailabilityType.DOWN;
    }

    @Override
    protected void setMetricArguments(String name, Configuration configuration, Map<String, Object> valueMap) {
        String key = "Teiid Virtual Database";
        valueMap.put(key, this.name);
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        DQPManagementView view = new DQPManagementView();
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        this.setMetricArguments("Teiid Virtual Database", null, valueMap);
        for (MeasurementScheduleRequest request : requests) {
            String name = request.getName();
            this.LOG.debug((Object)("Measurement name = " + name));
            Object metricReturnObject = view.getMetric(this.getConnection(), this.getComponentType(), this.getComponentIdentifier(), name, valueMap);
            try {
                if (request.getName().equals("errorCount")) {
                    String message = "";
                    message = (Integer)metricReturnObject > 0 ? "** There are " + (Integer)metricReturnObject + " errors reported for this VDB. See the Configuration tab for details. **" : "** There are no errors reported for this VDB. **";
                    report.addData(new MeasurementDataTrait(request, message));
                    continue;
                }
                if (request.getName().equals("queryCount")) {
                    report.addData(new MeasurementDataTrait(request, (String)metricReturnObject));
                    continue;
                }
                if (request.getName().equals("sessionCount")) {
                    report.addData(new MeasurementDataNumeric(request, (Double)metricReturnObject));
                    continue;
                }
                if (request.getName().equals("status")) {
                    if (((String)metricReturnObject).equals("ACTIVE")) {
                        report.addData(new MeasurementDataTrait(request, "UP"));
                        continue;
                    }
                    report.addData(new MeasurementDataTrait(request, "DOWN"));
                    continue;
                }
                if (!request.getName().equals("longRunningQueries")) continue;
                report.addData(new MeasurementDataNumeric(request, (Double)metricReturnObject));
            }
            catch (Exception e) {
                this.LOG.error((Object)("Failed to obtain measurement [" + name + "]. Cause: " + e));
            }
        }
    }

    @Override
    String getComponentType() {
        return "Teiid Virtual Database";
    }

    @Override
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        Configuration resourceConfig = report.getConfiguration();
        this.resourceConfiguration = resourceConfig.deepCopy();
        super.updateResourceConfiguration(report);
        ManagementView managementView = null;
        ComponentType componentType = new ComponentType("teiid", "vdb");
        ManagedComponent managedComponent = null;
        CollectionValueSupport modelsMetaValue = null;
        report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        try {
            managementView = this.getConnection().getManagementView();
            managedComponent = managementView.getComponent(this.name, componentType);
            modelsMetaValue = (CollectionValueSupport)managedComponent.getProperty("models").getValue();
            GenericValue[] models = (GenericValue[])modelsMetaValue.getElements();
            List multiSourceModelsPropertyList = this.resourceConfiguration.getList("multiSourceModels").getList();
            List singleSourceModelsPropertyList = this.resourceConfiguration.getList("singleSourceModels").getList();
            ArrayList<List> sourceMappingList = new ArrayList<List>();
            sourceMappingList.add(singleSourceModelsPropertyList);
            sourceMappingList.add(multiSourceModelsPropertyList);
            PropertyMap model = null;
            for (List sourceList : sourceMappingList) {
                block5: for (int i = 0; i < sourceList.size(); ++i) {
                    GenericValue[] mappingsArray;
                    model = (PropertyMap)sourceList.get(i);
                    String sourceName = ((PropertySimple)model.get("sourceName")).getStringValue();
                    if (sourceName.equals("See below")) continue;
                    String modelName = ((PropertySimple)model.get("name")).getStringValue();
                    String dsName = ((PropertySimple)model.get("jndiName")).getStringValue();
                    ManagedObject managedModel = null;
                    if (models != null && models.length != 0) {
                        for (GenericValue genValue : models) {
                            ManagedObject mo = (ManagedObject)((GenericValueSupport)genValue).getValue();
                            String name = ProfileServiceUtil.getSimpleValue((ManagedCommon)mo, "name", String.class);
                            if (!modelName.equals(name)) continue;
                            managedModel = mo;
                            break;
                        }
                    }
                    ManagedProperty sourceMappings = null;
                    if (managedModel == null || (sourceMappings = managedModel.getProperty("sourceMappings")) == null) continue;
                    CollectionValueSupport mappings = (CollectionValueSupport)sourceMappings.getValue();
                    for (GenericValue sourceGenValue : mappingsArray = (GenericValue[])mappings.getElements()) {
                        ManagedObject sourceMo = (ManagedObject)((GenericValueSupport)sourceGenValue).getValue();
                        String sName = ProfileServiceUtil.getSimpleValue((ManagedCommon)sourceMo, "name", String.class);
                        if (!sName.equals(sourceName)) continue;
                        ManagedProperty jndiProperty = sourceMo.getProperty("connectionJndiName");
                        jndiProperty.setValue((MetaValue)ProfileServiceUtil.wrap((MetaType)SimpleMetaType.STRING, dsName));
                        continue block5;
                    }
                }
            }
            try {
                managementView.updateComponent(managedComponent);
                managementView.load();
            }
            catch (Exception e) {
                this.LOG.error((Object)("Unable to update component [" + managedComponent.getName() + "] of type " + componentType + "."), (Throwable)e);
                report.setStatus(ConfigurationUpdateStatus.FAILURE);
                report.setErrorMessageFromThrowable((Throwable)e);
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)"Unable to process update request", (Throwable)e);
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            report.setErrorMessageFromThrowable((Throwable)e);
        }
    }

    @Override
    public Configuration loadResourceConfiguration() {
        String msg;
        ManagedComponent mcVdb = null;
        try {
            mcVdb = ProfileServiceUtil.getManagedComponent(this.getConnection(), new ComponentType("teiid", "vdb"), this.name);
        }
        catch (NamingException e) {
            msg = "NamingException in loadResourceConfiguration(): " + e.getExplanation();
            this.LOG.error((Object)msg, (Throwable)e);
        }
        catch (Exception e) {
            msg = "Exception in loadResourceConfiguration(): " + e.getMessage();
            this.LOG.error((Object)msg, (Throwable)e);
        }
        String vdbName = ProfileServiceUtil.getSimpleValue(mcVdb, "name", String.class);
        Integer vdbVersion = ProfileServiceUtil.getSimpleValue(mcVdb, "version", Integer.class);
        String vdbDescription = ProfileServiceUtil.getSimpleValue(mcVdb, "description", String.class);
        String vdbStatus = ProfileServiceUtil.getSimpleValue(mcVdb, "status", String.class);
        String connectionType = ProfileServiceUtil.getSimpleValue(mcVdb, "connectionType", String.class);
        String vdbURL = ProfileServiceUtil.getSimpleValue(mcVdb, "url", String.class);
        Configuration configuration = this.resourceContext.getPluginConfiguration();
        configuration.put((Property)new PropertySimple("name", (Object)vdbName));
        configuration.put((Property)new PropertySimple("version", (Object)vdbVersion));
        configuration.put((Property)new PropertySimple("description", (Object)vdbDescription));
        configuration.put((Property)new PropertySimple("status", (Object)vdbStatus));
        configuration.put((Property)new PropertySimple("url", (Object)vdbURL));
        configuration.put((Property)new PropertySimple("connectionType", (Object)connectionType));
        try {
            this.getTranslators(mcVdb, configuration);
        }
        catch (Exception e) {
            String msg2 = "Exception in loadResourceConfiguration(): " + e.getMessage();
            this.LOG.error((Object)msg2, (Throwable)e);
        }
        this.getModels(mcVdb, configuration);
        return configuration;
    }

    @Override
    public CreateResourceReport createResource(CreateResourceReport createResourceReport) {
        this.createContentBasedResource(createResourceReport);
        return createResourceReport;
    }

    private void getModels(ManagedComponent mcVdb, Configuration configuration) {
        ManagedProperty property = mcVdb.getProperty("models");
        CollectionValueSupport valueSupport = (CollectionValueSupport)property.getValue();
        MetaValue[] metaValues = valueSupport.getElements();
        PropertyList sourceModelsList = new PropertyList("singleSourceModels");
        configuration.put((Property)sourceModelsList);
        PropertyList multiSourceModelsList = new PropertyList("multiSourceModels");
        configuration.put((Property)multiSourceModelsList);
        PropertyList logicalModelsList = new PropertyList("logicalModels");
        configuration.put((Property)logicalModelsList);
        PropertyList errorList = new PropertyList("errorList");
        configuration.put((Property)errorList);
        for (MetaValue value : metaValues) {
            GenericValueSupport genValueSupport = (GenericValueSupport)value;
            ManagedObjectImpl managedObject = (ManagedObjectImpl)genValueSupport.getValue();
            Boolean isSource = Boolean.TRUE;
            try {
                isSource = ProfileServiceUtil.booleanValue(managedObject.getProperty("source").getValue());
            }
            catch (Exception e) {
                this.LOG.error((Object)e.getMessage());
            }
            Boolean supportMultiSource = Boolean.TRUE;
            try {
                supportMultiSource = ProfileServiceUtil.booleanValue(managedObject.getProperty("supportsMultiSourceBindings").getValue());
            }
            catch (Exception e) {
                this.LOG.error((Object)e.getMessage());
            }
            String modelName = managedObject.getName();
            ManagedProperty connectorBinding = managedObject.getProperty("sourceMappings");
            ArrayList<Map<String, String>> sourceList = new ArrayList<Map<String, String>>();
            VDBComponent.getSourceMappingValue(connectorBinding.getValue(), sourceList);
            String visibility = ((SimpleValueSupport)managedObject.getProperty("visible").getValue()).getValue().toString();
            String type = ((EnumValueSupport)managedObject.getProperty("modelType").getValue()).getValue().toString();
            MetaValue errors = managedObject.getProperty("errors").getValue();
            if (errors != null) {
                MetaValue[] metaValueArray;
                CollectionValueSupport errorValueSupport = (CollectionValueSupport)errors;
                for (MetaValue error : metaValueArray = errorValueSupport.getElements()) {
                    GenericValueSupport errorGenValueSupport = (GenericValueSupport)error;
                    ManagedObject errorMo = (ManagedObject)errorGenValueSupport.getValue();
                    String severity = ((SimpleValue)errorMo.getProperty("severity").getValue()).getValue().toString();
                    String message = ((SimpleValue)errorMo.getProperty("value").getValue()).getValue().toString();
                    PropertyMap errorMap = new PropertyMap("errorMap", new Property[]{new PropertySimple("severity", (Object)severity), new PropertySimple("message", (Object)message)});
                    errorList.add((Property)errorMap);
                }
            }
            for (Map map : sourceList) {
                if (isSource.booleanValue()) {
                    String sourceName = (String)map.get("name");
                    String jndiName = (String)map.get("jndiName");
                    String translatorName = (String)map.get("translatorName");
                    PropertyMap multiSourceModel = null;
                    PropertyMap model = null;
                    if (supportMultiSource.booleanValue()) {
                        multiSourceModel = new PropertyMap("map", new Property[]{new PropertySimple("name", (Object)modelName), new PropertySimple("sourceName", (Object)sourceName), new PropertySimple("jndiName", (Object)jndiName), new PropertySimple("translatorName", (Object)translatorName)});
                        multiSourceModelsList.add((Property)multiSourceModel);
                        model = new PropertyMap("map", new Property[]{new PropertySimple("name", (Object)modelName), new PropertySimple("sourceName", (Object)"See below"), new PropertySimple("jndiName", (Object)"See below"), new PropertySimple("translatorName", (Object)"See below"), new PropertySimple("visibility", (Object)visibility), new PropertySimple("supportsMultiSource", (Object)true)});
                        sourceModelsList.add((Property)model);
                        continue;
                    }
                    model = new PropertyMap("map", new Property[]{new PropertySimple("name", (Object)modelName), new PropertySimple("sourceName", (Object)sourceName), new PropertySimple("jndiName", (Object)jndiName), new PropertySimple("translatorName", (Object)translatorName), new PropertySimple("visibility", (Object)visibility), new PropertySimple("supportsMultiSource", (Object)supportMultiSource)});
                    sourceModelsList.add((Property)model);
                    continue;
                }
                PropertyMap model = new PropertyMap("map", new Property[]{new PropertySimple("name", (Object)modelName), new PropertySimple("type", (Object)type), new PropertySimple("visibility", (Object)visibility)});
                logicalModelsList.add((Property)model);
            }
        }
    }

    public static <T> void getSourceMappingValue(MetaValue pValue, Collection<Map<String, String>> list) {
        HashMap<String, String> map = new HashMap<String, String>();
        list.add(map);
        MetaType metaType = pValue.getMetaType();
        if (metaType.isCollection()) {
            for (MetaValue value : ((CollectionValueSupport)pValue).getElements()) {
                GenericValueSupport genValue = (GenericValueSupport)value;
                ManagedObject mo = (ManagedObject)genValue.getValue();
                String sourceName = mo.getName();
                String jndi = ((SimpleValue)mo.getProperty("connectionJndiName").getValue()).getValue().toString();
                String translatorName = ((SimpleValue)mo.getProperty("translatorName").getValue()).getValue().toString();
                map.put("name", sourceName);
                map.put("jndiName", jndi);
                map.put("translatorName", translatorName);
            }
        } else {
            throw new IllegalStateException(pValue + " is not a Collection type");
        }
    }

    private void getTranslators(ManagedComponent mcVdb, Configuration configuration) throws Exception {
        ManagedProperty property = mcVdb.getProperty("overrideTranslators");
        if (property == null) {
            return;
        }
        CollectionValueSupport valueSupport = (CollectionValueSupport)property.getValue();
        MetaValue[] metaValues = valueSupport.getElements();
        PropertyList translatorsList = new PropertyList("translators");
        configuration.put((Property)translatorsList);
        for (MetaValue value : metaValues) {
            GenericValueSupport genValueSupport = (GenericValueSupport)value;
            ManagedObjectImpl managedObject = (ManagedObjectImpl)genValueSupport.getValue();
            String translatorName = ProfileServiceUtil.getSimpleValue((ManagedCommon)managedObject, "name", String.class);
            String translatorType = ProfileServiceUtil.getSimpleValue((ManagedCommon)managedObject, "type", String.class);
            ManagedProperty properties = managedObject.getProperty("property");
            if (properties == null) continue;
            CollectionValueSupport props = (CollectionValueSupport)properties.getValue();
            for (MetaValue propertyMetaData : props) {
                String propertyName = ProfileServiceUtil.stringValue(((CompositeValueSupport)propertyMetaData).get("name"));
                String propertyValue = ProfileServiceUtil.stringValue(((CompositeValueSupport)propertyMetaData).get("value"));
                PropertyMap translatorMap = null;
                translatorMap = new PropertyMap("translatorMap", new Property[]{new PropertySimple("name", (Object)translatorName), new PropertySimple("type", (Object)translatorType), new PropertySimple("propertyName", (Object)propertyName), new PropertySimple("propertyValue", (Object)propertyValue)});
                translatorName = "";
                translatorType = "";
                translatorsList.add((Property)translatorMap);
            }
        }
    }

    public static <T> void getPropertyValues(MetaValue pValue, Collection<Map<String, String>> list) {
        HashMap<String, String> map = new HashMap<String, String>();
        list.add(map);
        MetaType metaType = pValue.getMetaType();
        if (metaType.isCollection()) {
            for (MetaValue value : ((CollectionValueSupport)pValue).getElements()) {
                CompositeValueSupport compValue = (CompositeValueSupport)value;
                for (MetaValue propValue : compValue.values()) {
                    String propertyName = ((CompositeValueSupport)propValue).get("name").toString();
                    String propertyValue = ((CompositeValueSupport)propValue).get("value").toString();
                    map.put("name", propertyName);
                    map.put("value", propertyValue);
                }
            }
        } else {
            throw new IllegalStateException(pValue + " is not a Collection type");
        }
    }

    public ProfileServiceConnection getConnection() {
        return ((PlatformComponent)this.resourceContext.getParentResourceComponent()).getConnection();
    }

    public EmsConnection getEmsConnection() {
        return null;
    }
}

